/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.groups.AbstractMetricGroup;
import org.apache.flink.runtime.metrics.groups.GenericMetricGroup;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MetricGroupTest {
    private MetricRegistry registry;
    private final MetricRegistry exceptionOnRegister = new ExceptionOnRegisterRegistry();

    @Before
    public void createRegistry() {
        this.registry = new MetricRegistry(new Configuration());
    }

    @After
    public void shutdownRegistry() {
        this.registry.shutdown();
        this.registry = null;
    }

    @Test
    public void sameGroupOnNameCollision() {
        GenericMetricGroup group = new GenericMetricGroup(this.registry, (AbstractMetricGroup)new DummyAbstractMetricGroup(this.registry), "somegroup");
        String groupName = "sometestname";
        MetricGroup subgroup1 = group.addGroup(groupName);
        MetricGroup subgroup2 = group.addGroup(groupName);
        Assert.assertNotNull((Object)subgroup1);
        Assert.assertNotNull((Object)subgroup2);
        Assert.assertTrue((subgroup1 == subgroup2 ? 1 : 0) != 0);
    }

    @Test
    public void closedGroupDoesNotRegisterMetrics() {
        GenericMetricGroup group = new GenericMetricGroup(this.exceptionOnRegister, (AbstractMetricGroup)new DummyAbstractMetricGroup(this.exceptionOnRegister), "testgroup");
        Assert.assertFalse((boolean)group.isClosed());
        group.close();
        Assert.assertTrue((boolean)group.isClosed());
        group.counter("testcounter");
        group.gauge("testgauge", (Gauge)new Gauge<Object>(){

            public Object getValue() {
                return null;
            }
        });
    }

    @Test
    public void closedGroupCreatesClosedGroups() {
        GenericMetricGroup group = new GenericMetricGroup(this.exceptionOnRegister, (AbstractMetricGroup)new DummyAbstractMetricGroup(this.exceptionOnRegister), "testgroup");
        Assert.assertFalse((boolean)group.isClosed());
        group.close();
        Assert.assertTrue((boolean)group.isClosed());
        AbstractMetricGroup subgroup = (AbstractMetricGroup)group.addGroup("test subgroup");
        Assert.assertTrue((boolean)subgroup.isClosed());
    }

    @Test
    public void tolerateMetricNameCollisions() {
        String name = "abctestname";
        GenericMetricGroup group = new GenericMetricGroup(this.registry, (AbstractMetricGroup)new DummyAbstractMetricGroup(this.registry), "testgroup");
        Assert.assertNotNull((Object)group.counter("abctestname"));
        Assert.assertNotNull((Object)group.counter("abctestname"));
    }

    @Test
    public void tolerateMetricAndGroupNameCollisions() {
        String name = "abctestname";
        GenericMetricGroup group = new GenericMetricGroup(this.registry, (AbstractMetricGroup)new DummyAbstractMetricGroup(this.registry), "testgroup");
        Assert.assertNotNull((Object)group.addGroup("abctestname"));
        Assert.assertNotNull((Object)group.counter("abctestname"));
    }

    private static class DummyAbstractMetricGroup
    extends AbstractMetricGroup {
        public DummyAbstractMetricGroup(MetricRegistry registry) {
            super(registry, new String[0]);
        }

        protected void addMetric(String name, Metric metric) {
        }

        public MetricGroup addGroup(String name) {
            return new DummyAbstractMetricGroup(this.registry);
        }
    }

    private static class ExceptionOnRegisterRegistry
    extends MetricRegistry {
        public ExceptionOnRegisterRegistry() {
            super(new Configuration());
        }

        public void register(Metric metric, String name, MetricGroup parent) {
            Assert.fail((String)"Metric should never be registered");
        }

        public void unregister(Metric metric, String name, MetricGroup parent) {
            Assert.fail((String)"Metric should never be un-registered");
        }
    }
}

