/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.groups.OperatorMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.util.AbstractID;
import org.junit.Assert;
import org.junit.Test;

public class OperatorGroupTest {
    @Test
    public void testGenerateScopeDefault() {
        MetricRegistry registry = new MetricRegistry(new Configuration());
        TaskManagerMetricGroup tmGroup = new TaskManagerMetricGroup(registry, "theHostName", "test-tm-id");
        TaskManagerJobMetricGroup jmGroup = new TaskManagerJobMetricGroup(registry, tmGroup, new JobID(), "myJobName");
        TaskMetricGroup taskGroup = new TaskMetricGroup(registry, jmGroup, new AbstractID(), new AbstractID(), "aTaskName", 11, 0);
        OperatorMetricGroup opGroup = new OperatorMetricGroup(registry, taskGroup, "myOpName");
        Assert.assertArrayEquals((Object[])new String[]{"theHostName", "taskmanager", "test-tm-id", "myJobName", "myOpName", "11"}, (Object[])opGroup.getScopeComponents());
        Assert.assertEquals((Object)"theHostName.taskmanager.test-tm-id.myJobName.myOpName.11.name", (Object)opGroup.getMetricIdentifier("name"));
        registry.shutdown();
    }
}

