/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.drivers;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.api.java.typeutils.runtime.RuntimeSerializerFactory;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.memory.MemoryType;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.TaskContext;
import org.apache.flink.runtime.operators.testutils.DummyInvokable;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.apache.flink.runtime.taskmanager.TaskManagerRuntimeInfo;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;

public class TestTaskContext<S, T>
implements TaskContext<S, T> {
    private final AbstractInvokable owner = new DummyInvokable();
    private MutableObjectIterator<?> input1;
    private MutableObjectIterator<?> input2;
    private TypeSerializerFactory<?> serializer1;
    private TypeSerializerFactory<?> serializer2;
    private TypeComparator<?> comparator1;
    private TypeComparator<?> comparator2;
    private TaskConfig config = new TaskConfig(new Configuration());
    private S udf;
    private Collector<T> outputCollector;
    private MemoryManager memoryManager;
    private ExecutionConfig executionConfig = new ExecutionConfig();
    private TaskManagerRuntimeInfo taskManageInfo;

    public TestTaskContext() {
    }

    public TestTaskContext(long memoryInBytes) {
        this.memoryManager = new MemoryManager(memoryInBytes, 1, 32768, MemoryType.HEAP, true);
        this.taskManageInfo = new TaskManagerRuntimeInfo("localhost", new Configuration(), System.getProperty("java.io.tmpdir"));
    }

    public <X> void setInput1(MutableObjectIterator<X> input, TypeSerializerFactory<X> serializer) {
        this.input1 = input;
        this.serializer1 = serializer;
    }

    public <X> void setInput2(MutableObjectIterator<X> input, TypeSerializerFactory<X> serializer) {
        this.input2 = input;
        this.serializer2 = serializer;
    }

    public <X> void setInput1(MutableObjectIterator<X> input, TypeSerializer<X> serializer) {
        this.input1 = input;
        this.serializer1 = new RuntimeSerializerFactory(serializer, serializer.createInstance().getClass());
    }

    public <X> void setInput2(MutableObjectIterator<X> input, TypeSerializer<X> serializer) {
        this.input2 = input;
        this.serializer2 = new RuntimeSerializerFactory(serializer, serializer.createInstance().getClass());
    }

    public void setComparator1(TypeComparator<?> comparator) {
        this.comparator1 = comparator;
    }

    public void setComparator2(TypeComparator<?> comparator) {
        this.comparator2 = comparator;
    }

    public void setConfig(TaskConfig config) {
        this.config = config;
    }

    public void setUdf(S udf) {
        this.udf = udf;
    }

    public void setCollector(Collector<T> collector) {
        this.outputCollector = collector;
    }

    public void setDriverStrategy(DriverStrategy strategy) {
        this.config.setDriverStrategy(strategy);
    }

    public void setMutableObjectMode(boolean mutableObjectMode) {
        this.config.setMutableObjectMode(mutableObjectMode);
    }

    public TaskConfig getTaskConfig() {
        return this.config;
    }

    public ExecutionConfig getExecutionConfig() {
        return this.executionConfig;
    }

    public ClassLoader getUserCodeClassLoader() {
        return this.getClass().getClassLoader();
    }

    public MemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    public IOManager getIOManager() {
        return null;
    }

    public TaskManagerRuntimeInfo getTaskManagerInfo() {
        return this.taskManageInfo;
    }

    public <X> MutableObjectIterator<X> getInput(int index) {
        switch (index) {
            case 0: {
                return this.input1;
            }
            case 1: {
                return this.input2;
            }
        }
        throw new RuntimeException();
    }

    public <X> TypeSerializerFactory<X> getInputSerializer(int index) {
        switch (index) {
            case 0: {
                return this.serializer1;
            }
            case 1: {
                return this.serializer2;
            }
        }
        throw new RuntimeException();
    }

    public <X> TypeComparator<X> getDriverComparator(int index) {
        switch (index) {
            case 0: {
                return this.comparator1;
            }
            case 1: {
                return this.comparator2;
            }
        }
        throw new RuntimeException();
    }

    public S getStub() {
        return this.udf;
    }

    public Collector<T> getOutputCollector() {
        return this.outputCollector;
    }

    public AbstractInvokable getContainingTask() {
        return this.owner;
    }

    public String formatLogString(String message) {
        return message;
    }

    public MetricGroup getMetricGroup() {
        return new UnregisteredMetricsGroup();
    }
}

