/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.testutils;

import org.apache.flink.types.IntValue;
import org.apache.flink.types.Record;
import org.apache.flink.types.Value;
import org.apache.flink.util.MutableObjectIterator;

public class UniformRecordGenerator
implements MutableObjectIterator<Record> {
    private IntValue key = new IntValue();
    private IntValue value = new IntValue();
    int numKeys;
    int numVals;
    int keyCnt = 0;
    int valCnt = 0;
    int startKey = 0;
    int startVal = 0;
    boolean repeatKey;

    public UniformRecordGenerator(int numKeys, int numVals, boolean repeatKey) {
        this(numKeys, numVals, 0, 0, repeatKey);
    }

    public UniformRecordGenerator(int numKeys, int numVals, int startKey, int startVal, boolean repeatKey) {
        this.numKeys = numKeys;
        this.numVals = numVals;
        this.startKey = startKey;
        this.startVal = startVal;
        this.repeatKey = repeatKey;
    }

    public Record next(Record reuse) {
        if (!this.repeatKey) {
            if (this.valCnt >= this.numVals + this.startVal) {
                return null;
            }
            this.key.setValue(this.keyCnt++);
            this.value.setValue(this.valCnt);
            if (this.keyCnt == this.numKeys + this.startKey) {
                this.keyCnt = this.startKey;
                ++this.valCnt;
            }
        } else {
            if (this.keyCnt >= this.numKeys + this.startKey) {
                return null;
            }
            this.key.setValue(this.keyCnt);
            this.value.setValue(this.valCnt++);
            if (this.valCnt == this.numVals + this.startVal) {
                this.valCnt = this.startVal;
                ++this.keyCnt;
            }
        }
        reuse.setField(0, (Value)this.key);
        reuse.setField(1, (Value)this.value);
        reuse.updateBinaryRepresenation();
        return reuse;
    }

    public Record next() {
        this.key = new IntValue();
        this.value = new IntValue();
        return this.next(new Record(2));
    }
}

