/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import akka.actor.ActorSystem;
import akka.testkit.JavaTestKit;
import com.typesafe.config.Config;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.instance.InstanceConnectionInfo;
import org.apache.flink.runtime.messages.Messages;
import org.apache.flink.runtime.messages.RegistrationMessages;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.testutils.TestingResourceManager;
import org.apache.flink.util.TestLogger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import scala.Option;

public class ResourceManagerITCase
extends TestLogger {
    private static ActorSystem system;
    private static Configuration config;

    @BeforeClass
    public static void setup() {
        system = AkkaUtils.createActorSystem((Config)AkkaUtils.getDefaultAkkaConfig());
    }

    @AfterClass
    public static void teardown() {
        JavaTestKit.shutdownActorSystem((ActorSystem)system);
    }

    @Test
    public void testResourceManagerReconciliation() {
        new JavaTestKit(system){
            {
                new JavaTestKit.Within(1.duration((String)"10 seconds")){

                    protected void run() {
                        ActorGateway jobManager = TestingUtils.createJobManager(system, config, "ReconciliationTest");
                        ActorGateway me = TestingUtils.createForwardingActor(system, this.getTestActor(), (Option<String>)Option.empty());
                        ResourceID resourceID = ResourceID.generate();
                        jobManager.tell((Object)new RegistrationMessages.RegisterTaskManager(resourceID, (InstanceConnectionInfo)Mockito.mock(InstanceConnectionInfo.class), null, 1), me);
                        this.expectMsgClass(RegistrationMessages.AcknowledgeRegistration.class);
                        ActorGateway resourceManager = TestingUtils.createResourceManager(system, jobManager.actor(), config);
                        resourceManager.tell((Object)new TestingResourceManager.NotifyWhenResourceManagerConnected(), me);
                        this.expectMsgEquals(Messages.getAcknowledge());
                        resourceManager.tell((Object)new TestingResourceManager.GetRegisteredResources(), me);
                        TestingResourceManager.GetRegisteredResourcesReply reply = (TestingResourceManager.GetRegisteredResourcesReply)this.expectMsgClass(TestingResourceManager.GetRegisteredResourcesReply.class);
                        Assert.assertEquals((long)1L, (long)reply.resources.size());
                        Assert.assertTrue((boolean)reply.resources.contains(resourceID));
                    }
                };
            }
        };
    }

    @Test
    public void testResourceManagerTaskManagerRegistration() {
        new JavaTestKit(system){
            {
                new JavaTestKit.Within(2.duration((String)"30 seconds")){

                    protected void run() {
                        ActorGateway jobManager = TestingUtils.createJobManager(system, config, "RegTest");
                        ActorGateway me = TestingUtils.createForwardingActor(system, this.getTestActor(), (Option<String>)Option.empty());
                        ActorGateway resourceManager = TestingUtils.createResourceManager(system, jobManager.actor(), config);
                        resourceManager.tell((Object)new TestingResourceManager.NotifyWhenResourceManagerConnected(), me);
                        this.expectMsgEquals(Messages.getAcknowledge());
                        ActorGateway taskManager = TestingUtils.createTaskManager(system, jobManager.actor(), config, true, true);
                        resourceManager.tell((Object)new TestingResourceManager.GetRegisteredResources(), me);
                        TestingResourceManager.GetRegisteredResourcesReply reply = (TestingResourceManager.GetRegisteredResourcesReply)this.expectMsgClass(TestingResourceManager.GetRegisteredResourcesReply.class);
                        Assert.assertEquals((long)1L, (long)reply.resources.size());
                    }
                };
            }
        };
    }

    static {
        config = new Configuration();
    }
}

