/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.flink.runtime.state.AbstractStateBackend;
import org.apache.flink.runtime.state.StateBackendTestBase;
import org.apache.flink.runtime.state.StateHandle;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.memory.MemoryStateBackend;
import org.junit.Assert;
import org.junit.Test;

public class MemoryStateBackendTest
extends StateBackendTestBase<MemoryStateBackend> {
    @Override
    protected MemoryStateBackend getStateBackend() throws Exception {
        return new MemoryStateBackend();
    }

    @Override
    protected void cleanup() throws Exception {
    }

    @Override
    @Test
    public void testValueStateRestoreWithWrongSerializers() {
    }

    @Override
    @Test
    public void testListStateRestoreWithWrongSerializers() {
    }

    @Override
    @Test
    public void testReducingStateRestoreWithWrongSerializers() {
    }

    @Test
    public void testSerializableState() {
        try {
            MemoryStateBackend backend = new MemoryStateBackend();
            HashMap<String, Integer> state = new HashMap<String, Integer>();
            state.put("hey there", 2);
            state.put("the crazy brown fox stumbles over a sentence that does not contain every letter", 77);
            StateHandle handle = backend.checkpointStateSerializable(state, 12L, 459L);
            Assert.assertNotNull((Object)handle);
            HashMap restored = (HashMap)handle.getState(this.getClass().getClassLoader());
            Assert.assertEquals(state, (Object)restored);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testOversizedState() {
        try {
            MemoryStateBackend backend = new MemoryStateBackend(10);
            HashMap<String, Integer> state = new HashMap<String, Integer>();
            state.put("hey there", 2);
            state.put("the crazy brown fox stumbles over a sentence that does not contain every letter", 77);
            try {
                backend.checkpointStateSerializable(state, 12L, 459L);
                Assert.fail((String)"this should cause an exception");
            }
            catch (IOException iOException) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testStateStream() {
        try {
            MemoryStateBackend backend = new MemoryStateBackend();
            HashMap<String, Integer> state = new HashMap<String, Integer>();
            state.put("hey there", 2);
            state.put("the crazy brown fox stumbles over a sentence that does not contain every letter", 77);
            AbstractStateBackend.CheckpointStateOutputStream os = backend.createCheckpointStateOutputStream(1L, 2L);
            ObjectOutputStream oos = new ObjectOutputStream((OutputStream)os);
            oos.writeObject(state);
            oos.flush();
            StreamStateHandle handle = os.closeAndGetHandle();
            Assert.assertNotNull((Object)handle);
            ObjectInputStream ois = new ObjectInputStream((InputStream)handle.getState(this.getClass().getClassLoader()));
            Assert.assertEquals(state, (Object)ois.readObject());
            Assert.assertTrue((ois.available() <= 0 ? 1 : 0) != 0);
            ois.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testOversizedStateStream() {
        try {
            MemoryStateBackend backend = new MemoryStateBackend(10);
            HashMap<String, Integer> state = new HashMap<String, Integer>();
            state.put("hey there", 2);
            state.put("the crazy brown fox stumbles over a sentence that does not contain every letter", 77);
            AbstractStateBackend.CheckpointStateOutputStream os = backend.createCheckpointStateOutputStream(1L, 2L);
            ObjectOutputStream oos = new ObjectOutputStream((OutputStream)os);
            try {
                oos.writeObject(state);
                oos.flush();
                os.closeAndGetHandle();
                Assert.fail((String)"this should cause an exception");
            }
            catch (IOException iOException) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

