/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Kill;
import akka.actor.Props;
import akka.testkit.JavaTestKit;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.memory.MemoryType;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.clusterframework.FlinkResourceManager;
import org.apache.flink.runtime.clusterframework.standalone.StandaloneResourceManager;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.instance.InstanceConnectionInfo;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.io.network.NetworkEnvironment;
import org.apache.flink.runtime.jobmanager.JobManager;
import org.apache.flink.runtime.jobmanager.MemoryArchivist;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.leaderretrieval.StandaloneLeaderRetrievalService;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.messages.TaskManagerMessages;
import org.apache.flink.runtime.taskmanager.NetworkEnvironmentConfiguration;
import org.apache.flink.runtime.taskmanager.TaskManager;
import org.apache.flink.runtime.taskmanager.TaskManagerConfiguration;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.util.LeaderRetrievalUtils;
import org.junit.Assert;
import org.junit.Test;
import scala.Option;
import scala.Tuple2;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;

public class TaskManagerComponentsStartupShutdownTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testComponentsStartupShutdown() {
        String[] TMP_DIR = new String[]{ConfigConstants.DEFAULT_TASK_MANAGER_TMP_PATH};
        FiniteDuration timeout = new FiniteDuration(100L, TimeUnit.SECONDS);
        int BUFFER_SIZE = 32768;
        Configuration config = new Configuration();
        config.setString("akka.watch.heartbeat.interval", "200 ms");
        config.setString("akka.watch.heartbeat.pause", "1 s");
        config.setInteger("akka.watch.threshold", 1);
        ActorSystem actorSystem = null;
        try {
            actorSystem = AkkaUtils.createLocalActorSystem((Configuration)config);
            ActorRef jobManager = (ActorRef)JobManager.startJobManagerActors((Configuration)config, (ActorSystem)actorSystem, JobManager.class, MemoryArchivist.class)._1();
            FlinkResourceManager.startResourceManagerActors((Configuration)config, (ActorSystem)actorSystem, (LeaderRetrievalService)LeaderRetrievalUtils.createLeaderRetrievalService((Configuration)config, (ActorRef)jobManager), StandaloneResourceManager.class);
            TaskManagerConfiguration tmConfig = new TaskManagerConfiguration(TMP_DIR, 1000000L, timeout, Option.empty(), 1, config);
            NetworkEnvironmentConfiguration netConf = new NetworkEnvironmentConfiguration(32, 32768, MemoryType.HEAP, IOManager.IOMode.SYNC, Option.empty(), new Tuple2((Object)0, (Object)0));
            InstanceConnectionInfo connectionInfo = new InstanceConnectionInfo(InetAddress.getLocalHost(), 10000);
            MemoryManager memManager = new MemoryManager(0x100000L, 1, 32768, MemoryType.HEAP, false);
            IOManagerAsync ioManager = new IOManagerAsync(TMP_DIR);
            NetworkEnvironment network = new NetworkEnvironment((ExecutionContext)TestingUtils.defaultExecutionContext(), timeout, netConf);
            boolean numberOfSlots = true;
            StandaloneLeaderRetrievalService leaderRetrievalService = new StandaloneLeaderRetrievalService(jobManager.path().toString());
            Props tmProps = Props.create(TaskManager.class, (Object[])new Object[]{tmConfig, ResourceID.generate(), connectionInfo, memManager, ioManager, network, 1, leaderRetrievalService});
            final ActorRef taskManager = actorSystem.actorOf(tmProps);
            new JavaTestKit(actorSystem){
                {
                    super(x0);
                    new JavaTestKit.Within(new FiniteDuration(5000L, TimeUnit.SECONDS)){

                        protected void run() {
                            taskManager.tell((Object)TaskManagerMessages.getNotifyWhenRegisteredAtJobManagerMessage(), this.getTestActor());
                            this.expectMsgEquals(TaskManagerMessages.getRegisteredAtJobManagerMessage());
                        }
                    };
                }
            };
            Assert.assertTrue((boolean)network.isAssociated());
            taskManager.tell((Object)Kill.getInstance(), ActorRef.noSender());
            jobManager.tell((Object)Kill.getInstance(), ActorRef.noSender());
            actorSystem.shutdown();
            actorSystem.awaitTermination();
            actorSystem = null;
            Assert.assertFalse((boolean)network.isAssociated());
            Assert.assertTrue((boolean)network.isShutdown());
            Assert.assertTrue((boolean)ioManager.isProperlyShutDown());
            Assert.assertTrue((boolean)memManager.isShutdown());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (actorSystem != null) {
                actorSystem.shutdown();
            }
        }
    }
}

