/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testingUtils;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Kill$;
import akka.actor.Props;
import akka.actor.Props$;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.AkkaUtils$;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointStore;
import org.apache.flink.runtime.client.JobClient;
import org.apache.flink.runtime.clusterframework.FlinkResourceManager;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.execution.librarycache.BlobLibraryCacheManager;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategyFactory;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.instance.AkkaActorGateway;
import org.apache.flink.runtime.instance.InstanceManager;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmanager.JobManager;
import org.apache.flink.runtime.jobmanager.JobManager$;
import org.apache.flink.runtime.jobmanager.MemoryArchivist;
import org.apache.flink.runtime.jobmanager.SubmittedJobGraphStore;
import org.apache.flink.runtime.jobmanager.scheduler.Scheduler;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.leaderretrieval.StandaloneLeaderRetrievalService;
import org.apache.flink.runtime.messages.TaskManagerMessages;
import org.apache.flink.runtime.taskmanager.TaskManager;
import org.apache.flink.runtime.taskmanager.TaskManager$;
import org.apache.flink.runtime.testingUtils.TestingCluster;
import org.apache.flink.runtime.testingUtils.TestingJobManager;
import org.apache.flink.runtime.testingUtils.TestingMemoryArchivist;
import org.apache.flink.runtime.testingUtils.TestingTaskManager;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.testutils.TestingResourceManager;
import org.apache.flink.runtime.util.LeaderRetrievalUtils;
import org.apache.flink.shaded.com.google.common.util.concurrent.MoreExecutors;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple12;
import scala.Tuple13;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TestingUtils$ {
    public static final TestingUtils$ MODULE$;
    private final Config testConfig;
    private final FiniteDuration TESTING_DURATION;
    private final String DEFAULT_AKKA_ASK_TIMEOUT;

    static {
        new TestingUtils$();
    }

    public Config testConfig() {
        return this.testConfig;
    }

    public FiniteDuration TESTING_DURATION() {
        return this.TESTING_DURATION;
    }

    public String DEFAULT_AKKA_ASK_TIMEOUT() {
        return this.DEFAULT_AKKA_ASK_TIMEOUT;
    }

    public String getDefaultTestingActorSystemConfigString() {
        String logLevel = AkkaUtils$.MODULE$.getLogLevel();
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"akka.daemonic = on\n      |akka.test.timefactor = 10\n      |akka.loggers = [\"akka.event.slf4j.Slf4jLogger\"]\n      |akka.loglevel = ", "\n      |akka.stdout-loglevel = OFF\n      |akka.jvm-exit-on-fatal-error = off\n      |akka.log-config-on-start = off\n    "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{logLevel})))).stripMargin();
    }

    public Config getDefaultTestingActorSystemConfig() {
        return this.testConfig();
    }

    public TestingCluster startTestingCluster(int numSlots, int numTMs, String timeout) {
        Configuration config = new Configuration();
        config.setInteger("taskmanager.numberOfTaskSlots", numSlots);
        config.setInteger("local.number-taskmanager", numTMs);
        config.setString("akka.ask.timeout", timeout);
        TestingCluster cluster = new TestingCluster(config);
        cluster.start();
        return cluster;
    }

    public int startTestingCluster$default$2() {
        return 1;
    }

    public String startTestingCluster$default$3() {
        return this.DEFAULT_AKKA_ASK_TIMEOUT();
    }

    public ExecutionContextExecutor defaultExecutionContext() {
        return ExecutionContext$.MODULE$.global();
    }

    public ExecutionContextExecutor directExecutionContext() {
        return ExecutionContext$.MODULE$.fromExecutor(MoreExecutors.directExecutor());
    }

    public TestingUtils.QueuedActionExecutionContext queuedActionExecutionContext() {
        return new TestingUtils.QueuedActionExecutionContext(new TestingUtils.ActionQueue());
    }

    public ActorGateway createTaskManager(ActorSystem actorSystem, ActorRef jobManager, Configuration configuration, boolean useLocalCommunication, boolean waitForRegistration) {
        String jobManagerURL = AkkaUtils$.MODULE$.getAkkaURL(actorSystem, jobManager);
        return this.createTaskManager(actorSystem, jobManagerURL, configuration, useLocalCommunication, waitForRegistration);
    }

    public ActorGateway createTaskManager(ActorSystem actorSystem, ActorGateway jobManager, Configuration configuration, boolean useLocalCommunication, boolean waitForRegistration, Class<? extends TaskManager> taskManagerClass) {
        String jobManagerURL = AkkaUtils$.MODULE$.getAkkaURL(actorSystem, jobManager.actor());
        return this.createTaskManager(actorSystem, jobManagerURL, configuration, useLocalCommunication, waitForRegistration, taskManagerClass);
    }

    public ActorGateway createTaskManager(ActorSystem actorSystem, ActorGateway jobManager, Configuration configuration, boolean useLocalCommunication, boolean waitForRegistration) {
        String jobManagerURL = AkkaUtils$.MODULE$.getAkkaURL(actorSystem, jobManager.actor());
        return this.createTaskManager(actorSystem, jobManagerURL, configuration, useLocalCommunication, waitForRegistration);
    }

    public ActorGateway createTaskManager(ActorSystem actorSystem, String jobManagerURL, Configuration configuration, boolean useLocalCommunication, boolean waitForRegistration) {
        return this.createTaskManager(actorSystem, jobManagerURL, configuration, useLocalCommunication, waitForRegistration, TestingTaskManager.class);
    }

    public ActorGateway createTaskManager(ActorSystem actorSystem, String jobManagerURL, Configuration configuration, boolean useLocalCommunication, boolean waitForRegistration, Class<? extends TaskManager> taskManagerClass) {
        BoxedUnit boxedUnit;
        Configuration resultingConfiguration = new Configuration();
        resultingConfiguration.setInteger("taskmanager.memory.size", 10);
        resultingConfiguration.addAll(configuration);
        Option leaderRetrievalService = Option$.MODULE$.apply((Object)new StandaloneLeaderRetrievalService(jobManagerURL));
        ActorRef taskManager = TaskManager$.MODULE$.startTaskManagerComponentsAndActor(resultingConfiguration, ResourceID.generate(), actorSystem, "localhost", (Option)None$.MODULE$, leaderRetrievalService, useLocalCommunication, taskManagerClass);
        if (waitForRegistration) {
            Future notificationResult = AskableActorRef$.MODULE$.$qmark$extension(akka.pattern.package$.MODULE$.ask(taskManager), (Object)TaskManagerMessages.NotifyWhenRegisteredAtJobManager$.MODULE$, Timeout$.MODULE$.durationToTimeout(this.TESTING_DURATION()));
            boxedUnit = Await$.MODULE$.ready((Awaitable)notificationResult, (Duration)this.TESTING_DURATION());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new AkkaActorGateway(taskManager, null);
    }

    public void stopActor(ActorRef actor) {
        if (actor != null) {
            ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(actor);
            Kill$ x$2 = Kill$.MODULE$;
            ActorRef x$3 = qual$1.$bang$default$2((Object)x$2);
            qual$1.$bang((Object)x$2, x$3);
        }
    }

    public void stopActor(ActorGateway actorGateway) {
        if (actorGateway != null) {
            this.stopActor(actorGateway.actor());
        }
    }

    public ActorGateway createJobManager(ActorSystem actorSystem, Configuration configuration) {
        return this.createJobManager(actorSystem, configuration, TestingJobManager.class, "");
    }

    public ActorGateway createJobManager(ActorSystem actorSystem, Configuration configuration, String prefix) {
        return this.createJobManager(actorSystem, configuration, TestingJobManager.class, prefix);
    }

    public ActorGateway createJobManager(ActorSystem actorSystem, Configuration configuration, ExecutionContext executionContext) {
        Tuple13 tuple13 = JobManager$.MODULE$.createJobManagerComponents(configuration, (Option)None$.MODULE$);
        if (tuple13 != null) {
            Tuple12 tuple12;
            InstanceManager instanceManager = (InstanceManager)tuple13._2();
            Scheduler scheduler = (Scheduler)tuple13._3();
            BlobLibraryCacheManager libraryCacheManager = (BlobLibraryCacheManager)tuple13._4();
            RestartStrategyFactory restartStrategy = (RestartStrategyFactory)tuple13._5();
            FiniteDuration timeout = (FiniteDuration)tuple13._6();
            int archiveCount = BoxesRunTime.unboxToInt((Object)tuple13._7());
            LeaderElectionService leaderElectionService = (LeaderElectionService)tuple13._8();
            SubmittedJobGraphStore submittedJobGraphs = (SubmittedJobGraphStore)tuple13._9();
            CheckpointRecoveryFactory checkpointRecoveryFactory = (CheckpointRecoveryFactory)tuple13._10();
            SavepointStore savepointStore = (SavepointStore)tuple13._11();
            FiniteDuration jobRecoveryTimeout = (FiniteDuration)tuple13._12();
            Option metricsRegistry = (Option)tuple13._13();
            Tuple12 tuple122 = tuple12 = new Tuple12((Object)instanceManager, (Object)scheduler, (Object)libraryCacheManager, (Object)restartStrategy, (Object)timeout, (Object)BoxesRunTime.boxToInteger((int)archiveCount), (Object)leaderElectionService, (Object)submittedJobGraphs, (Object)checkpointRecoveryFactory, (Object)savepointStore, (Object)jobRecoveryTimeout, (Object)metricsRegistry);
            InstanceManager instanceManager2 = (InstanceManager)tuple122._1();
            Scheduler scheduler2 = (Scheduler)tuple122._2();
            BlobLibraryCacheManager libraryCacheManager2 = (BlobLibraryCacheManager)tuple122._3();
            RestartStrategyFactory restartStrategy2 = (RestartStrategyFactory)tuple122._4();
            FiniteDuration timeout2 = (FiniteDuration)tuple122._5();
            int archiveCount2 = BoxesRunTime.unboxToInt((Object)tuple122._6());
            LeaderElectionService leaderElectionService2 = (LeaderElectionService)tuple122._7();
            SubmittedJobGraphStore submittedJobGraphs2 = (SubmittedJobGraphStore)tuple122._8();
            CheckpointRecoveryFactory checkpointRecoveryFactory2 = (CheckpointRecoveryFactory)tuple122._9();
            SavepointStore savepointStore2 = (SavepointStore)tuple122._10();
            FiniteDuration jobRecoveryTimeout2 = (FiniteDuration)tuple122._11();
            Option metricsRegistry2 = (Option)tuple122._12();
            Props archiveProps = Props$.MODULE$.apply(TestingMemoryArchivist.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)archiveCount2)}));
            ActorRef archive = actorSystem.actorOf(archiveProps, JobManager$.MODULE$.ARCHIVE_NAME());
            Props jobManagerProps = Props$.MODULE$.apply(TestingJobManager.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configuration, executionContext, instanceManager2, scheduler2, libraryCacheManager2, archive, restartStrategy2, timeout2, leaderElectionService2, submittedJobGraphs2, checkpointRecoveryFactory2, jobRecoveryTimeout2, metricsRegistry2}));
            ActorRef jobManager = actorSystem.actorOf(jobManagerProps, JobManager$.MODULE$.JOB_MANAGER_NAME());
            return new AkkaActorGateway(jobManager, null);
        }
        throw new MatchError((Object)tuple13);
    }

    public ActorGateway createJobManager(ActorSystem actorSystem, Configuration configuration, Class<? extends JobManager> jobManagerClass) {
        return this.createJobManager(actorSystem, configuration, jobManagerClass, "");
    }

    public ActorGateway createJobManager(ActorSystem actorSystem, Configuration configuration, Class<? extends JobManager> jobManagerClass, String prefix) {
        configuration.setString("recovery.mode", ConfigConstants.DEFAULT_RECOVERY_MODE);
        Tuple2 tuple2 = JobManager$.MODULE$.startJobManagerActors(configuration, actorSystem, (Option)new Some((Object)new StringBuilder().append((Object)prefix).append((Object)JobManager$.MODULE$.JOB_MANAGER_NAME()).toString()), (Option)new Some((Object)new StringBuilder().append((Object)prefix).append((Object)JobManager$.MODULE$.ARCHIVE_NAME()).toString()), jobManagerClass, MemoryArchivist.class);
        if (tuple2 != null) {
            ActorRef actor;
            ActorRef actorRef;
            ActorRef actor2 = actorRef = (actor = (ActorRef)tuple2._1());
            return new AkkaActorGateway(actor2, null);
        }
        throw new MatchError((Object)tuple2);
    }

    public ActorGateway createForwardingActor(ActorSystem actorSystem, ActorRef forwardingTarget, Option<String> actorName) {
        Option<String> option;
        block4: {
            ActorRef actorRef;
            block3: {
                block2: {
                    option = actorName;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String name = (String)some.x();
                    actorRef = actorSystem.actorOf(Props$.MODULE$.apply(TestingUtils.ForwardingActor.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{forwardingTarget, None$.MODULE$})), name);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<String> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                actorRef = actorSystem.actorOf(Props$.MODULE$.apply(TestingUtils.ForwardingActor.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{forwardingTarget, None$.MODULE$})));
            }
            ActorRef actor = actorRef;
            return new AkkaActorGateway(actor, null);
        }
        throw new MatchError(option);
    }

    public Option<String> createForwardingActor$default$3() {
        return None$.MODULE$;
    }

    public JobExecutionResult submitJobAndWait(ActorSystem actorSystem, ActorGateway jobManager, JobGraph jobGraph) {
        String jobManagerURL = AkkaUtils$.MODULE$.getAkkaURL(actorSystem, jobManager.actor());
        StandaloneLeaderRetrievalService leaderRetrievalService = new StandaloneLeaderRetrievalService(jobManagerURL);
        return JobClient.submitJobAndWait((ActorSystem)actorSystem, (LeaderRetrievalService)leaderRetrievalService, (JobGraph)jobGraph, (FiniteDuration)this.TESTING_DURATION(), (boolean)false, (ClassLoader)Thread.currentThread().getContextClassLoader());
    }

    public ActorGateway createResourceManager(ActorSystem actorSystem, ActorRef jobManager, Configuration configuration) {
        configuration.setString("recovery.mode", ConfigConstants.DEFAULT_RECOVERY_MODE);
        ActorRef actor = FlinkResourceManager.startResourceManagerActors((Configuration)configuration, (ActorSystem)actorSystem, (LeaderRetrievalService)LeaderRetrievalUtils.createLeaderRetrievalService((Configuration)configuration, (ActorRef)jobManager), TestingResourceManager.class);
        return new AkkaActorGateway(actor, null);
    }

    private TestingUtils$() {
        MODULE$ = this;
        this.testConfig = ConfigFactory.parseString((String)this.getDefaultTestingActorSystemConfigString());
        this.TESTING_DURATION = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(2)).minute();
        this.DEFAULT_AKKA_ASK_TIMEOUT = "200 s";
    }
}

