/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import org.apache.flink.runtime.util.JarFileCreator;
import org.apache.flink.runtime.util.jartestprogram.AnonymousInNonStaticMethod;
import org.apache.flink.runtime.util.jartestprogram.AnonymousInNonStaticMethod2;
import org.apache.flink.runtime.util.jartestprogram.AnonymousInStaticMethod;
import org.apache.flink.runtime.util.jartestprogram.NestedAnonymousInnerClass;
import org.apache.flink.runtime.util.jartestprogram.WordCountWithAnonymousClass;
import org.apache.flink.runtime.util.jartestprogram.WordCountWithExternalClass;
import org.apache.flink.runtime.util.jartestprogram.WordCountWithExternalClass2;
import org.apache.flink.runtime.util.jartestprogram.WordCountWithInnerClass;
import org.junit.Assert;
import org.junit.Test;

public class JarFileCreatorTest {
    @Test
    public void TestAnonymousInnerClassTrick1() throws Exception {
        File out = new File(System.getProperty("java.io.tmpdir"), "jarcreatortest.jar");
        JarFileCreator jfc = new JarFileCreator(out);
        jfc.addClass(AnonymousInStaticMethod.class).createJarFile();
        HashSet<String> ans = new HashSet<String>();
        ans.add("org/apache/flink/runtime/util/jartestprogram/AnonymousInStaticMethod$1.class");
        ans.add("org/apache/flink/runtime/util/jartestprogram/AnonymousInStaticMethod$A.class");
        ans.add("org/apache/flink/runtime/util/jartestprogram/AnonymousInStaticMethod.class");
        Assert.assertTrue((String)"Jar file for Anonymous Inner Class is not correct", (boolean)this.validate(ans, out));
        out.delete();
    }

    @Test
    public void TestAnonymousInnerClassTrick2() throws Exception {
        File out = new File(System.getProperty("java.io.tmpdir"), "jarcreatortest.jar");
        JarFileCreator jfc = new JarFileCreator(out);
        jfc.addClass(AnonymousInNonStaticMethod.class).createJarFile();
        HashSet<String> ans = new HashSet<String>();
        ans.add("org/apache/flink/runtime/util/jartestprogram/AnonymousInNonStaticMethod$1.class");
        ans.add("org/apache/flink/runtime/util/jartestprogram/AnonymousInNonStaticMethod$A.class");
        ans.add("org/apache/flink/runtime/util/jartestprogram/AnonymousInNonStaticMethod.class");
        Assert.assertTrue((String)"Jar file for Anonymous Inner Class is not correct", (boolean)this.validate(ans, out));
        out.delete();
    }

    @Test
    public void TestAnonymousInnerClassTrick3() throws Exception {
        File out = new File(System.getProperty("java.io.tmpdir"), "jarcreatortest.jar");
        JarFileCreator jfc = new JarFileCreator(out);
        jfc.addClass(AnonymousInNonStaticMethod2.class).createJarFile();
        HashSet<String> ans = new HashSet<String>();
        ans.add("org/apache/flink/runtime/util/jartestprogram/AnonymousInNonStaticMethod2$1.class");
        ans.add("org/apache/flink/runtime/util/jartestprogram/AnonymousInNonStaticMethod2$A.class");
        ans.add("org/apache/flink/runtime/util/jartestprogram/AnonymousInNonStaticMethod2.class");
        Assert.assertTrue((String)"Jar file for Anonymous Inner Class is not correct", (boolean)this.validate(ans, out));
        out.delete();
    }

    @Test
    public void TestAnonymousInnerClassTrick4() throws Exception {
        File out = new File(System.getProperty("java.io.tmpdir"), "jarcreatortest.jar");
        JarFileCreator jfc = new JarFileCreator(out);
        jfc.addClass(NestedAnonymousInnerClass.class).createJarFile();
        HashSet<String> ans = new HashSet<String>();
        ans.add("org/apache/flink/runtime/util/jartestprogram/NestedAnonymousInnerClass.class");
        ans.add("org/apache/flink/runtime/util/jartestprogram/NestedAnonymousInnerClass$1$1.class");
        ans.add("org/apache/flink/runtime/util/jartestprogram/NestedAnonymousInnerClass$1.class");
        ans.add("org/apache/flink/runtime/util/jartestprogram/NestedAnonymousInnerClass$A.class");
        Assert.assertTrue((String)"Jar file for Anonymous Inner Class is not correct", (boolean)this.validate(ans, out));
        out.delete();
    }

    @Test
    public void TestExternalClass() throws IOException {
        File out = new File(System.getProperty("java.io.tmpdir"), "jarcreatortest.jar");
        JarFileCreator jfc = new JarFileCreator(out);
        jfc.addClass(WordCountWithExternalClass.class).createJarFile();
        HashSet<String> ans = new HashSet<String>();
        ans.add("org/apache/flink/runtime/util/jartestprogram/StaticData.class");
        ans.add("org/apache/flink/runtime/util/jartestprogram/WordCountWithExternalClass.class");
        ans.add("org/apache/flink/runtime/util/jartestprogram/ExternalTokenizer.class");
        Assert.assertTrue((String)"Jar file for External Class is not correct", (boolean)this.validate(ans, out));
        out.delete();
    }

    @Test
    public void TestInnerClass() throws IOException {
        File out = new File(System.getProperty("java.io.tmpdir"), "jarcreatortest.jar");
        JarFileCreator jfc = new JarFileCreator(out);
        jfc.addClass(WordCountWithInnerClass.class).createJarFile();
        HashSet<String> ans = new HashSet<String>();
        ans.add("org/apache/flink/runtime/util/jartestprogram/StaticData.class");
        ans.add("org/apache/flink/runtime/util/jartestprogram/WordCountWithInnerClass.class");
        ans.add("org/apache/flink/runtime/util/jartestprogram/WordCountWithInnerClass$Tokenizer.class");
        Assert.assertTrue((String)"Jar file for Inner Class is not correct", (boolean)this.validate(ans, out));
        out.delete();
    }

    @Test
    public void TestAnonymousClass() throws IOException {
        File out = new File(System.getProperty("java.io.tmpdir"), "jarcreatortest.jar");
        JarFileCreator jfc = new JarFileCreator(out);
        jfc.addClass(WordCountWithAnonymousClass.class).createJarFile();
        HashSet<String> ans = new HashSet<String>();
        ans.add("org/apache/flink/runtime/util/jartestprogram/StaticData.class");
        ans.add("org/apache/flink/runtime/util/jartestprogram/WordCountWithAnonymousClass.class");
        ans.add("org/apache/flink/runtime/util/jartestprogram/WordCountWithAnonymousClass$1.class");
        Assert.assertTrue((String)"Jar file for Anonymous Class is not correct", (boolean)this.validate(ans, out));
        out.delete();
    }

    @Test
    public void TestExtendIdentifier() throws IOException {
        File out = new File(System.getProperty("java.io.tmpdir"), "jarcreatortest.jar");
        JarFileCreator jfc = new JarFileCreator(out);
        jfc.addClass(WordCountWithExternalClass2.class).createJarFile();
        HashSet<String> ans = new HashSet<String>();
        ans.add("org/apache/flink/runtime/util/jartestprogram/StaticData.class");
        ans.add("org/apache/flink/runtime/util/jartestprogram/WordCountWithExternalClass2.class");
        ans.add("org/apache/flink/runtime/util/jartestprogram/ExternalTokenizer2.class");
        ans.add("org/apache/flink/runtime/util/jartestprogram/ExternalTokenizer.class");
        Assert.assertTrue((String)"Jar file for Extend Identifier is not correct", (boolean)this.validate(ans, out));
        out.delete();
    }

    @Test
    public void TestUDFPackage() throws IOException {
        File out = new File(System.getProperty("java.io.tmpdir"), "jarcreatortest.jar");
        JarFileCreator jfc = new JarFileCreator(out);
        jfc.addClass(WordCountWithInnerClass.class).addPackage("org.apache.flink.util").createJarFile();
        HashSet<String> ans = new HashSet<String>();
        ans.add("org/apache/flink/runtime/util/jartestprogram/StaticData.class");
        ans.add("org/apache/flink/runtime/util/jartestprogram/WordCountWithInnerClass.class");
        ans.add("org/apache/flink/runtime/util/jartestprogram/WordCountWithInnerClass$Tokenizer.class");
        ans.add("org/apache/flink/util/Collector.class");
        Assert.assertTrue((String)"Jar file for UDF package is not correct", (boolean)this.validate(ans, out));
        out.delete();
    }

    private boolean validate(Set<String> expected, File out) throws IOException {
        ZipEntry ze;
        JarInputStream jis = new JarInputStream(new FileInputStream(out));
        int count = expected.size();
        while ((ze = jis.getNextEntry()) != null) {
            --count;
            expected.remove(ze.getName());
        }
        return count == 0 && expected.size() == 0;
    }
}

