/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.ZooKeeperCheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.ZooKeeperCompletedCheckpointStore;
import org.apache.flink.runtime.jobmanager.RecoveryMode;
import org.apache.flink.runtime.jobmanager.SubmittedJobGraph;
import org.apache.flink.runtime.jobmanager.ZooKeeperSubmittedJobGraphStore;
import org.apache.flink.runtime.leaderelection.ZooKeeperLeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.ZooKeeperLeaderRetrievalService;
import org.apache.flink.runtime.zookeeper.filesystem.FileSystemStateStorageHelper;
import org.apache.flink.shaded.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.shaded.org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.flink.shaded.org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperUtils.class);

    public static CuratorFramework startCuratorFramework(Configuration configuration) {
        String zkQuorum = configuration.getString("recovery.zookeeper.quorum", "");
        if (zkQuorum == null || zkQuorum.equals("")) {
            throw new RuntimeException("No valid ZooKeeper quorum has been specified. You can specify the quorum via the configuration key 'recovery.zookeeper.quorum'.");
        }
        int sessionTimeout = configuration.getInteger("recovery.zookeeper.client.session-timeout", 60000);
        int connectionTimeout = configuration.getInteger("recovery.zookeeper.client.connection-timeout", 15000);
        int retryWait = configuration.getInteger("recovery.zookeeper.client.retry-wait", 5000);
        int maxRetryAttempts = configuration.getInteger("recovery.zookeeper.client.max-retry-attempts", 3);
        String root = configuration.getString("recovery.zookeeper.path.root", "/flink");
        String namespace = configuration.getString("recovery.zookeeper.path.namespace", "/default");
        String rootWithNamespace = ZooKeeperUtils.generateZookeeperPath(root, namespace);
        LOG.info("Using '{}' as zookeeper namespace.", (Object)rootWithNamespace);
        CuratorFramework cf = CuratorFrameworkFactory.builder().connectString(zkQuorum).sessionTimeoutMs(sessionTimeout).connectionTimeoutMs(connectionTimeout).retryPolicy(new ExponentialBackoffRetry(retryWait, maxRetryAttempts)).namespace(rootWithNamespace.startsWith("/") ? rootWithNamespace.substring(1) : rootWithNamespace).build();
        cf.start();
        return cf;
    }

    public static boolean isZooKeeperRecoveryMode(Configuration flinkConf) {
        return RecoveryMode.fromConfig(flinkConf).equals((Object)RecoveryMode.ZOOKEEPER);
    }

    public static String getZooKeeperEnsemble(Configuration flinkConf) throws IllegalConfigurationException {
        String zkQuorum = flinkConf.getString("recovery.zookeeper.quorum", "");
        if (zkQuorum == null || zkQuorum.equals("")) {
            throw new IllegalConfigurationException("No ZooKeeper quorum specified in config.");
        }
        zkQuorum = zkQuorum.replaceAll("\\s+", "");
        return zkQuorum;
    }

    public static ZooKeeperLeaderRetrievalService createLeaderRetrievalService(Configuration configuration) throws Exception {
        CuratorFramework client = ZooKeeperUtils.startCuratorFramework(configuration);
        String leaderPath = configuration.getString("recovery.zookeeper.path.leader", "/leader");
        return new ZooKeeperLeaderRetrievalService(client, leaderPath);
    }

    public static ZooKeeperLeaderElectionService createLeaderElectionService(Configuration configuration) throws Exception {
        CuratorFramework client = ZooKeeperUtils.startCuratorFramework(configuration);
        return ZooKeeperUtils.createLeaderElectionService(client, configuration);
    }

    public static ZooKeeperLeaderElectionService createLeaderElectionService(CuratorFramework client, Configuration configuration) throws Exception {
        String latchPath = configuration.getString("recovery.zookeeper.path.latch", "/leaderlatch");
        String leaderPath = configuration.getString("recovery.zookeeper.path.leader", "/leader");
        return new ZooKeeperLeaderElectionService(client, latchPath, leaderPath);
    }

    public static ZooKeeperSubmittedJobGraphStore createSubmittedJobGraphs(CuratorFramework client, Configuration configuration) throws Exception {
        Preconditions.checkNotNull((Object)configuration, (String)"Configuration");
        FileSystemStateStorageHelper<SubmittedJobGraph> stateStorage = ZooKeeperUtils.createFileSystemStateStorage(configuration, "submittedJobGraph");
        String zooKeeperSubmittedJobsPath = configuration.getString("recovery.zookeeper.path.jobgraphs", "/jobgraphs");
        return new ZooKeeperSubmittedJobGraphStore(client, zooKeeperSubmittedJobsPath, stateStorage);
    }

    public static CompletedCheckpointStore createCompletedCheckpoints(CuratorFramework client, Configuration configuration, JobID jobId, int maxNumberOfCheckpointsToRetain, ClassLoader userClassLoader) throws Exception {
        Preconditions.checkNotNull((Object)configuration, (String)"Configuration");
        String checkpointsPath = configuration.getString("recovery.zookeeper.path.checkpoints", "/checkpoints");
        FileSystemStateStorageHelper<CompletedCheckpoint> stateStorage = ZooKeeperUtils.createFileSystemStateStorage(configuration, "completedCheckpoint");
        checkpointsPath = checkpointsPath + ZooKeeperSubmittedJobGraphStore.getPathForJob(jobId);
        return new ZooKeeperCompletedCheckpointStore(maxNumberOfCheckpointsToRetain, userClassLoader, client, checkpointsPath, stateStorage);
    }

    public static ZooKeeperCheckpointIDCounter createCheckpointIDCounter(CuratorFramework client, Configuration configuration, JobID jobId) throws Exception {
        String checkpointIdCounterPath = configuration.getString("recovery.zookeeper.path.checkpoint-counter", "/checkpoint-counter");
        checkpointIdCounterPath = checkpointIdCounterPath + ZooKeeperSubmittedJobGraphStore.getPathForJob(jobId);
        return new ZooKeeperCheckpointIDCounter(client, checkpointIdCounterPath);
    }

    private static <T extends Serializable> FileSystemStateStorageHelper<T> createFileSystemStateStorage(Configuration configuration, String prefix) throws IOException {
        String rootPath = configuration.getString("recovery.zookeeper.storageDir", "");
        if (rootPath.equals("")) {
            throw new IllegalConfigurationException("Missing recovery path. Specify via configuration key 'recovery.zookeeper.storageDir'.");
        }
        return new FileSystemStateStorageHelper(rootPath, prefix);
    }

    private static String generateZookeeperPath(String root, String namespace) {
        if (!namespace.startsWith("/")) {
            namespace = "/" + namespace;
        }
        if (namespace.endsWith("/")) {
            namespace = namespace.substring(0, namespace.length() - 1);
        }
        return root + namespace;
    }

    private ZooKeeperUtils() {
        throw new RuntimeException();
    }
}

