/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.KeyGroupState;
import org.apache.flink.runtime.checkpoint.SubtaskState;
import org.apache.flink.runtime.checkpoint.TaskState;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.state.StateHandle;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PendingCheckpoint {
    private static final Logger LOG = LoggerFactory.getLogger(PendingCheckpoint.class);
    private final Object lock = new Object();
    private final JobID jobId;
    private final long checkpointId;
    private final long checkpointTimestamp;
    private final Map<JobVertexID, TaskState> taskStates;
    private final Map<ExecutionAttemptID, ExecutionVertex> notYetAcknowledgedTasks;
    private final Set<ExecutionAttemptID> acknowledgedTasks;
    private final Executor executor;
    private int numAcknowledgedTasks;
    private boolean discarded;

    public PendingCheckpoint(JobID jobId, long checkpointId, long checkpointTimestamp, Map<ExecutionAttemptID, ExecutionVertex> verticesToConfirm, Executor executor) {
        if (jobId == null || verticesToConfirm == null) {
            throw new NullPointerException();
        }
        if (verticesToConfirm.size() == 0) {
            throw new IllegalArgumentException("Checkpoint needs at least one vertex that commits the checkpoint");
        }
        this.jobId = jobId;
        this.checkpointId = checkpointId;
        this.checkpointTimestamp = checkpointTimestamp;
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.notYetAcknowledgedTasks = verticesToConfirm;
        this.taskStates = new HashMap<JobVertexID, TaskState>();
        this.acknowledgedTasks = new HashSet<ExecutionAttemptID>(verticesToConfirm.size());
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public long getCheckpointId() {
        return this.checkpointId;
    }

    public long getCheckpointTimestamp() {
        return this.checkpointTimestamp;
    }

    public int getNumberOfNonAcknowledgedTasks() {
        return this.notYetAcknowledgedTasks.size();
    }

    public int getNumberOfAcknowledgedTasks() {
        return this.numAcknowledgedTasks;
    }

    public Map<JobVertexID, TaskState> getTaskStates() {
        return this.taskStates;
    }

    public boolean isFullyAcknowledged() {
        return this.notYetAcknowledgedTasks.isEmpty() && !this.discarded;
    }

    public boolean isDiscarded() {
        return this.discarded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletedCheckpoint finalizeCheckpoint() {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((boolean)this.isFullyAcknowledged(), (Object)"Pending checkpoint has not been fully acknowledged yet.");
            CompletedCheckpoint completed = new CompletedCheckpoint(this.jobId, this.checkpointId, this.checkpointTimestamp, System.currentTimeMillis(), new HashMap<JobVertexID, TaskState>(this.taskStates));
            this.dispose(null, false);
            return completed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskAcknowledgeResult acknowledgeTask(ExecutionAttemptID executionAttemptId, SerializedValue<StateHandle<?>> state, long stateSize, Map<Integer, SerializedValue<StateHandle<?>>> kvState) {
        Object object = this.lock;
        synchronized (object) {
            if (this.discarded) {
                return TaskAcknowledgeResult.DISCARDED;
            }
            ExecutionVertex vertex = this.notYetAcknowledgedTasks.remove((Object)executionAttemptId);
            if (vertex == null) {
                if (this.acknowledgedTasks.contains((Object)executionAttemptId)) {
                    return TaskAcknowledgeResult.DUPLICATE;
                }
                return TaskAcknowledgeResult.UNKNOWN;
            }
            this.acknowledgedTasks.add(executionAttemptId);
            if (state != null || kvState != null) {
                TaskState taskState;
                JobVertexID jobVertexID = vertex.getJobvertexId();
                if (this.taskStates.containsKey((Object)jobVertexID)) {
                    taskState = this.taskStates.get((Object)jobVertexID);
                } else {
                    taskState = new TaskState(jobVertexID, vertex.getTotalNumberOfParallelSubtasks());
                    this.taskStates.put(jobVertexID, taskState);
                }
                long timestamp = System.currentTimeMillis() - this.checkpointTimestamp;
                if (state != null) {
                    taskState.putState(vertex.getParallelSubtaskIndex(), new SubtaskState(state, stateSize, timestamp));
                }
                if (kvState != null) {
                    for (Map.Entry<Integer, SerializedValue<StateHandle<?>>> entry : kvState.entrySet()) {
                        taskState.putKvState(entry.getKey(), new KeyGroupState(entry.getValue(), 0L, timestamp));
                    }
                }
            }
            ++this.numAcknowledgedTasks;
            return TaskAcknowledgeResult.SUCCESS;
        }
    }

    public void discard(ClassLoader userClassLoader) {
        this.dispose(userClassLoader, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose(final ClassLoader userClassLoader, boolean releaseState) {
        Object object = this.lock;
        synchronized (object) {
            this.numAcknowledgedTasks = -1;
            try {
                if (!this.discarded && releaseState) {
                    this.executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            for (TaskState taskState : PendingCheckpoint.this.taskStates.values()) {
                                try {
                                    taskState.discard(userClassLoader);
                                }
                                catch (Exception e) {
                                    LOG.warn("Could not properly dispose the task state belonging to vertex {} of checkpoint {} and job {}.", new Object[]{taskState.getJobVertexID(), PendingCheckpoint.this.checkpointId, PendingCheckpoint.this.jobId, e});
                                }
                            }
                            PendingCheckpoint.this.taskStates.clear();
                        }
                    });
                }
            }
            finally {
                this.discarded = true;
                this.notYetAcknowledgedTasks.clear();
                this.acknowledgedTasks.clear();
            }
        }
    }

    public String toString() {
        return String.format("PendingCheckpoint %d @ %d - confirmed=%d, pending=%d", this.checkpointId, this.checkpointTimestamp, this.getNumberOfAcknowledgedTasks(), this.getNumberOfNonAcknowledgedTasks());
    }

    public static enum TaskAcknowledgeResult {
        SUCCESS,
        DUPLICATE,
        UNKNOWN,
        DISCARDED;

    }
}

