/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.archive;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.api.common.ExecutionConfig;

public class ExecutionConfigSummary
implements Serializable {
    private final String executionMode;
    private final String restartStrategyDescription;
    private final int parallelism;
    private final boolean objectReuseEnabled;
    private final Map<String, String> globalJobParameters;

    public ExecutionConfigSummary(ExecutionConfig ec) {
        this.executionMode = ec.getExecutionMode().name();
        this.restartStrategyDescription = ec.getRestartStrategy() != null ? ec.getRestartStrategy().getDescription() : "default";
        this.parallelism = ec.getParallelism();
        this.objectReuseEnabled = ec.isObjectReuseEnabled();
        this.globalJobParameters = ec.getGlobalJobParameters() != null && ec.getGlobalJobParameters().toMap() != null ? ec.getGlobalJobParameters().toMap() : Collections.emptyMap();
    }

    public String getExecutionMode() {
        return this.executionMode;
    }

    public String getRestartStrategyDescription() {
        return this.restartStrategyDescription;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public boolean getObjectReuseEnabled() {
        return this.objectReuseEnabled;
    }

    public Map<String, String> getGlobalJobParameters() {
        return this.globalJobParameters;
    }
}

