/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferProvider;
import org.apache.flink.runtime.io.network.netty.PartitionRequestQueue;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionProvider;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelID;

class SequenceNumberingViewReader
implements BufferAvailabilityListener {
    private final Object requestLock = new Object();
    private final InputChannelID receiverId;
    private final AtomicLong numBuffersAvailable = new AtomicLong();
    private final PartitionRequestQueue requestQueue;
    private volatile ResultSubpartitionView subpartitionView;
    private int sequenceNumber = -1;

    SequenceNumberingViewReader(InputChannelID receiverId, PartitionRequestQueue requestQueue) {
        this.receiverId = receiverId;
        this.requestQueue = requestQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestSubpartitionView(ResultPartitionProvider partitionProvider, ResultPartitionID resultPartitionId, int subPartitionIndex, BufferProvider bufferProvider) throws IOException {
        Object object = this.requestLock;
        synchronized (object) {
            if (this.subpartitionView != null) {
                throw new IllegalStateException("Subpartition already requested");
            }
            this.subpartitionView = partitionProvider.createSubpartitionView(resultPartitionId, subPartitionIndex, bufferProvider, this);
        }
    }

    InputChannelID getReceiverId() {
        return this.receiverId;
    }

    int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public InputChannel.BufferAndAvailability getNextBuffer() throws IOException, InterruptedException {
        Buffer next = this.subpartitionView.getNextBuffer();
        if (next != null) {
            long remaining = this.numBuffersAvailable.decrementAndGet();
            ++this.sequenceNumber;
            if (remaining >= 0L) {
                return new InputChannel.BufferAndAvailability(next, remaining > 0L);
            }
            throw new IllegalStateException("no buffer available");
        }
        return null;
    }

    public void notifySubpartitionConsumed() throws IOException {
        this.subpartitionView.notifySubpartitionConsumed();
    }

    public boolean isReleased() {
        return this.subpartitionView.isReleased();
    }

    public Throwable getFailureCause() {
        return this.subpartitionView.getFailureCause();
    }

    public void releaseAllResources() throws IOException {
        this.subpartitionView.releaseAllResources();
    }

    @Override
    public void notifyBuffersAvailable(long numBuffers) {
        if (numBuffers > 0L && this.numBuffersAvailable.getAndAdd(numBuffers) == 0L) {
            this.requestQueue.notifyReaderNonEmpty(this);
        }
    }

    public String toString() {
        return "SequenceNumberingViewReader{requestLock=" + this.requestLock + ", receiverId=" + (Object)((Object)this.receiverId) + ", numBuffersAvailable=" + this.numBuffersAvailable.get() + ", sequenceNumber=" + this.sequenceNumber + '}';
    }
}

