/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.execution.CancelTaskException;
import org.apache.flink.runtime.io.network.TaskEventDispatcher;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.PartitionNotFoundException;
import org.apache.flink.runtime.io.network.partition.ProducerFailedException;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.metrics.groups.IOMetricGroup;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class LocalInputChannel
extends InputChannel
implements BufferAvailabilityListener {
    private static final Logger LOG = LoggerFactory.getLogger(LocalInputChannel.class);
    private final Object requestLock = new Object();
    private final ResultPartitionManager partitionManager;
    private final TaskEventDispatcher taskEventDispatcher;
    private final AtomicLong numBuffersAvailable;
    private volatile ResultSubpartitionView subpartitionView;
    private volatile boolean isReleased;

    public LocalInputChannel(SingleInputGate inputGate, int channelIndex, ResultPartitionID partitionId, ResultPartitionManager partitionManager, TaskEventDispatcher taskEventDispatcher, IOMetricGroup metrics) {
        this(inputGate, channelIndex, partitionId, partitionManager, taskEventDispatcher, (Tuple2<Integer, Integer>)new Tuple2((Object)0, (Object)0), metrics);
    }

    public LocalInputChannel(SingleInputGate inputGate, int channelIndex, ResultPartitionID partitionId, ResultPartitionManager partitionManager, TaskEventDispatcher taskEventDispatcher, Tuple2<Integer, Integer> initialAndMaxBackoff, IOMetricGroup metrics) {
        super(inputGate, channelIndex, partitionId, initialAndMaxBackoff, metrics.getNumBytesInLocalCounter());
        this.partitionManager = (ResultPartitionManager)Preconditions.checkNotNull((Object)partitionManager);
        this.taskEventDispatcher = (TaskEventDispatcher)Preconditions.checkNotNull((Object)taskEventDispatcher);
        this.numBuffersAvailable = new AtomicLong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void requestSubpartition(int subpartitionIndex) throws IOException, InterruptedException {
        boolean retriggerRequest = false;
        Object object = this.requestLock;
        synchronized (object) {
            Preconditions.checkState((!this.isReleased ? 1 : 0) != 0, (Object)"LocalInputChannel has been released already");
            if (this.subpartitionView == null) {
                LOG.debug("{}: Requesting LOCAL subpartition {} of partition {}.", new Object[]{this, subpartitionIndex, this.partitionId});
                try {
                    ResultSubpartitionView subpartitionView = this.partitionManager.createSubpartitionView(this.partitionId, subpartitionIndex, this.inputGate.getBufferProvider(), this);
                    if (subpartitionView == null) {
                        throw new IOException("Error requesting subpartition.");
                    }
                    this.subpartitionView = subpartitionView;
                    if (this.isReleased) {
                        subpartitionView.releaseAllResources();
                        this.subpartitionView = null;
                    }
                }
                catch (PartitionNotFoundException notFound) {
                    if (this.increaseBackoff()) {
                        retriggerRequest = true;
                    }
                    throw notFound;
                }
            }
        }
        if (retriggerRequest) {
            this.inputGate.retriggerPartitionRequest(this.partitionId.getPartitionId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retriggerSubpartitionRequest(Timer timer, final int subpartitionIndex) {
        Object object = this.requestLock;
        synchronized (object) {
            Preconditions.checkState((this.subpartitionView == null ? 1 : 0) != 0, (Object)"already requested partition");
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        LocalInputChannel.this.requestSubpartition(subpartitionIndex);
                    }
                    catch (Throwable t) {
                        LocalInputChannel.this.setError(t);
                    }
                }
            }, this.getCurrentBackoff());
        }
    }

    @Override
    InputChannel.BufferAndAvailability getNextBuffer() throws IOException, InterruptedException {
        Buffer next;
        this.checkError();
        ResultSubpartitionView subpartitionView = this.subpartitionView;
        if (subpartitionView == null) {
            subpartitionView = this.checkAndWaitForSubpartitionView();
        }
        if ((next = subpartitionView.getNextBuffer()) == null) {
            if (subpartitionView.isReleased()) {
                throw new CancelTaskException("Consumed partition " + subpartitionView + " has been released.");
            }
            throw new IllegalStateException("Consumed partition has no buffers available. Number of received buffer notifications is " + this.numBuffersAvailable + ".");
        }
        long remaining = this.numBuffersAvailable.decrementAndGet();
        if (remaining >= 0L) {
            this.numBytesIn.inc((long)next.getSize());
            return new InputChannel.BufferAndAvailability(next, remaining > 0L);
        }
        if (subpartitionView.isReleased()) {
            throw new ProducerFailedException(subpartitionView.getFailureCause());
        }
        throw new IllegalStateException("No buffer available and producer partition not released.");
    }

    @Override
    public void notifyBuffersAvailable(long numBuffers) {
        if (numBuffers > 0L && this.numBuffersAvailable.getAndAdd(numBuffers) == 0L) {
            this.notifyChannelNonEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSubpartitionView checkAndWaitForSubpartitionView() {
        Object object = this.requestLock;
        synchronized (object) {
            Preconditions.checkState((!this.isReleased ? 1 : 0) != 0, (Object)"released");
            Preconditions.checkState((this.subpartitionView != null ? 1 : 0) != 0, (Object)"Queried for a buffer before requesting the subpartition.");
            return this.subpartitionView;
        }
    }

    @Override
    void sendTaskEvent(TaskEvent event) throws IOException {
        this.checkError();
        Preconditions.checkState((this.subpartitionView != null ? 1 : 0) != 0, (Object)"Tried to send task event to producer before requesting the subpartition.");
        if (!this.taskEventDispatcher.publish(this.partitionId, event)) {
            throw new IOException("Error while publishing event " + event + " to producer. The producer could not be found.");
        }
    }

    @Override
    boolean isReleased() {
        return this.isReleased;
    }

    @Override
    void notifySubpartitionConsumed() throws IOException {
        if (this.subpartitionView != null) {
            this.subpartitionView.notifySubpartitionConsumed();
        }
    }

    @Override
    void releaseAllResources() throws IOException {
        if (!this.isReleased) {
            this.isReleased = true;
            ResultSubpartitionView view = this.subpartitionView;
            if (view != null) {
                view.releaseAllResources();
                this.subpartitionView = null;
            }
        }
    }

    public String toString() {
        return "LocalInputChannel [" + this.partitionId + "]";
    }
}

