/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.groups.ComponentMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.metrics.scope.TaskManagerScopeFormat;
import org.apache.flink.util.Preconditions;

public class TaskManagerMetricGroup
extends ComponentMetricGroup {
    private final Map<JobID, TaskManagerJobMetricGroup> jobs = new HashMap<JobID, TaskManagerJobMetricGroup>();
    private final String hostname;
    private final String taskManagerId;

    public TaskManagerMetricGroup(MetricRegistry registry, String hostname, String taskManagerId) {
        this(registry, registry.getScopeFormats().getTaskManagerFormat(), hostname, taskManagerId);
    }

    public TaskManagerMetricGroup(MetricRegistry registry, TaskManagerScopeFormat scopeFormat, String hostname, String taskManagerId) {
        super(registry, scopeFormat.formatScope(hostname, taskManagerId));
        this.hostname = hostname;
        this.taskManagerId = taskManagerId;
    }

    public String hostname() {
        return this.hostname;
    }

    public String taskManagerId() {
        return this.taskManagerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskMetricGroup addTaskForJob(JobID jobId, String jobName, JobVertexID jobVertexId, ExecutionAttemptID executionAttemptId, String taskName, int subtaskIndex, int attemptNumber) {
        TaskManagerJobMetricGroup currentJobGroup;
        TaskMetricGroup taskGroup;
        Preconditions.checkNotNull((Object)jobId);
        String resolvedJobName = jobName == null || jobName.isEmpty() ? jobId.toString() : jobName;
        do {
            TaskManagerMetricGroup taskManagerMetricGroup = this;
            synchronized (taskManagerMetricGroup) {
                currentJobGroup = this.jobs.get(jobId);
                if (currentJobGroup == null || currentJobGroup.isClosed()) {
                    currentJobGroup = new TaskManagerJobMetricGroup(this.registry, this, jobId, resolvedJobName);
                    this.jobs.put(jobId, currentJobGroup);
                }
            }
        } while ((taskGroup = currentJobGroup.addTask(jobVertexId, executionAttemptId, taskName, subtaskIndex, attemptNumber)) == null);
        return taskGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJobMetricsGroup(JobID jobId, TaskManagerJobMetricGroup group) {
        if (jobId == null || group == null || !group.isClosed()) {
            return;
        }
        TaskManagerMetricGroup taskManagerMetricGroup = this;
        synchronized (taskManagerMetricGroup) {
            TaskManagerJobMetricGroup containedGroup = this.jobs.remove(jobId);
            if (containedGroup != null && containedGroup != group) {
                this.jobs.put(jobId, containedGroup);
            }
        }
    }

    public int numRegisteredJobMetricGroups() {
        return this.jobs.size();
    }

    @Override
    protected Iterable<? extends ComponentMetricGroup> subComponents() {
        return this.jobs.values();
    }
}

