/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.minicluster;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.pattern.AskableActorRef$;
import akka.pattern.Patterns$;
import akka.pattern.package$;
import akka.util.Timeout$;
import com.typesafe.config.Config;
import java.net.InetAddress;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobSubmissionResult;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.AkkaUtils$;
import org.apache.flink.runtime.client.JobClient;
import org.apache.flink.runtime.client.JobExecutionException;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.instance.AkkaActorGateway;
import org.apache.flink.runtime.instance.Hardware;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmanager.RecoveryMode;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalListener;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.leaderretrieval.StandaloneLeaderRetrievalService;
import org.apache.flink.runtime.messages.TaskManagerMessages$NotifyWhenRegisteredAtJobManager$;
import org.apache.flink.runtime.minicluster.FlinkMiniCluster$;
import org.apache.flink.runtime.util.ExecutorUtils;
import org.apache.flink.runtime.util.NamedThreadFactory;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.runtime.webmonitor.WebMonitor;
import org.apache.flink.runtime.webmonitor.WebMonitorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.VolatileByteRef;

@ScalaSignature(bytes="\u0006\u0001\u0011Uc!B\u0001\u0003\u0003\u0003i!\u0001\u0005$mS:\\W*\u001b8j\u00072,8\u000f^3s\u0015\t\u0019A!A\u0006nS:L7\r\\;ti\u0016\u0014(BA\u0003\u0007\u0003\u001d\u0011XO\u001c;j[\u0016T!a\u0002\u0005\u0002\u000b\u0019d\u0017N\\6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001aB\u0006\t\u0003\u001fQi\u0011\u0001\u0005\u0006\u0003#I\tA\u0001\\1oO*\t1#\u0001\u0003kCZ\f\u0017BA\u000b\u0011\u0005\u0019y%M[3diB\u0011qCG\u0007\u00021)\u0011\u0011\u0004B\u0001\u0010Y\u0016\fG-\u001a:sKR\u0014\u0018.\u001a<bY&\u00111\u0004\u0007\u0002\u0018\u0019\u0016\fG-\u001a:SKR\u0014\u0018.\u001a<bY2K7\u000f^3oKJD\u0001\"\b\u0001\u0003\u0006\u0004%\tAH\u0001\u0012kN,'oQ8oM&<WO]1uS>tW#A\u0010\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0005\t2\u0011!D2p]\u001aLw-\u001e:bi&|g.\u0003\u0002%C\ti1i\u001c8gS\u001e,(/\u0019;j_:D\u0001B\n\u0001\u0003\u0002\u0003\u0006IaH\u0001\u0013kN,'oQ8oM&<WO]1uS>t\u0007\u0005\u0003\u0005)\u0001\t\u0015\r\u0011\"\u0001*\u0003Q)8/Z*j]\u001edW-Q2u_J\u001c\u0016p\u001d;f[V\t!\u0006\u0005\u0002,]5\tAFC\u0001.\u0003\u0015\u00198-\u00197b\u0013\tyCFA\u0004C_>dW-\u00198\t\u0011E\u0002!\u0011!Q\u0001\n)\nQ#^:f'&tw\r\\3BGR|'oU=ti\u0016l\u0007\u0005C\u00034\u0001\u0011\u0005A'\u0001\u0004=S:LGO\u0010\u000b\u0004k]B\u0004C\u0001\u001c\u0001\u001b\u0005\u0011\u0001\"B\u000f3\u0001\u0004y\u0002\"\u0002\u00153\u0001\u0004Q\u0003b\u0002\u001e\u0001\u0005\u0004%\tbO\u0001\u0004\u0019>;U#\u0001\u001f\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}R\u0011!B:mMRR\u0017BA!?\u0005\u0019aunZ4fe\"11\t\u0001Q\u0001\nq\nA\u0001T(HA!9Q\t\u0001b\u0001\n\u00031\u0015\u0001\u00035pgRt\u0017-\\3\u0016\u0003\u001d\u0003\"a\u0004%\n\u0005%\u0003\"AB*ue&tw\r\u0003\u0004L\u0001\u0001\u0006IaR\u0001\nQ>\u001cHO\\1nK\u0002BqA\t\u0001C\u0002\u0013\u0005a\u0004\u0003\u0004O\u0001\u0001\u0006IaH\u0001\u000fG>tg-[4ve\u0006$\u0018n\u001c8!\u0011\u001d\u0001\u0006\u00011A\u0005\u0002E\u000bQ\u0002\\3bI\u0016\u0014x)\u0019;fo\u0006LX#\u0001*\u0011\u0007M3\u0006,D\u0001U\u0015\t)F&\u0001\u0006d_:\u001cWO\u001d:f]RL!a\u0016+\u0003\u000fA\u0013x.\\5tKB\u0011\u0011\fX\u0007\u00025*\u00111\fB\u0001\tS:\u001cH/\u00198dK&\u0011QL\u0017\u0002\r\u0003\u000e$xN]$bi\u0016<\u0018-\u001f\u0005\b?\u0002\u0001\r\u0011\"\u0001a\u0003EaW-\u00193fe\u001e\u000bG/Z<bs~#S-\u001d\u000b\u0003C\u0012\u0004\"a\u000b2\n\u0005\rd#\u0001B+oSRDq!\u001a0\u0002\u0002\u0003\u0007!+A\u0002yIEBaa\u001a\u0001!B\u0013\u0011\u0016A\u00047fC\u0012,'oR1uK^\f\u0017\u0010\t\u0005\bS\u0002\u0001\r\u0011\"\u0001k\u0003-aW-\u00193fe&sG-\u001a=\u0016\u0003-\u00042a\u0015,m!\tYS.\u0003\u0002oY\t\u0019\u0011J\u001c;\t\u000fA\u0004\u0001\u0019!C\u0001c\u0006yA.Z1eKJLe\u000eZ3y?\u0012*\u0017\u000f\u0006\u0002be\"9Qm\\A\u0001\u0002\u0004Y\u0007B\u0002;\u0001A\u0003&1.\u0001\u0007mK\u0006$WM]%oI\u0016D\b\u0005C\u0004w\u0001\t\u0007I\u0011A<\u0002\u0015\u0019,H/\u001e:f\u0019>\u001c7.F\u0001\u000f\u0011\u0019I\b\u0001)A\u0005\u001d\u0005Ya-\u001e;ve\u0016dunY6!\u0011\u001dY\bA1A\u0005\u0004q\f\u0001#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0016\u0003u\u0004\"a\u0015@\n\u0005}$&\u0001G#yK\u000e,H/[8o\u0007>tG/\u001a=u\u000bb,7-\u001e;pe\"9\u00111\u0001\u0001!\u0002\u0013i\u0018!E3yK\u000e,H/[8o\u0007>tG/\u001a=uA!I\u0011q\u0001\u0001C\u0002\u0013\r\u0011\u0011B\u0001\bi&lWm\\;u+\t\tY\u0001\u0005\u0003\u0002\u000e\u0005MQBAA\b\u0015\r\t\t\u0002V\u0001\tIV\u0014\u0018\r^5p]&!\u0011QCA\b\u000591\u0015N\\5uK\u0012+(/\u0019;j_:D\u0001\"!\u0007\u0001A\u0003%\u00111B\u0001\ti&lWm\\;uA!I\u0011Q\u0004\u0001C\u0002\u0013\u0005\u0011qD\u0001\re\u0016\u001cwN^3ss6{G-Z\u000b\u0003\u0003C\u0001B!a\t\u0002*5\u0011\u0011Q\u0005\u0006\u0004\u0003O!\u0011A\u00036pE6\fg.Y4fe&!\u00111FA\u0013\u00051\u0011VmY8wKJLXj\u001c3f\u0011!\ty\u0003\u0001Q\u0001\n\u0005\u0005\u0012!\u0004:fG>4XM]=N_\u0012,\u0007\u0005C\u0005\u00024\u0001\u0011\r\u0011\"\u0001\u00026\u0005qa.^7K_\nl\u0015M\\1hKJ\u001cX#\u00017\t\u000f\u0005e\u0002\u0001)A\u0005Y\u0006ya.^7K_\nl\u0015M\\1hKJ\u001c\b\u0005C\u0005\u0002>\u0001\u0011\r\u0011\"\u0001\u00026\u0005ya.^7UCN\\W*\u00198bO\u0016\u00148\u000fC\u0004\u0002B\u0001\u0001\u000b\u0011\u00027\u0002!9,X\u000eV1tW6\u000bg.Y4feN\u0004\u0003\"CA#\u0001\u0001\u0007I\u0011AA$\u0003YQwNY'b]\u0006<WM]!di>\u00148+_:uK6\u001cXCAA%!\u0015Y\u00131JA(\u0013\r\ti\u0005\f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r\u0005E\u0013\u0011MA4\u001d\u0011\t\u0019&!\u0018\u000f\t\u0005U\u00131L\u0007\u0003\u0003/R1!!\u0017\r\u0003\u0019a$o\\8u}%\tQ&C\u0002\u0002`1\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002d\u0005\u0015$aA*fc*\u0019\u0011q\f\u0017\u0011\t\u0005%\u00141O\u0007\u0003\u0003WRA!!\u001c\u0002p\u0005)\u0011m\u0019;pe*\u0011\u0011\u0011O\u0001\u0005C.\\\u0017-\u0003\u0003\u0002v\u0005-$aC!di>\u00148+_:uK6D\u0011\"!\u001f\u0001\u0001\u0004%\t!a\u001f\u00025)|'-T1oC\u001e,'/Q2u_J\u001c\u0016p\u001d;f[N|F%Z9\u0015\u0007\u0005\fi\bC\u0005f\u0003o\n\t\u00111\u0001\u0002J!A\u0011\u0011\u0011\u0001!B\u0013\tI%A\fk_\nl\u0015M\\1hKJ\f5\r^8s'f\u001cH/Z7tA!I\u0011Q\u0011\u0001A\u0002\u0013\u0005\u0011qQ\u0001\u0011U>\u0014W*\u00198bO\u0016\u0014\u0018i\u0019;peN,\"!!#\u0011\u000b-\nY%a#\u0011\r\u0005E\u0013\u0011MAG!\u0011\tI'a$\n\t\u0005E\u00151\u000e\u0002\t\u0003\u000e$xN\u001d*fM\"I\u0011Q\u0013\u0001A\u0002\u0013\u0005\u0011qS\u0001\u0015U>\u0014W*\u00198bO\u0016\u0014\u0018i\u0019;peN|F%Z9\u0015\u0007\u0005\fI\nC\u0005f\u0003'\u000b\t\u00111\u0001\u0002\n\"A\u0011Q\u0014\u0001!B\u0013\tI)A\tk_\nl\u0015M\\1hKJ\f5\r^8sg\u0002B\u0011\"!)\u0001\u0001\u0004%\t!a)\u0002\u0015],'-T8oSR|'/\u0006\u0002\u0002&B)1&a\u0013\u0002(B!\u0011\u0011VAX\u001b\t\tYKC\u0002\u0002.\u0012\t!b^3c[>t\u0017\u000e^8s\u0013\u0011\t\t,a+\u0003\u0015]+'-T8oSR|'\u000fC\u0005\u00026\u0002\u0001\r\u0011\"\u0001\u00028\u0006qq/\u001a2N_:LGo\u001c:`I\u0015\fHcA1\u0002:\"IQ-a-\u0002\u0002\u0003\u0007\u0011Q\u0015\u0005\t\u0003{\u0003\u0001\u0015)\u0003\u0002&\u0006Yq/\u001a2N_:LGo\u001c:!\u0011%\t\t\r\u0001a\u0001\n\u0003\t9%A\fuCN\\W*\u00198bO\u0016\u0014\u0018i\u0019;peNK8\u000f^3ng\"I\u0011Q\u0019\u0001A\u0002\u0013\u0005\u0011qY\u0001\u001ci\u0006\u001c8.T1oC\u001e,'/Q2u_J\u001c\u0016p\u001d;f[N|F%Z9\u0015\u0007\u0005\fI\rC\u0005f\u0003\u0007\f\t\u00111\u0001\u0002J!A\u0011Q\u001a\u0001!B\u0013\tI%\u0001\ruCN\\W*\u00198bO\u0016\u0014\u0018i\u0019;peNK8\u000f^3ng\u0002B\u0011\"!5\u0001\u0001\u0004%\t!a\"\u0002#Q\f7o['b]\u0006<WM]!di>\u00148\u000fC\u0005\u0002V\u0002\u0001\r\u0011\"\u0001\u0002X\u0006)B/Y:l\u001b\u0006t\u0017mZ3s\u0003\u000e$xN]:`I\u0015\fHcA1\u0002Z\"IQ-a5\u0002\u0002\u0003\u0007\u0011\u0011\u0012\u0005\t\u0003;\u0004\u0001\u0015)\u0003\u0002\n\u0006\u0011B/Y:l\u001b\u0006t\u0017mZ3s\u0003\u000e$xN]:!\u0011%\t\t\u000f\u0001a\u0001\n\u0003\t9%A\u000esKN|WO]2f\u001b\u0006t\u0017mZ3s\u0003\u000e$xN]*zgR,Wn\u001d\u0005\n\u0003K\u0004\u0001\u0019!C\u0001\u0003O\fqD]3t_V\u00148-Z'b]\u0006<WM]!di>\u00148+_:uK6\u001cx\fJ3r)\r\t\u0017\u0011\u001e\u0005\nK\u0006\r\u0018\u0011!a\u0001\u0003\u0013B\u0001\"!<\u0001A\u0003&\u0011\u0011J\u0001\u001de\u0016\u001cx.\u001e:dK6\u000bg.Y4fe\u0006\u001bGo\u001c:TsN$X-\\:!\u0011%\t\t\u0010\u0001a\u0001\n\u0003\t9)A\u000bsKN|WO]2f\u001b\u0006t\u0017mZ3s\u0003\u000e$xN]:\t\u0013\u0005U\b\u00011A\u0005\u0002\u0005]\u0018!\u0007:fg>,(oY3NC:\fw-\u001a:BGR|'o]0%KF$2!YA}\u0011%)\u00171_A\u0001\u0002\u0004\tI\t\u0003\u0005\u0002~\u0002\u0001\u000b\u0015BAE\u0003Y\u0011Xm]8ve\u000e,W*\u00198bO\u0016\u0014\u0018i\u0019;peN\u0004\u0003\"\u0003B\u0001\u0001\u0001\u0007I\u0011\u0003B\u0002\u0003\u0001RwNY'b]\u0006<WM\u001d'fC\u0012,'OU3ue&,g/\u00197TKJ4\u0018nY3\u0016\u0005\t\u0015\u0001#B\u0016\u0002L\t\u001d\u0001cA\f\u0003\n%\u0019!1\u0002\r\u0003-1+\u0017\rZ3s%\u0016$(/[3wC2\u001cVM\u001d<jG\u0016D\u0011Ba\u0004\u0001\u0001\u0004%\tB!\u0005\u0002I)|'-T1oC\u001e,'\u000fT3bI\u0016\u0014(+\u001a;sS\u00164\u0018\r\\*feZL7-Z0%KF$2!\u0019B\n\u0011%)'QBA\u0001\u0002\u0004\u0011)\u0001\u0003\u0005\u0003\u0018\u0001\u0001\u000b\u0015\u0002B\u0003\u0003\u0005RwNY'b]\u0006<WM\u001d'fC\u0012,'OU3ue&,g/\u00197TKJ4\u0018nY3!\u0011!\u0011Y\u0002\u0001a\u0001\n\u0013I\u0013!C5t%Vtg.\u001b8h\u0011%\u0011y\u0002\u0001a\u0001\n\u0013\u0011\t#A\u0007jgJ+hN\\5oO~#S-\u001d\u000b\u0004C\n\r\u0002\u0002C3\u0003\u001e\u0005\u0005\t\u0019\u0001\u0016\t\u000f\t\u001d\u0002\u0001)Q\u0005U\u0005Q\u0011n\u001d*v]:Lgn\u001a\u0011\t\u0013\t-\u0002A1A\u0005\u0002\t5\u0012A\u00044viV\u0014X-\u0012=fGV$xN]\u000b\u0003\u0005_\u0001BA!\r\u0003:5\u0011!1\u0007\u0006\u0004+\nU\"b\u0001B\u001c%\u0005!Q\u000f^5m\u0013\u0011\u0011YDa\r\u0003\u001f\u0015CXmY;u_J\u001cVM\u001d<jG\u0016D\u0001Ba\u0010\u0001A\u0003%!qF\u0001\u0010MV$XO]3Fq\u0016\u001cW\u000f^8sA!I!1\t\u0001C\u0002\u0013\u0005!QF\u0001\u000bS>,\u00050Z2vi>\u0014\b\u0002\u0003B$\u0001\u0001\u0006IAa\f\u0002\u0017%|W\t_3dkR|'\u000f\t\u0005\b\u0005\u0017\u0002a\u0011\u0001B'\u0003U9WM\\3sCR,7i\u001c8gS\u001e,(/\u0019;j_:$2a\bB(\u0011\u0019i\"\u0011\na\u0001?!9!1\u000b\u0001\u0007\u0002\tU\u0013\u0001F:uCJ$(+Z:pkJ\u001cW-T1oC\u001e,'\u000f\u0006\u0004\u0002\u000e\n]#1\f\u0005\b\u00053\u0012\t\u00061\u0001m\u0003\u0015Ig\u000eZ3y\u0011!\u0011iF!\u0015A\u0002\u0005\u001d\u0014AB:zgR,W\u000eC\u0004\u0003b\u00011\tAa\u0019\u0002\u001fM$\u0018M\u001d;K_\nl\u0015M\\1hKJ$b!!$\u0003f\t\u001d\u0004b\u0002B-\u0005?\u0002\r\u0001\u001c\u0005\t\u0005;\u0012y\u00061\u0001\u0002h!9!1\u000e\u0001\u0007\u0002\t5\u0014\u0001E:uCJ$H+Y:l\u001b\u0006t\u0017mZ3s)\u0019\tiIa\u001c\u0003r!9!\u0011\fB5\u0001\u0004a\u0007\u0002\u0003B/\u0005S\u0002\r!a\u001a\t\u000f\tU\u0004\u0001\"\u0001\u00026\u00051r-\u001a;Ok6\u0014WM](g\u0015>\u0014W*\u00198bO\u0016\u00148\u000fC\u0004\u0003z\u0001!\t!!\u000e\u00027\u001d,GOT;nE\u0016\u0014xJ\u001a*fg>,(oY3NC:\fw-\u001a:t\u0011\u001d\u0011i\b\u0001C\u0001\u0005\u007f\nAcZ3u\u0015>\u0014W*\u00198bO\u0016\u00148/Q:KCZ\fWC\u0001BA!\u0019\u0011\u0019I!\"\u0002\u000e6\u0011!QG\u0005\u0005\u0005\u000f\u0013)D\u0001\u0003MSN$\bb\u0002BF\u0001\u0011\u0005!QR\u0001\u0010O\u0016$H+Y:l\u001b\u0006t\u0017mZ3sgV\u0011\u00111\u0012\u0005\b\u0005#\u0003A\u0011\u0001B@\u0003U9W\r\u001e+bg.l\u0015M\\1hKJ\u001c\u0018i\u001d&bm\u0006DqA!&\u0001\t\u0003\u00119*\u0001\fhKRdU-\u00193fe\u001e\u000bG/Z<bs\u001a+H/\u001e:f+\t\u0011I\n\u0005\u0003T\u00057C\u0016b\u0001BO)\n1a)\u001e;ve\u0016DqA!)\u0001\t\u0003\u0011\u0019+\u0001\thKRdU-\u00193fe\u001e\u000bG/Z<bsR\u0019\u0001L!*\t\u0011\u0005\u001d!q\u0014a\u0001\u0003\u0017AqA!+\u0001\t\u0003\u0011Y+\u0001\u000bhKRdU-\u00193fe&sG-\u001a=GkR,(/Z\u000b\u0003\u0005[\u0003Ba\u0015BNY\"9!\u0011\u0017\u0001\u0005\u0002\tM\u0016AD4fi2+\u0017\rZ3s\u0013:$W\r\u001f\u000b\u0004Y\nU\u0006\u0002CA\u0004\u0005_\u0003\r!a\u0003\t\u000f\te\u0006\u0001\"\u0001\u0003<\u0006ar-\u001a;SKN|WO]2f\u001b\u0006t\u0017mZ3s\u0003.\\\u0017mQ8oM&<G\u0003\u0002B_\u0005#\u0004BAa0\u0003N6\u0011!\u0011\u0019\u0006\u0005\u0005\u0007\u0014)-\u0001\u0004d_:4\u0017n\u001a\u0006\u0005\u0005\u000f\u0014I-\u0001\u0005usB,7/\u00194f\u0015\t\u0011Y-A\u0002d_6LAAa4\u0003B\n11i\u001c8gS\u001eDqA!\u0017\u00038\u0002\u0007A\u000eC\u0004\u0003V\u0002!\tAa6\u0002/\u001d,GOS8c\u001b\u0006t\u0017mZ3s\u0003.\\\u0017mQ8oM&<G\u0003\u0002B_\u00053DqA!\u0017\u0003T\u0002\u0007A\u000eC\u0004\u0003^\u0002!\tAa8\u00021\u001d,G\u000fV1tW6\u000bg.Y4fe\u0006[7.Y\"p]\u001aLw\r\u0006\u0003\u0003>\n\u0005\bb\u0002B-\u00057\u0004\r\u0001\u001c\u0005\b\u0005K\u0004A\u0011\u0001Bt\u0003I\u0019X\r\u001e#fM\u0006,H\u000e^\"j\u0007>tg-[4\u0015\u0007\u0005\u0014I\u000fC\u0004\u0003D\n\r\b\u0019A\u0010\t\u000f\t5\b\u0001\"\u0001\u0003p\u0006y2\u000f^1siJ+7o\\;sG\u0016l\u0015M\\1hKJ\f5\r^8s'f\u001cH/Z7\u0015\t\u0005\u001d$\u0011\u001f\u0005\b\u00053\u0012Y\u000f1\u0001m\u0011\u001d\u0011)\u0010\u0001C\u0001\u0005o\f!d\u001d;beRTuNY'b]\u0006<WM]!di>\u00148+_:uK6$B!a\u001a\u0003z\"9!\u0011\fBz\u0001\u0004a\u0007b\u0002B\u007f\u0001\u0011\u0005!q`\u0001\u001cgR\f'\u000f\u001e+bg.l\u0015M\\1hKJ\f5\r^8s'f\u001cH/Z7\u0015\t\u0005\u001d4\u0011\u0001\u0005\b\u00053\u0012Y\u00101\u0001m\u0011\u001d\u0019)\u0001\u0001C\u0001\u0007\u000f\t\u0011d\u001d;beRTuNY\"mS\u0016tG/Q2u_J\u001c\u0016p\u001d;f[R!\u0011qMB\u0005\u0011!\u0019Yaa\u0001A\u0002\r5\u0011!\u00026pE&#\u0005\u0003BB\b\u00073i!a!\u0005\u000b\t\rM1QC\u0001\u0007G>lWn\u001c8\u000b\u0007\r]a!A\u0002ba&LAaa\u0007\u0004\u0012\t)!j\u001c2J\t\"91q\u0004\u0001\u0005\u0002\r\u0005\u0012!B:uCJ$H#A1\t\u000f\r}\u0001\u0001\"\u0001\u0004&Q\u0019\u0011ma\n\t\u000f\r%21\u0005a\u0001U\u0005qr/Y5u\r>\u0014H+Y:l\u001b\u0006t\u0017mZ3s%\u0016<\u0017n\u001d;sCRLwN\u001c\u0005\b\u0007[\u0001A\u0011AB\u0018\u00039\u0019H/\u0019:u/\u0016\u00147+\u001a:wKJ$\u0002\"!*\u00042\rM2q\u0007\u0005\b\u0005\u0007\u001cY\u00031\u0001 \u0011!\u0019)da\u000bA\u0002\u0005\u001d\u0014aC1di>\u00148+_:uK6D\u0001b!\u000f\u0004,\u0001\u000711H\u0001\u0012U>\u0014W*\u00198bO\u0016\u0014\u0018i[6b+Jc\u0005\u0003BB\u001f\u0007\u0007r1aKB \u0013\r\u0019\t\u0005L\u0001\u0007!J,G-\u001a4\n\u0007%\u001b)EC\u0002\u0004B1Bqa!\u0013\u0001\t\u0003\u0019\t#\u0001\u0003ti>\u0004\bbBB'\u0001\u0011E1\u0011E\u0001\tg\",H\u000fZ8x]\"91\u0011\u000b\u0001\u0005\u0002\r\u0005\u0012\u0001E1xC&$H+\u001a:nS:\fG/[8o\u0011\u0019\u0019)\u0006\u0001C\u0001S\u00059!/\u001e8oS:<\u0007bBB-\u0001\u0011\u00051\u0011E\u0001\"o\u0006LGOR8s)\u0006\u001c8.T1oC\u001e,'o\u001d+p\u0005\u0016\u0014VmZ5ti\u0016\u0014X\r\u001a\u0015\u0007\u0007/\u001aifa\u001f\u0011\u000b-\u001ayfa\u0019\n\u0007\r\u0005DF\u0001\u0004uQJ|wo\u001d\t\u0005\u0007K\u001a9\u0007\u0004\u0001\u0005\u000f\r%\u0004A1\u0001\u0004l\t\tA+\u0005\u0003\u0004n\rM\u0004cA\u0016\u0004p%\u00191\u0011\u000f\u0017\u0003\u000f9{G\u000f[5oOB!1QOB<\u001d\rY\u0013QL\u0005\u0005\u0007s\n)GA\u0005UQJ|w/\u00192mK\u000e\u00121Q\u0010\t\u0005\u0003#\u001ay(\u0003\u0003\u0004\u0002\u0006\u0015$\u0001F%oi\u0016\u0014(/\u001e9uK\u0012,\u0005pY3qi&|g\u000e\u000b\u0004\u0004X\r\u001551\u0012\t\u0006W\r}3q\u0011\t\u0005\u0007K\u001aI\tB\u0004\u0004j\u0001\u0011\raa\u001b$\u0005\r5\u0005\u0003BBH\u0007/sAa!%\u0004\u0016:!\u00111KBJ\u0013\t)F&C\u0002\u0002`QKAa!'\u0004\u001c\n\u0001B+[7f_V$X\t_2faRLwN\u001c\u0006\u0004\u0003?\"\u0006bBB-\u0001\u0011\u00051q\u0014\u000b\u0004C\u000e\u0005\u0006\u0002CA\u0004\u0007;\u0003\r!a\u0003)\r\ru5QUB>!\u0015Y3qLBT!\u0011\u0019)g!+\u0005\u000f\r%\u0004A1\u0001\u0004l!21QTBW\u0007\u0017\u0003RaKB0\u0007_\u0003Ba!\u001a\u00042\u001291\u0011\u000e\u0001C\u0002\r-\u0004bBB[\u0001\u0011\u00051qW\u0001\u0011gV\u0014W.\u001b;K_\n\fe\u000eZ,bSR$ba!/\u0004@\u000e=\u0007\u0003BB\b\u0007wKAa!0\u0004\u0012\t\u0011\"j\u001c2Fq\u0016\u001cW\u000f^5p]J+7/\u001e7u\u0011!\u0019\tma-A\u0002\r\r\u0017\u0001\u00036pE\u001e\u0013\u0018\r\u001d5\u0011\t\r\u001571Z\u0007\u0003\u0007\u000fT1a!3\u0005\u0003!QwNY4sCBD\u0017\u0002BBg\u0007\u000f\u0014\u0001BS8c\u000fJ\f\u0007\u000f\u001b\u0005\b\u0007#\u001c\u0019\f1\u0001+\u00031\u0001(/\u001b8u+B$\u0017\r^3tQ\u0019\u0019\u0019l!6\u0004\\B)1fa\u0018\u0004XB!1QMBm\t\u001d\u0019I\u0007\u0001b\u0001\u0007W\u001a#a!8\u0011\t\r}7Q]\u0007\u0003\u0007CT1aa9\u0005\u0003\u0019\u0019G.[3oi&!1q]Bq\u0005UQuNY#yK\u000e,H/[8o\u000bb\u001cW\r\u001d;j_:Dqa!.\u0001\t\u0003\u0019Y\u000f\u0006\u0005\u0004:\u000e58q^By\u0011!\u0019\tm!;A\u0002\r\r\u0007bBBi\u0007S\u0004\rA\u000b\u0005\t\u0003\u000f\u0019I\u000f1\u0001\u0002\f!91Q\u0017\u0001\u0005\u0002\rUHCCB]\u0007o\u001cIpa?\u0004~\"A1\u0011YBz\u0001\u0004\u0019\u0019\rC\u0004\u0004R\u000eM\b\u0019\u0001\u0016\t\u0011\u0005\u001d11\u001fa\u0001\u0003\u0017A\u0001ba@\u0004t\u0002\u0007!qA\u0001\u0017Y\u0016\fG-\u001a:SKR\u0014\u0018.\u001a<bYN+'O^5dK\"211\u001fC\u0002\u00077\u0004RaKB0\t\u000b\u0001Ba!\u001a\u0005\b\u001191\u0011\u000e\u0001C\u0002\r-\u0004b\u0002C\u0006\u0001\u0011\u0005AQB\u0001\u0012gV\u0014W.\u001b;K_\n$U\r^1dQ\u0016$G\u0003\u0002C\b\t+\u0001Baa\u0004\u0005\u0012%!A1CB\t\u0005MQuNY*vE6L7o]5p]J+7/\u001e7u\u0011!\u0019\t\r\"\u0003A\u0002\r\r\u0007F\u0002C\u0005\t3\u0019Y\u000eE\u0003,\u0007?\"Y\u0002\u0005\u0003\u0004f\u0011uAaBB5\u0001\t\u000711\u000e\u0005\b\tC\u0001A\u0011\u0001C\u0012\u0003q\u0019\b.\u001e;e_^t'j\u001c2DY&,g\u000e^!di>\u00148+_:uK6$2!\u0019C\u0013\u0011!\u0019)\u0004b\bA\u0002\u0005\u001d\u0004b\u0002C\u0015\u0001\u0011EA1F\u0001\u001dGJ,\u0017\r^3MK\u0006$WM\u001d*fiJLWM^1m'\u0016\u0014h/[2f)\t\u00119\u0001C\u0004\u00050\u0001!\tb!\t\u0002\u0017\rdW-\u0019:MK\u0006$WM\u001d\u0005\b\tg\u0001A\u0011\tC\u001b\u0003Mqw\u000e^5gs2+\u0017\rZ3s\u0003\u0012$'/Z:t)\u0015\tGq\u0007C\u001e\u0011!!I\u0004\"\rA\u0002\rm\u0012aB1eIJ,7o\u001d\u0005\t\t{!\t\u00041\u0001\u0005@\u0005yA.Z1eKJ\u001cVm]:j_:LE\t\u0005\u0003\u0003\u0004\u0012\u0005\u0013\u0002\u0002C\"\u0005k\u0011A!V+J\t\"9Aq\t\u0001\u0005B\u0011%\u0013a\u00035b]\u0012dW-\u0012:s_J$2!\u0019C&\u0011!!i\u0005\"\u0012A\u0002\u0011=\u0013!C3yG\u0016\u0004H/[8o!\u0011\t\t\u0006\"\u0015\n\t\u0011M\u0013Q\r\u0002\n\u000bb\u001cW\r\u001d;j_:\u0004")
public abstract class FlinkMiniCluster
implements LeaderRetrievalListener {
    private final Configuration userConfiguration;
    private final boolean useSingleActorSystem;
    private final Logger LOG;
    private final String hostname;
    private final Configuration configuration;
    private Promise<ActorGateway> leaderGateway;
    private Promise<Object> leaderIndex;
    private final Object futureLock;
    private final ExecutionContextExecutor executionContext;
    private final FiniteDuration timeout;
    private final RecoveryMode recoveryMode;
    private final int numJobManagers;
    private final int numTaskManagers;
    private Option<Seq<ActorSystem>> jobManagerActorSystems;
    private Option<Seq<ActorRef>> jobManagerActors;
    private Option<WebMonitor> webMonitor;
    private Option<Seq<ActorSystem>> taskManagerActorSystems;
    private Option<Seq<ActorRef>> taskManagerActors;
    private Option<Seq<ActorSystem>> resourceManagerActorSystems;
    private Option<Seq<ActorRef>> resourceManagerActors;
    private Option<LeaderRetrievalService> jobManagerLeaderRetrievalService;
    private boolean isRunning;
    private final ExecutorService futureExecutor;
    private final ExecutorService ioExecutor;

    public Configuration userConfiguration() {
        return this.userConfiguration;
    }

    public boolean useSingleActorSystem() {
        return this.useSingleActorSystem;
    }

    public Logger LOG() {
        return this.LOG;
    }

    public String hostname() {
        return this.hostname;
    }

    public Configuration configuration() {
        return this.configuration;
    }

    public Promise<ActorGateway> leaderGateway() {
        return this.leaderGateway;
    }

    public void leaderGateway_$eq(Promise<ActorGateway> x$1) {
        this.leaderGateway = x$1;
    }

    public Promise<Object> leaderIndex() {
        return this.leaderIndex;
    }

    public void leaderIndex_$eq(Promise<Object> x$1) {
        this.leaderIndex = x$1;
    }

    public Object futureLock() {
        return this.futureLock;
    }

    public ExecutionContextExecutor executionContext() {
        return this.executionContext;
    }

    public FiniteDuration timeout() {
        return this.timeout;
    }

    public RecoveryMode recoveryMode() {
        return this.recoveryMode;
    }

    public int numJobManagers() {
        return this.numJobManagers;
    }

    public int numTaskManagers() {
        return this.numTaskManagers;
    }

    public Option<Seq<ActorSystem>> jobManagerActorSystems() {
        return this.jobManagerActorSystems;
    }

    public void jobManagerActorSystems_$eq(Option<Seq<ActorSystem>> x$1) {
        this.jobManagerActorSystems = x$1;
    }

    public Option<Seq<ActorRef>> jobManagerActors() {
        return this.jobManagerActors;
    }

    public void jobManagerActors_$eq(Option<Seq<ActorRef>> x$1) {
        this.jobManagerActors = x$1;
    }

    public Option<WebMonitor> webMonitor() {
        return this.webMonitor;
    }

    public void webMonitor_$eq(Option<WebMonitor> x$1) {
        this.webMonitor = x$1;
    }

    public Option<Seq<ActorSystem>> taskManagerActorSystems() {
        return this.taskManagerActorSystems;
    }

    public void taskManagerActorSystems_$eq(Option<Seq<ActorSystem>> x$1) {
        this.taskManagerActorSystems = x$1;
    }

    public Option<Seq<ActorRef>> taskManagerActors() {
        return this.taskManagerActors;
    }

    public void taskManagerActors_$eq(Option<Seq<ActorRef>> x$1) {
        this.taskManagerActors = x$1;
    }

    public Option<Seq<ActorSystem>> resourceManagerActorSystems() {
        return this.resourceManagerActorSystems;
    }

    public void resourceManagerActorSystems_$eq(Option<Seq<ActorSystem>> x$1) {
        this.resourceManagerActorSystems = x$1;
    }

    public Option<Seq<ActorRef>> resourceManagerActors() {
        return this.resourceManagerActors;
    }

    public void resourceManagerActors_$eq(Option<Seq<ActorRef>> x$1) {
        this.resourceManagerActors = x$1;
    }

    public Option<LeaderRetrievalService> jobManagerLeaderRetrievalService() {
        return this.jobManagerLeaderRetrievalService;
    }

    public void jobManagerLeaderRetrievalService_$eq(Option<LeaderRetrievalService> x$1) {
        this.jobManagerLeaderRetrievalService = x$1;
    }

    private boolean isRunning() {
        return this.isRunning;
    }

    private void isRunning_$eq(boolean x$1) {
        this.isRunning = x$1;
    }

    public ExecutorService futureExecutor() {
        return this.futureExecutor;
    }

    public ExecutorService ioExecutor() {
        return this.ioExecutor;
    }

    public abstract Configuration generateConfiguration(Configuration var1);

    public abstract ActorRef startResourceManager(int var1, ActorSystem var2);

    public abstract ActorRef startJobManager(int var1, ActorSystem var2);

    public abstract ActorRef startTaskManager(int var1, ActorSystem var2);

    public int getNumberOfJobManagers() {
        RecoveryMode recoveryMode = this.recoveryMode();
        RecoveryMode recoveryMode2 = RecoveryMode.STANDALONE;
        return !(recoveryMode != null ? !((Object)((Object)recoveryMode)).equals((Object)recoveryMode2) : recoveryMode2 != null) ? 1 : this.configuration().getInteger("local.number-jobmanager", 1);
    }

    public int getNumberOfResourceManagers() {
        RecoveryMode recoveryMode = this.recoveryMode();
        RecoveryMode recoveryMode2 = RecoveryMode.STANDALONE;
        return !(recoveryMode != null ? !((Object)((Object)recoveryMode)).equals((Object)recoveryMode2) : recoveryMode2 != null) ? 1 : this.configuration().getInteger("local.number-resourcemanager", 1);
    }

    public List<ActorRef> getJobManagersAsJava() {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.jobManagerActors().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        })).asJava();
    }

    public Seq<ActorRef> getTaskManagers() {
        return (Seq)this.taskManagerActors().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        });
    }

    public List<ActorRef> getTaskManagersAsJava() {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.taskManagerActors().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        })).asJava();
    }

    public Future<ActorGateway> getLeaderGatewayFuture() {
        return this.leaderGateway().future();
    }

    public ActorGateway getLeaderGateway(FiniteDuration timeout) {
        Future<ActorGateway> jmFuture = this.getLeaderGatewayFuture();
        return (ActorGateway)Await$.MODULE$.result(jmFuture, (Duration)timeout);
    }

    public Future<Object> getLeaderIndexFuture() {
        return this.leaderIndex().future();
    }

    public int getLeaderIndex(FiniteDuration timeout) {
        Future<Object> indexFuture = this.getLeaderIndexFuture();
        return BoxesRunTime.unboxToInt((Object)Await$.MODULE$.result(indexFuture, (Duration)timeout));
    }

    public Config getResourceManagerAkkaConfig(int index) {
        Config config;
        if (this.useSingleActorSystem()) {
            config = AkkaUtils$.MODULE$.getAkkaConfig(this.configuration(), (Option<Tuple2<String, Object>>)None$.MODULE$);
        } else {
            int port = this.configuration().getInteger("resourcemanager.rpc.port", 0);
            int resolvedPort = port != 0 ? port + index : port;
            config = AkkaUtils$.MODULE$.getAkkaConfig(this.configuration(), (Option<Tuple2<String, Object>>)new Some((Object)new Tuple2((Object)this.hostname(), (Object)BoxesRunTime.boxToInteger((int)resolvedPort))));
        }
        return config;
    }

    public Config getJobManagerAkkaConfig(int index) {
        Config config;
        if (this.useSingleActorSystem()) {
            config = AkkaUtils$.MODULE$.getAkkaConfig(this.configuration(), (Option<Tuple2<String, Object>>)None$.MODULE$);
        } else {
            int port = this.configuration().getInteger("jobmanager.rpc.port", 6123);
            int resolvedPort = port != 0 ? port + index : port;
            config = AkkaUtils$.MODULE$.getAkkaConfig(this.configuration(), (Option<Tuple2<String, Object>>)new Some((Object)new Tuple2((Object)this.hostname(), (Object)BoxesRunTime.boxToInteger((int)resolvedPort))));
        }
        return config;
    }

    public Config getTaskManagerAkkaConfig(int index) {
        int port = this.configuration().getInteger("taskmanager.rpc.port", 0);
        int resolvedPort = port != 0 ? port + index : port;
        return AkkaUtils$.MODULE$.getAkkaConfig(this.configuration(), (Option<Tuple2<String, Object>>)new Some((Object)new Tuple2((Object)this.hostname(), (Object)BoxesRunTime.boxToInteger((int)resolvedPort))));
    }

    public void setDefaultCiConfig(Configuration config) {
        if (scala.sys.package$.MODULE$.env().contains((Object)"CI")) {
            if (config.getString("akka.ask.timeout", null) == null) {
                Duration duration = Duration$.MODULE$.apply(ConfigConstants.DEFAULT_AKKA_ASK_TIMEOUT).$times(10.0);
                config.setString("akka.ask.timeout", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "s"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)duration.toSeconds())})));
                this.LOG().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Akka ask timeout set to ", "s"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)duration.toSeconds())})));
            }
        }
    }

    public ActorSystem startResourceManagerActorSystem(int index) {
        Config config = this.getResourceManagerAkkaConfig(index);
        return AkkaUtils$.MODULE$.createActorSystem(config);
    }

    public ActorSystem startJobManagerActorSystem(int index) {
        Config config = this.getJobManagerAkkaConfig(index);
        return AkkaUtils$.MODULE$.createActorSystem(config);
    }

    public ActorSystem startTaskManagerActorSystem(int index) {
        Config config = this.getTaskManagerAkkaConfig(index);
        return AkkaUtils$.MODULE$.createActorSystem(config);
    }

    /*
     * Enabled aggressive block sorting
     */
    public ActorSystem startJobClientActorSystem(JobID jobID) {
        ActorSystem actorSystem;
        if (!this.useSingleActorSystem()) {
            actorSystem = JobClient.startJobClientActorSystem(this.configuration());
            return actorSystem;
        }
        Option<Seq<ActorSystem>> option = this.jobManagerActorSystems();
        if (option instanceof Some) {
            ActorSystem actorSystem2;
            Some some = (Some)option;
            Seq jmActorSystems = (Seq)some.x();
            actorSystem = actorSystem2 = (ActorSystem)jmActorSystems.apply(0);
            return actorSystem;
        }
        None$ none$ = None$.MODULE$;
        Option<Seq<ActorSystem>> option2 = option;
        if (none$ == null) {
            if (option2 == null) throw new JobExecutionException(jobID, "The FlinkMiniCluster has not been started yet.");
            throw new MatchError(option);
        }
        if (!none$.equals(option2)) throw new MatchError(option);
        throw new JobExecutionException(jobID, "The FlinkMiniCluster has not been started yet.");
    }

    public void start() {
        this.start(true);
    }

    public void start(boolean waitForTaskManagerRegistration) {
        ObjectRef singleActorSystem$lzy = new ObjectRef(null);
        VolatileByteRef bitmap$0 = new VolatileByteRef(0);
        this.LOG().info("Starting FlinkMiniCluster.");
        Tuple2 tuple2 = ((GenericTraversableTemplate)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numJobManagers()).map((Function1)new $anonfun$1(this, singleActorSystem$lzy, bitmap$0), IndexedSeq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.conforms());
        if (tuple2 != null) {
            Tuple2 tuple22;
            IndexedSeq jmActorSystems = (IndexedSeq)tuple2._1();
            IndexedSeq jmActors = (IndexedSeq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)jmActorSystems, (Object)jmActors);
            IndexedSeq jmActorSystems2 = (IndexedSeq)tuple23._1();
            IndexedSeq jmActors2 = (IndexedSeq)tuple23._2();
            this.jobManagerActorSystems_$eq((Option<Seq<ActorSystem>>)new Some((Object)jmActorSystems2));
            this.jobManagerActors_$eq((Option<Seq<ActorRef>>)new Some((Object)jmActors2));
            LeaderRetrievalService lrs = this.createLeaderRetrievalService();
            this.jobManagerLeaderRetrievalService_$eq((Option<LeaderRetrievalService>)new Some((Object)lrs));
            lrs.start(this);
            Tuple2 tuple24 = ((GenericTraversableTemplate)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getNumberOfResourceManagers()).map((Function1)new $anonfun$2(this, jmActorSystems2), IndexedSeq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.conforms());
            if (tuple24 != null) {
                Tuple2 tuple25;
                IndexedSeq rmActorSystems = (IndexedSeq)tuple24._1();
                IndexedSeq rmActors = (IndexedSeq)tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)rmActorSystems, (Object)rmActors);
                IndexedSeq rmActorSystems2 = (IndexedSeq)tuple26._1();
                IndexedSeq rmActors2 = (IndexedSeq)tuple26._2();
                this.resourceManagerActorSystems_$eq((Option<Seq<ActorSystem>>)new Some((Object)rmActorSystems2));
                this.resourceManagerActors_$eq((Option<Seq<ActorRef>>)new Some((Object)rmActors2));
                Tuple2 tuple27 = ((GenericTraversableTemplate)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numTaskManagers()).map((Function1)new $anonfun$3(this, jmActorSystems2), IndexedSeq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.conforms());
                if (tuple27 != null) {
                    Tuple2 tuple28;
                    IndexedSeq tmActorSystems = (IndexedSeq)tuple27._1();
                    IndexedSeq tmActors = (IndexedSeq)tuple27._2();
                    Tuple2 tuple29 = tuple28 = new Tuple2((Object)tmActorSystems, (Object)tmActors);
                    IndexedSeq tmActorSystems2 = (IndexedSeq)tuple29._1();
                    IndexedSeq tmActors2 = (IndexedSeq)tuple29._2();
                    this.taskManagerActorSystems_$eq((Option<Seq<ActorSystem>>)new Some((Object)tmActorSystems2));
                    this.taskManagerActors_$eq((Option<Seq<ActorRef>>)new Some((Object)tmActors2));
                    String jobManagerAkkaURL = AkkaUtils$.MODULE$.getAkkaURL((ActorSystem)jmActorSystems2.apply(0), (ActorRef)jmActors2.apply(0));
                    this.webMonitor_$eq(this.startWebServer(this.configuration(), (ActorSystem)jmActorSystems2.apply(0), jobManagerAkkaURL));
                    if (waitForTaskManagerRegistration) {
                        this.waitForTaskManagersToBeRegistered();
                    }
                    this.isRunning_$eq(true);
                    return;
                }
                throw new MatchError((Object)tuple27);
            }
            throw new MatchError((Object)tuple24);
        }
        throw new MatchError((Object)tuple2);
    }

    public Option<WebMonitor> startWebServer(Configuration config, ActorSystem actorSystem, String jobManagerAkkaURL) {
        None$ none$;
        if (config.getBoolean("local.start-webserver", false) && config.getInteger("jobmanager.web.port", 0) >= 0) {
            StandaloneLeaderRetrievalService leaderRetrievalService = new StandaloneLeaderRetrievalService(jobManagerAkkaURL);
            this.LOG().info("Starting JobManger web frontend");
            Option webServer = Option$.MODULE$.apply((Object)WebMonitorUtils.startWebRuntimeMonitor(config, leaderRetrievalService, actorSystem));
            webServer.foreach((Function1)new Serializable(this, jobManagerAkkaURL){
                public static final long serialVersionUID = 0L;
                private final String jobManagerAkkaURL$1;

                public final void apply(WebMonitor x$4) {
                    x$4.start(this.jobManagerAkkaURL$1);
                }
                {
                    this.jobManagerAkkaURL$1 = jobManagerAkkaURL$1;
                }
            });
            none$ = webServer;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void stop() {
        this.LOG().info("Stopping FlinkMiniCluster.");
        this.shutdown();
        this.awaitTermination();
        this.jobManagerLeaderRetrievalService().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(LeaderRetrievalService x$5) {
                x$5.stop();
            }
        });
        this.isRunning_$eq(false);
        ExecutorUtils.gracefulShutdown(this.timeout().toMillis(), TimeUnit.MILLISECONDS, this.futureExecutor(), this.ioExecutor());
    }

    public void shutdown() {
        this.webMonitor().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(WebMonitor x$6) {
                x$6.stop();
            }
        });
        Seq tmFutures = (Seq)this.taskManagerActors().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FlinkMiniCluster $outer;

            public final Seq<Future<Boolean>> apply(Seq<ActorRef> x$7) {
                return (Seq)x$7.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;

                    public final Future<Boolean> apply(ActorRef x$8) {
                        return Patterns$.MODULE$.gracefulStop(x$8, this.$outer.org$apache$flink$runtime$minicluster$FlinkMiniCluster$$anonfun$$$outer().timeout());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ FlinkMiniCluster org$apache$flink$runtime$minicluster$FlinkMiniCluster$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        });
        Seq jmFutures = (Seq)this.jobManagerActors().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FlinkMiniCluster $outer;

            public final Seq<Future<Boolean>> apply(Seq<ActorRef> x$9) {
                return (Seq)x$9.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;

                    public final Future<Boolean> apply(ActorRef x$10) {
                        return Patterns$.MODULE$.gracefulStop(x$10, this.$outer.org$apache$flink$runtime$minicluster$FlinkMiniCluster$$anonfun$$$outer().timeout());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ FlinkMiniCluster org$apache$flink$runtime$minicluster$FlinkMiniCluster$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        });
        Seq rmFutures = (Seq)this.resourceManagerActors().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FlinkMiniCluster $outer;

            public final Seq<Future<Boolean>> apply(Seq<ActorRef> x$11) {
                return (Seq)x$11.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final Future<Boolean> apply(ActorRef x$12) {
                        return Patterns$.MODULE$.gracefulStop(x$12, this.$outer.org$apache$flink$runtime$minicluster$FlinkMiniCluster$$anonfun$$$outer().timeout());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ FlinkMiniCluster org$apache$flink$runtime$minicluster$FlinkMiniCluster$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        });
        Await$.MODULE$.ready((Awaitable)Future$.MODULE$.sequence((TraversableOnce)((TraversableLike)jmFutures.$plus$plus((GenTraversableOnce)tmFutures, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)rmFutures, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom(), (ExecutionContext)this.executionContext()), (Duration)this.timeout());
        if (!this.useSingleActorSystem()) {
            this.taskManagerActorSystems().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Seq<ActorSystem> x$13) {
                    x$13.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ActorSystem x$14) {
                            x$14.shutdown();
                        }
                    });
                }
            });
            this.resourceManagerActorSystems().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Seq<ActorSystem> x$15) {
                    x$15.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ActorSystem x$16) {
                            x$16.shutdown();
                        }
                    });
                }
            });
        }
        this.jobManagerActorSystems().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<ActorSystem> x$17) {
                x$17.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(ActorSystem x$18) {
                        x$18.shutdown();
                    }
                });
            }
        });
    }

    public void awaitTermination() {
        this.jobManagerActorSystems().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<ActorSystem> x$19) {
                x$19.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(ActorSystem x$20) {
                        x$20.awaitTermination();
                    }
                });
            }
        });
        this.resourceManagerActorSystems().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<ActorSystem> x$21) {
                x$21.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(ActorSystem x$22) {
                        x$22.awaitTermination();
                    }
                });
            }
        });
        this.taskManagerActorSystems().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<ActorSystem> x$23) {
                x$23.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(ActorSystem x$24) {
                        x$24.awaitTermination();
                    }
                });
            }
        });
    }

    public boolean running() {
        return this.isRunning();
    }

    public void waitForTaskManagersToBeRegistered() throws TimeoutException, InterruptedException {
        this.waitForTaskManagersToBeRegistered(this.timeout());
    }

    public void waitForTaskManagersToBeRegistered(FiniteDuration timeout) throws TimeoutException, InterruptedException {
        Seq futures = (Seq)this.taskManagerActors().map((Function1)new Serializable(this, timeout){
            public static final long serialVersionUID = 0L;
            public final FiniteDuration timeout$1;

            public final Seq<Future<Object>> apply(Seq<ActorRef> x$25) {
                return (Seq)x$25.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$10 $outer;

                    public final Future<Object> apply(ActorRef taskManager) {
                        return AskableActorRef$.MODULE$.$qmark$extension(package$.MODULE$.ask(taskManager), (Object)TaskManagerMessages$NotifyWhenRegisteredAtJobManager$.MODULE$, Timeout$.MODULE$.durationToTimeout(this.$outer.timeout$1));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                this.timeout$1 = timeout$1;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        });
        Await$.MODULE$.ready((Awaitable)Future$.MODULE$.sequence((TraversableOnce)futures, Seq$.MODULE$.canBuildFrom(), (ExecutionContext)this.executionContext()), (Duration)timeout);
    }

    public JobExecutionResult submitJobAndWait(JobGraph jobGraph, boolean printUpdates) throws JobExecutionException {
        return this.submitJobAndWait(jobGraph, printUpdates, this.timeout());
    }

    public JobExecutionResult submitJobAndWait(JobGraph jobGraph, boolean printUpdates, FiniteDuration timeout) {
        return this.submitJobAndWait(jobGraph, printUpdates, timeout, this.createLeaderRetrievalService());
    }

    public JobExecutionResult submitJobAndWait(JobGraph jobGraph, boolean printUpdates, FiniteDuration timeout, LeaderRetrievalService leaderRetrievalService) throws JobExecutionException {
        ActorSystem clientActorSystem = this.startJobClientActorSystem(jobGraph.getJobID());
        try {
            return JobClient.submitJobAndWait(clientActorSystem, leaderRetrievalService, jobGraph, timeout, printUpdates, this.getClass().getClassLoader());
        }
        finally {
            if (!this.useSingleActorSystem()) {
                this.shutdownJobClientActorSystem(clientActorSystem);
            }
        }
    }

    public JobSubmissionResult submitJobDetached(JobGraph jobGraph) throws JobExecutionException {
        ActorGateway jobManagerGateway;
        try {
            jobManagerGateway = this.getLeaderGateway(this.timeout());
        }
        catch (Throwable throwable) {
            throw new JobExecutionException(jobGraph.getJobID(), "Could not retrieve JobManager ActorRef.", throwable);
        }
        JobClient.submitJobDetached(jobManagerGateway, jobGraph, this.timeout(), this.getClass().getClassLoader());
        return new JobSubmissionResult(jobGraph.getJobID());
    }

    public void shutdownJobClientActorSystem(ActorSystem actorSystem) {
        if (!this.useSingleActorSystem()) {
            actorSystem.shutdown();
        }
    }

    public LeaderRetrievalService createLeaderRetrievalService() {
        Tuple2 tuple2 = new Tuple2(this.jobManagerActorSystems(), this.jobManagerActors());
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                Seq jmActorSystems = (Seq)some.x();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Seq jmActors = (Seq)some2.x();
                    RecoveryMode recoveryMode = this.recoveryMode();
                    RecoveryMode recoveryMode2 = RecoveryMode.STANDALONE;
                    LeaderRetrievalService leaderRetrievalService = !(recoveryMode != null ? !((Object)((Object)recoveryMode)).equals((Object)recoveryMode2) : recoveryMode2 != null) ? new StandaloneLeaderRetrievalService(AkkaUtils$.MODULE$.getAkkaURL((ActorSystem)jmActorSystems.apply(0), (ActorRef)jmActors.apply(0))) : ZooKeeperUtils.createLeaderRetrievalService(this.configuration());
                    return leaderRetrievalService;
                }
            }
        }
        throw new Exception("The FlinkMiniCluster has not been started properly.");
    }

    public void clearLeader() {
        Object object = this.futureLock();
        synchronized (object) {
            this.leaderGateway_$eq((Promise<ActorGateway>)Promise$.MODULE$.apply());
            this.leaderIndex_$eq((Promise<Object>)Promise$.MODULE$.apply());
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void notifyLeaderAddress(String address, UUID leaderSessionID) {
        if (address == null || address.equals("")) ** GOTO lbl38
        var3_3 = new Tuple2(this.jobManagerActorSystems(), this.jobManagerActors());
        if (var3_3 == null) ** GOTO lbl-1000
        var4_4 = (Option)var3_3._1();
        var5_5 = (Option)var3_3._2();
        if (!(var4_4 instanceof Some)) ** GOTO lbl-1000
        var6_6 = (Some)var4_4;
        systems = (Seq)var6_6.x();
        if (var5_5 instanceof Some) {
            var8_8 = (Some)var5_5;
            actors = (Seq)var8_8.x();
            actorPaths = (Seq)((TraversableLike)((IterableLike)systems.zip((GenIterable)actors, Seq$.MODULE$.canBuildFrom())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple3<String, ActorRef, Object> apply(Tuple2<Tuple2<ActorSystem, ActorRef>, Object> x0$1) {
                    Tuple2<Tuple2<ActorSystem, ActorRef>, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        Tuple2 tuple22 = (Tuple2)tuple2._1();
                        int index = tuple2._2$mcI$sp();
                        if (tuple22 != null) {
                            ActorSystem system = (ActorSystem)tuple22._1();
                            ActorRef actor = (ActorRef)tuple22._2();
                            Tuple3 tuple3 = new Tuple3((Object)AkkaUtils$.MODULE$.getAkkaURL(system, actor), (Object)actor, (Object)BoxesRunTime.boxToInteger((int)index));
                            return tuple3;
                        }
                    }
                    throw new MatchError(tuple2);
                }
            }, Seq$.MODULE$.canBuildFrom());
            var11_11 = actorPaths.find((Function1)new Serializable(this, address){
                public static final long serialVersionUID = 0L;
                private final String address$1;

                public final boolean apply(Tuple3<String, ActorRef, Object> x0$2) {
                    Tuple3<String, ActorRef, Object> tuple3 = x0$2;
                    if (tuple3 != null) {
                        String path = (String)tuple3._1();
                        boolean bl = path.equals(this.address$1);
                        return bl;
                    }
                    throw new MatchError(tuple3);
                }
                {
                    this.address$1 = address$1;
                }
            }).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<ActorRef, Object> apply(Tuple3<String, ActorRef, Object> x) {
                    return new Tuple2(x._2(), x._3());
                }
            });
        } else lbl-1000:
        // 3 sources

        {
            var11_11 = None$.MODULE$;
        }
        selectedLeader = var11_11;
        var13_13 = this.futureLock();
        synchronized (var13_13) {
            block11: {
                block10: {
                    block9: {
                        if (this.leaderGateway().isCompleted()) {
                            this.leaderGateway_$eq((Promise<ActorGateway>)Promise$.MODULE$.apply());
                            this.leaderIndex_$eq((Promise<Object>)Promise$.MODULE$.apply());
                        }
                        if (!((var14_14 = selectedLeader) instanceof Some) || (var16_16 = (Tuple2)(var15_15 = (Some)var14_14).x()) == null) break block9;
                        leader = (ActorRef)var16_16._1();
                        index = var16_16._2$mcI$sp();
                        this.leaderGateway().success((Object)new AkkaActorGateway(leader, leaderSessionID));
                        var19_19 = this.leaderIndex().success((Object)BoxesRunTime.boxToInteger((int)index));
                        break block10;
                    }
                    v0 = None$.MODULE$;
                    var20_20 = var14_14;
                    if (v0 != null ? v0.equals(var20_20) == false : var20_20 != null) break block11;
                    this.leaderGateway().failure((Throwable)new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find job manager with address ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{address}))));
                    var19_19 = this.leaderIndex().failure((Throwable)new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find job manager index with address ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{address}))));
                }
                return;
            }
            throw new MatchError((Object)var14_14);
        }
    }

    @Override
    public void handleError(Exception exception) {
        Object object = this.futureLock();
        synchronized (object) {
            Promise promise;
            if (this.leaderGateway().isCompleted()) {
                this.leaderGateway_$eq((Promise<ActorGateway>)Promise$.MODULE$.failed((Throwable)exception));
                this.leaderIndex_$eq((Promise<Object>)Promise$.MODULE$.failed((Throwable)exception));
                promise = BoxedUnit.UNIT;
            } else {
                this.leaderGateway().failure((Throwable)exception);
                promise = this.leaderIndex().failure((Throwable)exception);
            }
            return;
        }
    }

    private final ActorSystem singleActorSystem$lzycompute$1(ObjectRef singleActorSystem$lzy$1, VolatileByteRef bitmap$0$1) {
        FlinkMiniCluster flinkMiniCluster = this;
        synchronized (flinkMiniCluster) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                singleActorSystem$lzy$1.elem = this.startJobManagerActorSystem(0);
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (ActorSystem)singleActorSystem$lzy$1.elem;
        }
    }

    public final ActorSystem org$apache$flink$runtime$minicluster$FlinkMiniCluster$$singleActorSystem$1(ObjectRef singleActorSystem$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.singleActorSystem$lzycompute$1(singleActorSystem$lzy$1, bitmap$0$1) : (ActorSystem)singleActorSystem$lzy$1.elem;
    }

    public FlinkMiniCluster(Configuration userConfiguration, boolean useSingleActorSystem) {
        this.userConfiguration = userConfiguration;
        this.useSingleActorSystem = useSingleActorSystem;
        this.LOG = LoggerFactory.getLogger(FlinkMiniCluster.class);
        this.hostname = userConfiguration.getString("jobmanager.rpc.address", InetAddress.getByName("localhost").getHostAddress());
        this.configuration = this.generateConfiguration(userConfiguration);
        this.leaderGateway = Promise$.MODULE$.apply();
        this.leaderIndex = Promise$.MODULE$.apply();
        this.futureLock = new Object();
        this.executionContext = ExecutionContext$.MODULE$.global();
        this.timeout = AkkaUtils$.MODULE$.getTimeout(this.configuration());
        this.recoveryMode = RecoveryMode.fromConfig(this.configuration());
        this.numJobManagers = this.getNumberOfJobManagers();
        this.numTaskManagers = this.configuration().getInteger("local.number-taskmanager", 1);
        this.jobManagerActorSystems = None$.MODULE$;
        this.jobManagerActors = None$.MODULE$;
        this.webMonitor = None$.MODULE$;
        this.taskManagerActorSystems = None$.MODULE$;
        this.taskManagerActors = None$.MODULE$;
        this.resourceManagerActorSystems = None$.MODULE$;
        this.resourceManagerActors = None$.MODULE$;
        this.jobManagerLeaderRetrievalService = None$.MODULE$;
        this.isRunning = false;
        this.futureExecutor = Executors.newFixedThreadPool(Hardware.getNumberCPUCores(), new NamedThreadFactory("mini-cluster-future-", "-thread"));
        this.ioExecutor = Executors.newFixedThreadPool(Hardware.getNumberCPUCores(), new NamedThreadFactory("mini-cluster-future-", "-thread-"));
    }
}

