/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.AbstractCloseableHandle;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileStateHandle
extends AbstractCloseableHandle
implements StateObject {
    private static final long serialVersionUID = 350284443258002355L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFileStateHandle.class);
    private final Path filePath;
    private transient FileSystem fs;

    protected AbstractFileStateHandle(Path filePath) {
        this.filePath = (Path)Preconditions.checkNotNull((Object)filePath);
    }

    public Path getFilePath() {
        return this.filePath;
    }

    @Override
    public void discardState() throws Exception {
        this.getFileSystem().delete(this.filePath, false);
        try {
            FileUtils.deletePathIfEmpty((FileSystem)this.getFileSystem(), (Path)this.filePath.getParent());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected FileSystem getFileSystem() throws IOException {
        if (this.fs == null) {
            this.fs = FileSystem.get((URI)this.filePath.toUri());
        }
        return this.fs;
    }

    protected long getFileSize() throws IOException {
        try {
            return this.getFileSystem().getFileStatus(this.filePath).getLen();
        }
        catch (FileNotFoundException e) {
            LOG.info("Could not determine state size - state will appear as size '0'. If the underlying filesystem is eventually consistency, that is most likely the cause.");
        }
        catch (IOException e) {
            LOG.info("Could not determine state size - state will appear as size '0'.", (Throwable)e);
        }
        return 0L;
    }
}

