/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.migration.runtime.state.filesystem;

import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.migration.runtime.state.KvStateSnapshot;
import org.apache.flink.migration.runtime.state.filesystem.AbstractFileStateHandle;
import org.apache.flink.migration.runtime.state.memory.AbstractMigrationRestoreStrategy;
import org.apache.flink.migration.runtime.state.memory.MigrationRestoreSnapshot;
import org.apache.flink.runtime.state.heap.HeapKeyedStateBackend;
import org.apache.flink.runtime.state.heap.StateTable;

@Deprecated
public abstract class AbstractFsStateSnapshot<K, N, SV, S extends State, SD extends StateDescriptor<S, ?>>
extends AbstractFileStateHandle
implements KvStateSnapshot<K, N, S, SD>,
MigrationRestoreSnapshot<K, N, SV> {
    private static final long serialVersionUID = 1L;
    protected final TypeSerializer<K> keySerializer;
    protected final TypeSerializer<N> namespaceSerializer;
    protected final TypeSerializer<SV> stateSerializer;
    protected final SD stateDesc;

    public AbstractFsStateSnapshot(TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, TypeSerializer<SV> stateSerializer, SD stateDesc, Path filePath) {
        super(filePath);
        this.stateDesc = stateDesc;
        this.keySerializer = keySerializer;
        this.stateSerializer = stateSerializer;
        this.namespaceSerializer = namespaceSerializer;
    }

    @Override
    public long getStateSize() throws IOException {
        return this.getFileSize();
    }

    public TypeSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public TypeSerializer<N> getNamespaceSerializer() {
        return this.namespaceSerializer;
    }

    public TypeSerializer<SV> getStateSerializer() {
        return this.stateSerializer;
    }

    public SD getStateDesc() {
        return this.stateDesc;
    }

    @Override
    public StateTable<K, N, SV> deserialize(String stateName, HeapKeyedStateBackend<K> stateBackend) throws IOException {
        FileSystem fs = this.getFilePath().getFileSystem();
        try (FSDataInputStream inStream = fs.open(this.getFilePath());){
            final DataInputViewStreamWrapper inView = new DataInputViewStreamWrapper((InputStream)inStream);
            AbstractMigrationRestoreStrategy restoreStrategy = new AbstractMigrationRestoreStrategy<K, N, SV>(this.keySerializer, this.namespaceSerializer, this.stateSerializer){

                @Override
                protected DataInputView openDataInputView() throws IOException {
                    return inView;
                }
            };
            StateTable stateTable = restoreStrategy.deserialize(stateName, stateBackend);
            return stateTable;
        }
    }
}

