/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Arrays;
import org.apache.flink.runtime.state.CompositeStateHandle;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.StateUtil;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorSubtaskState
implements CompositeStateHandle {
    private static final Logger LOG = LoggerFactory.getLogger(OperatorSubtaskState.class);
    private static final long serialVersionUID = -2394696997971923995L;
    @Deprecated
    private final StreamStateHandle legacyOperatorState;
    private final OperatorStateHandle managedOperatorState;
    private final OperatorStateHandle rawOperatorState;
    private final KeyedStateHandle managedKeyedState;
    private final KeyedStateHandle rawKeyedState;
    private final long stateSize;

    public OperatorSubtaskState(StreamStateHandle legacyOperatorState, OperatorStateHandle managedOperatorState, OperatorStateHandle rawOperatorState, KeyedStateHandle managedKeyedState, KeyedStateHandle rawKeyedState) {
        this.legacyOperatorState = legacyOperatorState;
        this.managedOperatorState = managedOperatorState;
        this.rawOperatorState = rawOperatorState;
        this.managedKeyedState = managedKeyedState;
        this.rawKeyedState = rawKeyedState;
        try {
            long calculateStateSize = OperatorSubtaskState.getSizeNullSafe(legacyOperatorState);
            calculateStateSize += OperatorSubtaskState.getSizeNullSafe(managedOperatorState);
            calculateStateSize += OperatorSubtaskState.getSizeNullSafe(rawOperatorState);
            calculateStateSize += OperatorSubtaskState.getSizeNullSafe(managedKeyedState);
            this.stateSize = calculateStateSize += OperatorSubtaskState.getSizeNullSafe(rawKeyedState);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get state size.", e);
        }
    }

    private static long getSizeNullSafe(StateObject stateObject) throws Exception {
        return stateObject != null ? stateObject.getStateSize() : 0L;
    }

    @Deprecated
    public StreamStateHandle getLegacyOperatorState() {
        return this.legacyOperatorState;
    }

    public OperatorStateHandle getManagedOperatorState() {
        return this.managedOperatorState;
    }

    public OperatorStateHandle getRawOperatorState() {
        return this.rawOperatorState;
    }

    public KeyedStateHandle getManagedKeyedState() {
        return this.managedKeyedState;
    }

    public KeyedStateHandle getRawKeyedState() {
        return this.rawKeyedState;
    }

    @Override
    public void discardState() {
        try {
            StateUtil.bestEffortDiscardAllStateObjects(Arrays.asList(this.legacyOperatorState, this.managedOperatorState, this.rawOperatorState, this.managedKeyedState, this.rawKeyedState));
        }
        catch (Exception e) {
            LOG.warn("Error while discarding operator states.", (Throwable)e);
        }
    }

    @Override
    public void registerSharedStates(SharedStateRegistry sharedStateRegistry) {
        if (this.managedKeyedState != null) {
            this.managedKeyedState.registerSharedStates(sharedStateRegistry);
        }
        if (this.rawKeyedState != null) {
            this.rawKeyedState.registerSharedStates(sharedStateRegistry);
        }
    }

    @Override
    public long getStateSize() {
        return this.stateSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatorSubtaskState that = (OperatorSubtaskState)o;
        if (this.stateSize != that.stateSize) {
            return false;
        }
        if (this.legacyOperatorState != null ? !this.legacyOperatorState.equals(that.legacyOperatorState) : that.legacyOperatorState != null) {
            return false;
        }
        if (this.managedOperatorState != null ? !this.managedOperatorState.equals(that.managedOperatorState) : that.managedOperatorState != null) {
            return false;
        }
        if (this.rawOperatorState != null ? !this.rawOperatorState.equals(that.rawOperatorState) : that.rawOperatorState != null) {
            return false;
        }
        if (this.managedKeyedState != null ? !this.managedKeyedState.equals(that.managedKeyedState) : that.managedKeyedState != null) {
            return false;
        }
        return this.rawKeyedState != null ? this.rawKeyedState.equals(that.rawKeyedState) : that.rawKeyedState == null;
    }

    public int hashCode() {
        int result = this.legacyOperatorState != null ? this.legacyOperatorState.hashCode() : 0;
        result = 31 * result + (this.managedOperatorState != null ? this.managedOperatorState.hashCode() : 0);
        result = 31 * result + (this.rawOperatorState != null ? this.rawOperatorState.hashCode() : 0);
        result = 31 * result + (this.managedKeyedState != null ? this.managedKeyedState.hashCode() : 0);
        result = 31 * result + (this.rawKeyedState != null ? this.rawKeyedState.hashCode() : 0);
        result = 31 * result + (int)(this.stateSize ^ this.stateSize >>> 32);
        return result;
    }

    public String toString() {
        return "SubtaskState{legacyState=" + this.legacyOperatorState + ", operatorStateFromBackend=" + this.managedOperatorState + ", operatorStateFromStream=" + this.rawOperatorState + ", keyedStateFromBackend=" + this.managedKeyedState + ", keyedStateFromStream=" + this.rawKeyedState + ", stateSize=" + this.stateSize + '}';
    }
}

