/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.savepoint;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.runtime.checkpoint.savepoint.Savepoint;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointSerializer;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointSerializers;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.filesystem.FileStateHandle;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SavepointStore {
    private static final Logger LOG = LoggerFactory.getLogger(SavepointStore.class);
    public static final int MAGIC_NUMBER = 1231054637;
    private static final String SAVEPOINT_METADATA_FILE = "_metadata";
    static final String EXTERNALIZED_CHECKPOINT_METADATA_FILE = "checkpoint_metadata-";

    public static String createSavepointDirectory(@Nonnull String baseDirectory, @Nullable JobID jobId) throws IOException {
        Path basePath = new Path(baseDirectory);
        FileSystem fs = basePath.getFileSystem();
        String prefix = jobId == null ? "savepoint-" : String.format("savepoint-%s-", jobId.toString().substring(0, 6));
        Exception latestException = null;
        for (int attempt = 0; attempt < 10; ++attempt) {
            Path path = new Path(basePath, FileUtils.getRandomFilename((String)prefix));
            try {
                if (!fs.mkdirs(path)) continue;
                return path.toString();
            }
            catch (Exception e) {
                latestException = e;
            }
        }
        throw new IOException("Failed to create savepoint directory at " + baseDirectory, latestException);
    }

    public static void deleteSavepointDirectory(@Nonnull String savepointDirectory) throws IOException {
        Path path = new Path(savepointDirectory);
        FileSystem fs = FileSystem.get((URI)path.toUri());
        fs.delete(path, true);
    }

    public static <T extends Savepoint> String storeSavepoint(String directory, T savepoint) throws IOException {
        FileStateHandle metadataFileHandle = SavepointStore.storeSavepointToHandle(directory, SAVEPOINT_METADATA_FILE, savepoint);
        return metadataFileHandle.getFilePath().getParent().toString();
    }

    public static <T extends Savepoint> FileStateHandle storeSavepointToHandle(String directory, T savepoint) throws IOException {
        return SavepointStore.storeSavepointToHandle(directory, SAVEPOINT_METADATA_FILE, savepoint);
    }

    public static <T extends Savepoint> FileStateHandle storeExternalizedCheckpointToHandle(String directory, T savepoint) throws IOException {
        String fileName = FileUtils.getRandomFilename((String)EXTERNALIZED_CHECKPOINT_METADATA_FILE);
        return SavepointStore.storeSavepointToHandle(directory, fileName, savepoint);
    }

    /*
     * Exception decompiling
     */
    static <T extends Savepoint> FileStateHandle storeSavepointToHandle(String directory, String filename, T savepoint) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Savepoint loadSavepoint(String savepointFileOrDirectory, ClassLoader classLoader) throws IOException {
        return (Savepoint)SavepointStore.loadSavepointWithHandle((String)savepointFileOrDirectory, (ClassLoader)classLoader).f0;
    }

    public static Tuple2<Savepoint, StreamStateHandle> loadSavepointWithHandle(String savepointFileOrDirectory, ClassLoader classLoader) throws IOException {
        Object savepoint;
        FileSystem fs;
        Path path;
        block18: {
            Preconditions.checkNotNull((Object)savepointFileOrDirectory, (String)"savepointFileOrDirectory");
            Preconditions.checkNotNull((Object)classLoader, (String)"classLoader");
            path = new Path(savepointFileOrDirectory);
            LOG.info("Loading savepoint from {}", (Object)path);
            fs = FileSystem.get((URI)path.toUri());
            FileStatus status = fs.getFileStatus(path);
            if (status.isDir()) {
                Path candidatePath = new Path(path, SAVEPOINT_METADATA_FILE);
                if (fs.exists(candidatePath)) {
                    path = candidatePath;
                    LOG.info("Using savepoint file in {}", (Object)path);
                } else {
                    throw new IOException("Cannot find meta data file in directory " + path + ". Please try to load the savepoint directly from the meta data file instead of the directory.");
                }
            }
            try (DataInputViewStreamWrapper dis = new DataInputViewStreamWrapper((InputStream)fs.open(path));){
                int magicNumber = dis.readInt();
                if (magicNumber == 1231054637) {
                    int version = dis.readInt();
                    SavepointSerializer<?> serializer = SavepointSerializers.getSerializer(version);
                    savepoint = serializer.deserialize((DataInputStream)dis, classLoader);
                    break block18;
                }
                throw new RuntimeException("Unexpected magic number. This can have multiple reasons: (1) You are trying to load a Flink 1.0 savepoint, which is not supported by this version of Flink. (2) The file you were pointing to is not a savepoint at all. (3) The savepoint file has been corrupted.");
            }
        }
        long size = 0L;
        try {
            size = fs.getFileStatus(path).getLen();
        }
        catch (Exception magicNumber) {
            // empty catch block
        }
        FileStateHandle metadataHandle = new FileStateHandle(path, size);
        return new Tuple2(savepoint, (Object)metadataHandle);
    }

    public static void removeSavepointFile(String path) throws IOException {
        block4: {
            Preconditions.checkNotNull((Object)path, (String)"Path");
            try {
                LOG.info("Removing savepoint: {}.", (Object)path);
                Path filePath = new Path(path);
                FileSystem fs = FileSystem.get((URI)filePath.toUri());
                if (fs.exists(filePath)) {
                    if (!fs.delete(filePath, true)) {
                        throw new IOException("Failed to delete " + filePath + ".");
                    }
                    break block4;
                }
                throw new IllegalArgumentException("Invalid path '" + filePath.toUri() + "'.");
            }
            catch (Throwable t) {
                throw new IOException("Failed to dispose savepoint " + path + ".", t);
            }
        }
    }
}

