/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.io.Serializable;
import java.util.Collection;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.deployment.InputGateDeploymentDescriptor;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.JobInformation;
import org.apache.flink.runtime.executiongraph.TaskInformation;
import org.apache.flink.runtime.state.TaskStateHandles;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;

public final class TaskDeploymentDescriptor
implements Serializable {
    private static final long serialVersionUID = -3233562176034358530L;
    private final SerializedValue<JobInformation> serializedJobInformation;
    private final SerializedValue<TaskInformation> serializedTaskInformation;
    private final ExecutionAttemptID executionId;
    private final AllocationID allocationId;
    private final int subtaskIndex;
    private final int attemptNumber;
    private final Collection<ResultPartitionDeploymentDescriptor> producedPartitions;
    private final Collection<InputGateDeploymentDescriptor> inputGates;
    private final int targetSlotNumber;
    private final TaskStateHandles taskStateHandles;

    public TaskDeploymentDescriptor(SerializedValue<JobInformation> serializedJobInformation, SerializedValue<TaskInformation> serializedTaskInformation, ExecutionAttemptID executionAttemptId, AllocationID allocationId, int subtaskIndex, int attemptNumber, int targetSlotNumber, TaskStateHandles taskStateHandles, Collection<ResultPartitionDeploymentDescriptor> resultPartitionDeploymentDescriptors, Collection<InputGateDeploymentDescriptor> inputGateDeploymentDescriptors) {
        this.serializedJobInformation = (SerializedValue)Preconditions.checkNotNull(serializedJobInformation);
        this.serializedTaskInformation = (SerializedValue)Preconditions.checkNotNull(serializedTaskInformation);
        this.executionId = (ExecutionAttemptID)((Object)Preconditions.checkNotNull((Object)((Object)executionAttemptId)));
        this.allocationId = (AllocationID)((Object)Preconditions.checkNotNull((Object)((Object)allocationId)));
        Preconditions.checkArgument((0 <= subtaskIndex ? 1 : 0) != 0, (Object)"The subtask index must be positive.");
        this.subtaskIndex = subtaskIndex;
        Preconditions.checkArgument((0 <= attemptNumber ? 1 : 0) != 0, (Object)"The attempt number must be positive.");
        this.attemptNumber = attemptNumber;
        Preconditions.checkArgument((0 <= targetSlotNumber ? 1 : 0) != 0, (Object)"The target slot number must be positive.");
        this.targetSlotNumber = targetSlotNumber;
        this.taskStateHandles = taskStateHandles;
        this.producedPartitions = (Collection)Preconditions.checkNotNull(resultPartitionDeploymentDescriptors);
        this.inputGates = (Collection)Preconditions.checkNotNull(inputGateDeploymentDescriptors);
    }

    public SerializedValue<JobInformation> getSerializedJobInformation() {
        return this.serializedJobInformation;
    }

    public SerializedValue<TaskInformation> getSerializedTaskInformation() {
        return this.serializedTaskInformation;
    }

    public ExecutionAttemptID getExecutionAttemptId() {
        return this.executionId;
    }

    public int getSubtaskIndex() {
        return this.subtaskIndex;
    }

    public int getAttemptNumber() {
        return this.attemptNumber;
    }

    public int getTargetSlotNumber() {
        return this.targetSlotNumber;
    }

    public Collection<ResultPartitionDeploymentDescriptor> getProducedPartitions() {
        return this.producedPartitions;
    }

    public Collection<InputGateDeploymentDescriptor> getInputGates() {
        return this.inputGates;
    }

    public TaskStateHandles getTaskStateHandles() {
        return this.taskStateHandles;
    }

    public AllocationID getAllocationId() {
        return this.allocationId;
    }

    public String toString() {
        return String.format("TaskDeploymentDescriptor [execution id: %s, attempt: %d, produced partitions: %s, input gates: %s]", new Object[]{this.executionId, this.attemptNumber, TaskDeploymentDescriptor.collectionToString(this.producedPartitions), TaskDeploymentDescriptor.collectionToString(this.inputGates)});
    }

    private static String collectionToString(Iterable<?> collection) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("[");
        for (Object elem : collection) {
            strBuilder.append(elem);
        }
        strBuilder.append("]");
        return strBuilder.toString();
    }
}

