/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.runtime.io.disk.iomanager.AsynchronousFileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.WriteRequest;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.util.Preconditions;

final class BufferWriteRequest
implements WriteRequest {
    private final AsynchronousFileIOChannel<Buffer, WriteRequest> channel;
    private final Buffer buffer;

    protected BufferWriteRequest(AsynchronousFileIOChannel<Buffer, WriteRequest> targetChannel, Buffer buffer) {
        this.channel = (AsynchronousFileIOChannel)Preconditions.checkNotNull(targetChannel);
        this.buffer = (Buffer)Preconditions.checkNotNull((Object)buffer);
    }

    @Override
    public void write() throws IOException {
        ByteBuffer header = ByteBuffer.allocateDirect(8);
        header.putInt(this.buffer.isBuffer() ? 1 : 0);
        header.putInt(this.buffer.getSize());
        header.flip();
        this.channel.fileChannel.write(header);
        this.channel.fileChannel.write(this.buffer.getNioBuffer());
    }

    @Override
    public void requestDone(IOException error) {
        this.channel.handleProcessedBuffer(this.buffer, error);
    }
}

