/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.util.internal.PlatformDependent;
import java.lang.reflect.Field;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public class NettyBufferPool
implements ByteBufAllocator {
    private static final Logger LOG = LoggerFactory.getLogger(NettyBufferPool.class);
    private final PooledByteBufAllocator alloc;
    private final Object[] directArenas;
    private final int numberOfArenas;
    private final int chunkSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NettyBufferPool(int numberOfArenas) {
        Preconditions.checkArgument((numberOfArenas >= 1 ? 1 : 0) != 0, (Object)"Number of arenas");
        this.numberOfArenas = numberOfArenas;
        if (!PlatformDependent.hasUnsafe()) {
            LOG.warn("Using direct buffers, but sun.misc.Unsafe not available.");
        }
        boolean preferDirect = true;
        int pageSize = 8192;
        int maxOrder = 11;
        this.chunkSize = pageSize << maxOrder;
        int numDirectArenas = numberOfArenas;
        int numHeapArenas = 0;
        this.alloc = new PooledByteBufAllocator(preferDirect, numHeapArenas, numDirectArenas, pageSize, maxOrder);
        Object[] allocDirectArenas = null;
        try {
            Field directArenasField = this.alloc.getClass().getDeclaredField("directArenas");
            directArenasField.setAccessible(true);
            allocDirectArenas = (Object[])directArenasField.get(this.alloc);
        }
        catch (Exception ignored) {
            LOG.warn("Memory statistics not available");
        }
        finally {
            this.directArenas = allocDirectArenas;
        }
    }

    int getNumberOfArenas() {
        return this.numberOfArenas;
    }

    int getChunkSize() {
        return this.chunkSize;
    }

    public Option<Long> getNumberOfAllocatedBytes() throws NoSuchFieldException, IllegalAccessException {
        if (this.directArenas != null) {
            long numChunks = 0L;
            for (Object arena : this.directArenas) {
                numChunks += this.getNumberOfAllocatedChunks(arena, "qInit");
                numChunks += this.getNumberOfAllocatedChunks(arena, "q000");
                numChunks += this.getNumberOfAllocatedChunks(arena, "q025");
                numChunks += this.getNumberOfAllocatedChunks(arena, "q050");
                numChunks += this.getNumberOfAllocatedChunks(arena, "q075");
                numChunks += this.getNumberOfAllocatedChunks(arena, "q100");
            }
            long allocatedBytes = numChunks * (long)this.chunkSize;
            return Option.apply((Object)allocatedBytes);
        }
        return Option.empty();
    }

    private long getNumberOfAllocatedChunks(Object arena, String chunkListFieldName) throws NoSuchFieldException, IllegalAccessException {
        Field chunkListField = arena.getClass().getSuperclass().getDeclaredField(chunkListFieldName);
        chunkListField.setAccessible(true);
        Object chunkList = chunkListField.get(arena);
        Field headChunkField = chunkList.getClass().getDeclaredField("head");
        headChunkField.setAccessible(true);
        Object headChunk = headChunkField.get(chunkList);
        if (headChunk == null) {
            return 0L;
        }
        int numChunks = 0;
        Object current = headChunk;
        while (current != null) {
            Field nextChunkField = headChunk.getClass().getDeclaredField("next");
            nextChunkField.setAccessible(true);
            current = nextChunkField.get(current);
            ++numChunks;
        }
        return numChunks;
    }

    public ByteBuf buffer() {
        return this.alloc.buffer();
    }

    public ByteBuf buffer(int initialCapacity) {
        return this.alloc.buffer(initialCapacity);
    }

    public ByteBuf buffer(int initialCapacity, int maxCapacity) {
        return this.alloc.buffer(initialCapacity, maxCapacity);
    }

    public ByteBuf ioBuffer() {
        return this.alloc.ioBuffer();
    }

    public ByteBuf ioBuffer(int initialCapacity) {
        return this.alloc.ioBuffer(initialCapacity);
    }

    public ByteBuf ioBuffer(int initialCapacity, int maxCapacity) {
        return this.alloc.ioBuffer(initialCapacity, maxCapacity);
    }

    public ByteBuf heapBuffer() {
        throw new UnsupportedOperationException("Heap buffer");
    }

    public ByteBuf heapBuffer(int initialCapacity) {
        throw new UnsupportedOperationException("Heap buffer");
    }

    public ByteBuf heapBuffer(int initialCapacity, int maxCapacity) {
        throw new UnsupportedOperationException("Heap buffer");
    }

    public ByteBuf directBuffer() {
        return this.alloc.directBuffer();
    }

    public ByteBuf directBuffer(int initialCapacity) {
        return this.alloc.directBuffer(initialCapacity);
    }

    public ByteBuf directBuffer(int initialCapacity, int maxCapacity) {
        return this.alloc.directBuffer(initialCapacity, maxCapacity);
    }

    public CompositeByteBuf compositeBuffer() {
        return this.alloc.compositeBuffer();
    }

    public CompositeByteBuf compositeBuffer(int maxNumComponents) {
        return this.alloc.compositeBuffer(maxNumComponents);
    }

    public CompositeByteBuf compositeHeapBuffer() {
        throw new UnsupportedOperationException("Heap buffer");
    }

    public CompositeByteBuf compositeHeapBuffer(int maxNumComponents) {
        throw new UnsupportedOperationException("Heap buffer");
    }

    public CompositeByteBuf compositeDirectBuffer() {
        return this.alloc.compositeDirectBuffer();
    }

    public CompositeByteBuf compositeDirectBuffer(int maxNumComponents) {
        return this.alloc.compositeDirectBuffer(maxNumComponents);
    }

    public boolean isDirectBufferPooled() {
        return this.alloc.isDirectBufferPooled();
    }
}

