/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.query.netty.message;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.query.KvStateID;
import org.apache.flink.runtime.query.netty.message.KvStateRequest;
import org.apache.flink.runtime.query.netty.message.KvStateRequestFailure;
import org.apache.flink.runtime.query.netty.message.KvStateRequestResult;
import org.apache.flink.runtime.query.netty.message.KvStateRequestType;
import org.apache.flink.runtime.util.DataInputDeserializer;
import org.apache.flink.runtime.util.DataOutputSerializer;
import org.apache.flink.util.Preconditions;

public final class KvStateRequestSerializer {
    private static final int VERSION = 2040641296;
    private static final int HEADER_LENGTH = 8;

    public static ByteBuf serializeKvStateRequest(ByteBufAllocator alloc, long requestId, KvStateID kvStateId, byte[] serializedKeyAndNamespace) {
        int frameLength = 32 + (4 + serializedKeyAndNamespace.length);
        ByteBuf buf = alloc.ioBuffer(frameLength + 4);
        buf.writeInt(frameLength);
        KvStateRequestSerializer.writeHeader(buf, KvStateRequestType.REQUEST);
        buf.writeLong(requestId);
        buf.writeLong(kvStateId.getLowerPart());
        buf.writeLong(kvStateId.getUpperPart());
        buf.writeInt(serializedKeyAndNamespace.length);
        buf.writeBytes(serializedKeyAndNamespace);
        return buf;
    }

    public static ByteBuf serializeKvStateRequestResult(ByteBufAllocator alloc, long requestId, byte[] serializedResult) {
        Preconditions.checkNotNull((Object)serializedResult, (String)"Serialized result");
        int frameLength = 20 + serializedResult.length;
        ByteBuf buf = alloc.ioBuffer(frameLength);
        buf.writeInt(frameLength);
        KvStateRequestSerializer.writeHeader(buf, KvStateRequestType.REQUEST_RESULT);
        buf.writeLong(requestId);
        buf.writeInt(serializedResult.length);
        buf.writeBytes(serializedResult);
        return buf;
    }

    public static ByteBuf serializeKvStateRequestFailure(ByteBufAllocator alloc, long requestId, Throwable cause) throws IOException {
        ByteBuf buf = alloc.ioBuffer();
        buf.writeInt(0);
        KvStateRequestSerializer.writeHeader(buf, KvStateRequestType.REQUEST_FAILURE);
        buf.writeLong(requestId);
        try (ByteBufOutputStream bbos = new ByteBufOutputStream(buf);
             ObjectOutputStream out = new ObjectOutputStream((OutputStream)bbos);){
            out.writeObject(cause);
        }
        int frameLength = buf.readableBytes() - 4;
        buf.setInt(0, frameLength);
        return buf;
    }

    public static ByteBuf serializeServerFailure(ByteBufAllocator alloc, Throwable cause) throws IOException {
        ByteBuf buf = alloc.ioBuffer();
        buf.writeInt(0);
        KvStateRequestSerializer.writeHeader(buf, KvStateRequestType.SERVER_FAILURE);
        try (ByteBufOutputStream bbos = new ByteBufOutputStream(buf);
             ObjectOutputStream out = new ObjectOutputStream((OutputStream)bbos);){
            out.writeObject(cause);
        }
        int frameLength = buf.readableBytes() - 4;
        buf.setInt(0, frameLength);
        return buf;
    }

    public static KvStateRequestType deserializeHeader(ByteBuf buf) {
        int version = buf.readInt();
        if (version != 2040641296) {
            throw new IllegalArgumentException("Illegal message version " + version + ". Expected: " + 2040641296 + ".");
        }
        int msgType = buf.readInt();
        KvStateRequestType[] values = KvStateRequestType.values();
        if (msgType >= 0 && msgType <= values.length) {
            return values[msgType];
        }
        throw new IllegalArgumentException("Illegal message type with index " + msgType);
    }

    public static KvStateRequest deserializeKvStateRequest(ByteBuf buf) {
        long requestId = buf.readLong();
        KvStateID kvStateId = new KvStateID(buf.readLong(), buf.readLong());
        int length = buf.readInt();
        if (length < 0) {
            throw new IllegalArgumentException("Negative length for serialized key and namespace. This indicates a serialization error.");
        }
        byte[] serializedKeyAndNamespace = new byte[length];
        if (length > 0) {
            buf.readBytes(serializedKeyAndNamespace);
        }
        return new KvStateRequest(requestId, kvStateId, serializedKeyAndNamespace);
    }

    public static KvStateRequestResult deserializeKvStateRequestResult(ByteBuf buf) {
        long requestId = buf.readLong();
        int length = buf.readInt();
        if (length < 0) {
            throw new IllegalArgumentException("Negative length for serialized result. This indicates a serialization error.");
        }
        byte[] serializedValue = new byte[length];
        if (length > 0) {
            buf.readBytes(serializedValue);
        }
        return new KvStateRequestResult(requestId, serializedValue);
    }

    public static KvStateRequestFailure deserializeKvStateRequestFailure(ByteBuf buf) throws IOException, ClassNotFoundException {
        Throwable cause;
        long requestId = buf.readLong();
        try (ByteBufInputStream bbis = new ByteBufInputStream(buf);
             ObjectInputStream in = new ObjectInputStream((InputStream)bbis);){
            cause = (Throwable)in.readObject();
        }
        return new KvStateRequestFailure(requestId, cause);
    }

    /*
     * Exception decompiling
     */
    public static Throwable deserializeServerFailure(ByteBuf buf) throws IOException, ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <K, N> byte[] serializeKeyAndNamespace(K key, TypeSerializer<K> keySerializer, N namespace, TypeSerializer<N> namespaceSerializer) throws IOException {
        DataOutputSerializer dos = new DataOutputSerializer(32);
        keySerializer.serialize(key, (DataOutputView)dos);
        dos.writeByte(42);
        namespaceSerializer.serialize(namespace, (DataOutputView)dos);
        return dos.getCopyOfBuffer();
    }

    public static <K, N> Tuple2<K, N> deserializeKeyAndNamespace(byte[] serializedKeyAndNamespace, TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer) throws IOException {
        DataInputDeserializer dis = new DataInputDeserializer(serializedKeyAndNamespace, 0, serializedKeyAndNamespace.length);
        try {
            Object key = keySerializer.deserialize((DataInputView)dis);
            byte magicNumber = dis.readByte();
            if (magicNumber != 42) {
                throw new IOException("Unexpected magic number " + magicNumber + ".");
            }
            Object namespace = namespaceSerializer.deserialize((DataInputView)dis);
            if (dis.available() > 0) {
                throw new IOException("Unconsumed bytes in the serialized key and namespace.");
            }
            return new Tuple2(key, namespace);
        }
        catch (IOException e) {
            throw new IOException("Unable to deserialize key and namespace. This indicates a mismatch in the key/namespace serializers used by the KvState instance and this access.", e);
        }
    }

    public static <T> byte[] serializeValue(T value, TypeSerializer<T> serializer) throws IOException {
        if (value != null) {
            DataOutputSerializer dos = new DataOutputSerializer(32);
            serializer.serialize(value, (DataOutputView)dos);
            return dos.getCopyOfBuffer();
        }
        return null;
    }

    public static <T> T deserializeValue(byte[] serializedValue, TypeSerializer<T> serializer) throws IOException {
        if (serializedValue == null) {
            return null;
        }
        DataInputDeserializer deser = new DataInputDeserializer(serializedValue, 0, serializedValue.length);
        Object value = serializer.deserialize((DataInputView)deser);
        if (deser.available() > 0) {
            throw new IOException("Unconsumed bytes in the deserialized value. This indicates a mismatch in the value serializers used by the KvState instance and this access.");
        }
        return (T)value;
    }

    public static <T> List<T> deserializeList(byte[] serializedValue, TypeSerializer<T> serializer) throws IOException {
        if (serializedValue != null) {
            DataInputDeserializer in = new DataInputDeserializer(serializedValue, 0, serializedValue.length);
            try {
                ArrayList<Object> result = new ArrayList<Object>();
                while (in.available() > 0) {
                    result.add(serializer.deserialize((DataInputView)in));
                    if (in.available() <= 0) continue;
                    in.readByte();
                }
                return result;
            }
            catch (IOException e) {
                throw new IOException("Unable to deserialize value. This indicates a mismatch in the value serializers used by the KvState instance and this access.", e);
            }
        }
        return null;
    }

    public static <UK, UV> byte[] serializeMap(Iterable<Map.Entry<UK, UV>> entries, TypeSerializer<UK> keySerializer, TypeSerializer<UV> valueSerializer) throws IOException {
        if (entries != null) {
            DataOutputSerializer dos = new DataOutputSerializer(32);
            for (Map.Entry<UK, UV> entry : entries) {
                keySerializer.serialize(entry.getKey(), (DataOutputView)dos);
                if (entry.getValue() == null) {
                    dos.writeBoolean(true);
                    continue;
                }
                dos.writeBoolean(false);
                valueSerializer.serialize(entry.getValue(), (DataOutputView)dos);
            }
            return dos.getCopyOfBuffer();
        }
        return null;
    }

    public static <UK, UV> Map<UK, UV> deserializeMap(byte[] serializedValue, TypeSerializer<UK> keySerializer, TypeSerializer<UV> valueSerializer) throws IOException {
        if (serializedValue != null) {
            DataInputDeserializer in = new DataInputDeserializer(serializedValue, 0, serializedValue.length);
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            while (in.available() > 0) {
                Object key = keySerializer.deserialize((DataInputView)in);
                boolean isNull = in.readBoolean();
                Object value = isNull ? null : valueSerializer.deserialize((DataInputView)in);
                result.put(key, value);
            }
            return result;
        }
        return null;
    }

    private static void writeHeader(ByteBuf buf, KvStateRequestType requestType) {
        buf.writeInt(2040641296);
        buf.writeInt(requestType.ordinal());
    }
}

