/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.ConfigurationException;
import org.apache.flink.util.Preconditions;
import scala.concurrent.duration.Duration;

public class SlotManagerConfiguration {
    private final Time taskManagerRequestTimeout;
    private final Time slotRequestTimeout;
    private final Time taskManagerTimeout;

    public SlotManagerConfiguration(Time taskManagerRequestTimeout, Time slotRequestTimeout, Time taskManagerTimeout) {
        this.taskManagerRequestTimeout = (Time)Preconditions.checkNotNull((Object)taskManagerRequestTimeout);
        this.slotRequestTimeout = (Time)Preconditions.checkNotNull((Object)slotRequestTimeout);
        this.taskManagerTimeout = (Time)Preconditions.checkNotNull((Object)taskManagerTimeout);
    }

    public Time getTaskManagerRequestTimeout() {
        return this.taskManagerRequestTimeout;
    }

    public Time getSlotRequestTimeout() {
        return this.slotRequestTimeout;
    }

    public Time getTaskManagerTimeout() {
        return this.taskManagerTimeout;
    }

    public static SlotManagerConfiguration fromConfiguration(Configuration configuration) throws ConfigurationException {
        Time timeout;
        ConfigOption timeoutOption = ConfigOptions.key((String)"akka.ask.timeout").defaultValue((Object)ConfigConstants.DEFAULT_AKKA_ASK_TIMEOUT);
        String strTimeout = configuration.getString(timeoutOption);
        try {
            timeout = Time.milliseconds((long)Duration.apply((String)strTimeout).toMillis());
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("Could not parse the resource manager's timeout value " + timeoutOption + '.', (Throwable)e);
        }
        return new SlotManagerConfiguration(timeout, timeout, timeout);
    }
}

