/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.Collection;
import java.util.HashSet;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.resourcemanager.registration.TaskExecutorConnection;
import org.apache.flink.util.Preconditions;

public class TaskManagerRegistration {
    private final TaskExecutorConnection taskManagerConnection;
    private final HashSet<SlotID> slots;
    private long idleSince;

    public TaskManagerRegistration(TaskExecutorConnection taskManagerConnection, Collection<SlotID> slots) {
        this.taskManagerConnection = (TaskExecutorConnection)Preconditions.checkNotNull((Object)taskManagerConnection, (String)"taskManagerConnection");
        Preconditions.checkNotNull(slots, (String)"slots");
        this.slots = new HashSet<SlotID>(slots);
        this.idleSince = Long.MAX_VALUE;
    }

    public TaskExecutorConnection getTaskManagerConnection() {
        return this.taskManagerConnection;
    }

    public InstanceID getInstanceId() {
        return this.taskManagerConnection.getInstanceID();
    }

    public Iterable<SlotID> getSlots() {
        return this.slots;
    }

    public long getIdleSince() {
        return this.idleSince;
    }

    public boolean isIdle() {
        return this.idleSince != Long.MAX_VALUE;
    }

    public void markIdle() {
        this.idleSince = System.currentTimeMillis();
    }

    public void markUsed() {
        this.idleSince = Long.MAX_VALUE;
    }

    public boolean containsSlot(SlotID slotId) {
        return this.slots.contains(slotId);
    }
}

