/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Map;
import java.util.UUID;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.SharedStateRegistryKey;
import org.apache.flink.runtime.state.StateHandleID;
import org.apache.flink.runtime.state.StateUtil;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalKeyedStateHandle
implements KeyedStateHandle {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementalKeyedStateHandle.class);
    private static final long serialVersionUID = -8328808513197388231L;
    private final UUID backendIdentifier;
    private final KeyGroupRange keyGroupRange;
    private final long checkpointId;
    private final Map<StateHandleID, StreamStateHandle> sharedState;
    private final Map<StateHandleID, StreamStateHandle> privateState;
    private final StreamStateHandle metaStateHandle;
    private transient SharedStateRegistry sharedStateRegistry;

    public IncrementalKeyedStateHandle(UUID backendIdentifier, KeyGroupRange keyGroupRange, long checkpointId, Map<StateHandleID, StreamStateHandle> sharedState, Map<StateHandleID, StreamStateHandle> privateState, StreamStateHandle metaStateHandle) {
        this.backendIdentifier = (UUID)Preconditions.checkNotNull((Object)backendIdentifier);
        this.keyGroupRange = (KeyGroupRange)Preconditions.checkNotNull((Object)keyGroupRange);
        this.checkpointId = checkpointId;
        this.sharedState = (Map)Preconditions.checkNotNull(sharedState);
        this.privateState = (Map)Preconditions.checkNotNull(privateState);
        this.metaStateHandle = (StreamStateHandle)Preconditions.checkNotNull((Object)metaStateHandle);
        this.sharedStateRegistry = null;
    }

    @Override
    public KeyGroupRange getKeyGroupRange() {
        return this.keyGroupRange;
    }

    public long getCheckpointId() {
        return this.checkpointId;
    }

    public Map<StateHandleID, StreamStateHandle> getSharedState() {
        return this.sharedState;
    }

    public Map<StateHandleID, StreamStateHandle> getPrivateState() {
        return this.privateState;
    }

    public StreamStateHandle getMetaStateHandle() {
        return this.metaStateHandle;
    }

    public UUID getBackendIdentifier() {
        return this.backendIdentifier;
    }

    @Override
    public KeyedStateHandle getIntersection(KeyGroupRange keyGroupRange) {
        return KeyGroupRange.EMPTY_KEY_GROUP_RANGE.equals(this.keyGroupRange.getIntersection(keyGroupRange)) ? null : this;
    }

    @Override
    public void discardState() throws Exception {
        SharedStateRegistry registry = this.sharedStateRegistry;
        boolean isRegistered = registry != null;
        LOG.trace("Discarding IncrementalKeyedStateHandle (registered = {}) for checkpoint {} from backend with id {}.", new Object[]{isRegistered, this.checkpointId, this.backendIdentifier});
        try {
            this.metaStateHandle.discardState();
        }
        catch (Exception e) {
            LOG.warn("Could not properly discard meta data.", (Throwable)e);
        }
        try {
            StateUtil.bestEffortDiscardAllStateObjects(this.privateState.values());
        }
        catch (Exception e) {
            LOG.warn("Could not properly discard misc file states.", (Throwable)e);
        }
        if (isRegistered) {
            for (StateHandleID stateHandleID : this.sharedState.keySet()) {
                registry.unregisterReference(this.createSharedStateRegistryKeyFromFileName(stateHandleID));
            }
        } else {
            try {
                StateUtil.bestEffortDiscardAllStateObjects(this.sharedState.values());
            }
            catch (Exception e) {
                LOG.warn("Could not properly discard new sst file states.", (Throwable)e);
            }
        }
    }

    @Override
    public long getStateSize() {
        long size = StateUtil.getStateSize(this.metaStateHandle);
        for (StreamStateHandle sharedStateHandle : this.sharedState.values()) {
            size += sharedStateHandle.getStateSize();
        }
        for (StreamStateHandle privateStateHandle : this.privateState.values()) {
            size += privateStateHandle.getStateSize();
        }
        return size;
    }

    @Override
    public void registerSharedStates(SharedStateRegistry stateRegistry) {
        Preconditions.checkState((this.sharedStateRegistry != stateRegistry ? 1 : 0) != 0, (Object)"The state handle has already registered its shared states to the given registry.");
        this.sharedStateRegistry = (SharedStateRegistry)Preconditions.checkNotNull((Object)stateRegistry);
        LOG.trace("Registering IncrementalKeyedStateHandle for checkpoint {} from backend with id {}.", (Object)this.checkpointId, (Object)this.backendIdentifier);
        for (Map.Entry<StateHandleID, StreamStateHandle> sharedStateHandle : this.sharedState.entrySet()) {
            SharedStateRegistryKey registryKey = this.createSharedStateRegistryKeyFromFileName(sharedStateHandle.getKey());
            SharedStateRegistry.Result result = stateRegistry.registerReference(registryKey, sharedStateHandle.getValue());
            sharedStateHandle.setValue(result.getReference());
        }
    }

    @VisibleForTesting
    public SharedStateRegistryKey createSharedStateRegistryKeyFromFileName(StateHandleID shId) {
        return new SharedStateRegistryKey(String.valueOf(this.backendIdentifier) + '-' + this.keyGroupRange, shId);
    }

    @VisibleForTesting
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncrementalKeyedStateHandle that = (IncrementalKeyedStateHandle)o;
        if (this.getCheckpointId() != that.getCheckpointId()) {
            return false;
        }
        if (!this.getBackendIdentifier().equals(that.getBackendIdentifier())) {
            return false;
        }
        if (!this.getKeyGroupRange().equals(that.getKeyGroupRange())) {
            return false;
        }
        if (!this.getSharedState().equals(that.getSharedState())) {
            return false;
        }
        if (!this.getPrivateState().equals(that.getPrivateState())) {
            return false;
        }
        return this.getMetaStateHandle().equals(that.getMetaStateHandle());
    }

    @VisibleForTesting
    public int hashCode() {
        int result = this.getBackendIdentifier().hashCode();
        result = 31 * result + this.getKeyGroupRange().hashCode();
        result = 31 * result + (int)(this.getCheckpointId() ^ this.getCheckpointId() >>> 32);
        result = 31 * result + this.getSharedState().hashCode();
        result = 31 * result + this.getPrivateState().hashCode();
        result = 31 * result + this.getMetaStateHandle().hashCode();
        return result;
    }

    public String toString() {
        return "IncrementalKeyedStateHandle{backendIdentifier=" + this.backendIdentifier + ", keyGroupRange=" + this.keyGroupRange + ", checkpointId=" + this.checkpointId + ", sharedState=" + this.sharedState + ", privateState=" + this.privateState + ", metaStateHandle=" + this.metaStateHandle + ", registered=" + (this.sharedStateRegistry != null) + '}';
    }
}

