/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.IOException;
import java.net.URI;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemKind;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.Preconditions;

public class FileStateHandle
implements StreamStateHandle {
    private static final long serialVersionUID = 350284443258002355L;
    private final Path filePath;
    private final long stateSize;

    public FileStateHandle(Path filePath, long stateSize) {
        Preconditions.checkArgument((stateSize >= -1L ? 1 : 0) != 0);
        this.filePath = (Path)Preconditions.checkNotNull((Object)filePath);
        this.stateSize = stateSize;
    }

    public Path getFilePath() {
        return this.filePath;
    }

    @Override
    public FSDataInputStream openInputStream() throws IOException {
        return this.getFileSystem().open(this.filePath);
    }

    @Override
    public void discardState() throws Exception {
        FileSystem fs = this.getFileSystem();
        fs.delete(this.filePath, false);
        if (fs.getKind() == FileSystemKind.FILE_SYSTEM) {
            try {
                FileUtils.deletePathIfEmpty((FileSystem)fs, (Path)this.filePath.getParent());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public long getStateSize() {
        return this.stateSize;
    }

    private FileSystem getFileSystem() throws IOException {
        return FileSystem.get((URI)this.filePath.toUri());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileStateHandle)) {
            return false;
        }
        FileStateHandle that = (FileStateHandle)o;
        return this.filePath.equals((Object)that.filePath);
    }

    public int hashCode() {
        return this.filePath.hashCode();
    }

    public String toString() {
        return String.format("File State: %s [%d bytes]", this.filePath, this.stateSize);
    }
}

