/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor.rpc;

import java.util.UUID;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.runtime.concurrent.Future;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProvider;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProviderException;
import org.apache.flink.runtime.jobmaster.JobMasterGateway;
import org.apache.flink.runtime.jobmaster.SerializedInputSplit;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

public class RpcInputSplitProvider
implements InputSplitProvider {
    private final UUID jobMasterLeaderId;
    private final JobMasterGateway jobMasterGateway;
    private final JobID jobID;
    private final JobVertexID jobVertexID;
    private final ExecutionAttemptID executionAttemptID;
    private final Time timeout;

    public RpcInputSplitProvider(UUID jobMasterLeaderId, JobMasterGateway jobMasterGateway, JobID jobID, JobVertexID jobVertexID, ExecutionAttemptID executionAttemptID, Time timeout) {
        this.jobMasterLeaderId = (UUID)Preconditions.checkNotNull((Object)jobMasterLeaderId);
        this.jobMasterGateway = (JobMasterGateway)Preconditions.checkNotNull((Object)jobMasterGateway);
        this.jobID = (JobID)Preconditions.checkNotNull((Object)jobID);
        this.jobVertexID = (JobVertexID)((Object)Preconditions.checkNotNull((Object)((Object)jobVertexID)));
        this.executionAttemptID = (ExecutionAttemptID)((Object)Preconditions.checkNotNull((Object)((Object)executionAttemptID)));
        this.timeout = (Time)Preconditions.checkNotNull((Object)timeout);
    }

    @Override
    public InputSplit getNextInputSplit(ClassLoader userCodeClassLoader) throws InputSplitProviderException {
        Preconditions.checkNotNull((Object)userCodeClassLoader);
        Future<SerializedInputSplit> futureInputSplit = this.jobMasterGateway.requestNextInputSplit(this.jobMasterLeaderId, this.jobVertexID, this.executionAttemptID);
        try {
            SerializedInputSplit serializedInputSplit = futureInputSplit.get(this.timeout.getSize(), this.timeout.getUnit());
            if (serializedInputSplit.isEmpty()) {
                return null;
            }
            return (InputSplit)InstantiationUtil.deserializeObject((byte[])serializedInputSplit.getInputSplitData(), (ClassLoader)userCodeClassLoader);
        }
        catch (Exception e) {
            throw new InputSplitProviderException("Requesting the next input split failed.", e);
        }
    }
}

