/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor;

import akka.actor.ActorSystem;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.blob.BlobView;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.messages.webmonitor.JobDetails;
import org.apache.flink.runtime.webmonitor.WebMonitor;
import org.apache.flink.runtime.webmonitor.history.JsonArchivist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebMonitorUtils {
    private static final Logger LOG = LoggerFactory.getLogger(WebMonitorUtils.class);

    public static WebMonitor startWebRuntimeMonitor(Configuration config, HighAvailabilityServices highAvailabilityServices, ActorSystem actorSystem) {
        try {
            String classname = "org.apache.flink.runtime.webmonitor.WebRuntimeMonitor";
            Class<WebMonitor> clazz = Class.forName(classname).asSubclass(WebMonitor.class);
            Constructor<WebMonitor> constructor = clazz.getConstructor(Configuration.class, LeaderRetrievalService.class, BlobView.class, ActorSystem.class);
            return constructor.newInstance(config, highAvailabilityServices.getJobManagerLeaderRetriever(HighAvailabilityServices.DEFAULT_JOB_ID), highAvailabilityServices.createBlobStore(), actorSystem);
        }
        catch (ClassNotFoundException e) {
            LOG.error("Could not load web runtime monitor. Probably reason: flink-runtime-web is not in the classpath");
            LOG.debug("Caught exception", (Throwable)e);
            return null;
        }
        catch (InvocationTargetException e) {
            LOG.error("WebServer could not be created", e.getTargetException());
            return null;
        }
        catch (Throwable t) {
            LOG.error("Failed to instantiate web runtime monitor.", t);
            return null;
        }
    }

    public static JsonArchivist[] getJsonArchivists() {
        try {
            String classname = "org.apache.flink.runtime.webmonitor.WebRuntimeMonitor";
            Class<WebMonitor> clazz = Class.forName(classname).asSubclass(WebMonitor.class);
            Method method = clazz.getMethod("getJsonArchivists", new Class[0]);
            JsonArchivist[] result = (JsonArchivist[])method.invoke(null, new Object[0]);
            return result;
        }
        catch (ClassNotFoundException e) {
            LOG.error("Could not load web runtime monitor. Probably reason: flink-runtime-web is not in the classpath");
            LOG.debug("Caught exception", (Throwable)e);
            return new JsonArchivist[0];
        }
        catch (Throwable t) {
            LOG.error("Failed to retrieve archivers from web runtime monitor.", t);
            return new JsonArchivist[0];
        }
    }

    public static Map<String, String> fromKeyValueJsonArray(String jsonString) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            ObjectMapper m = new ObjectMapper();
            ArrayNode array = (ArrayNode)m.readTree(jsonString);
            Iterator elements = array.elements();
            while (elements.hasNext()) {
                JsonNode node = (JsonNode)elements.next();
                String key = node.get("key").asText();
                String value = node.get("value").asText();
                map.put(key, value);
            }
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static JobDetails createDetailsForJob(AccessExecutionGraph job) {
        JobStatus status = job.getState();
        long started = job.getStatusTimestamp(JobStatus.CREATED);
        long finished = status.isGloballyTerminalState() ? job.getStatusTimestamp(status) : -1L;
        int[] countsPerStatus = new int[ExecutionState.values().length];
        long lastChanged = 0L;
        int numTotalTasks = 0;
        for (AccessExecutionJobVertex accessExecutionJobVertex : job.getVerticesTopologically()) {
            AccessExecutionVertex[] vertices = accessExecutionJobVertex.getTaskVertices();
            numTotalTasks += vertices.length;
            for (AccessExecutionVertex vertex : vertices) {
                ExecutionState state = vertex.getExecutionState();
                int n = state.ordinal();
                countsPerStatus[n] = countsPerStatus[n] + 1;
                lastChanged = Math.max(lastChanged, vertex.getStateTimestamp(state));
            }
        }
        lastChanged = Math.max(lastChanged, finished);
        return new JobDetails(job.getJobID(), job.getJobName(), started, finished, status, lastChanged, countsPerStatus, numTotalTasks);
    }

    public static Path validateAndNormalizeUri(URI archiveDirUri) {
        String scheme = archiveDirUri.getScheme();
        String path = archiveDirUri.getPath();
        if (scheme == null) {
            throw new IllegalArgumentException("The scheme (hdfs://, file://, etc) is null. Please specify the file system scheme explicitly in the URI.");
        }
        if (path == null) {
            throw new IllegalArgumentException("The path to store the job archive data in is null. Please specify a directory path for the archiving the job data.");
        }
        return new Path(archiveDirUri);
    }

    private WebMonitorUtils() {
        throw new RuntimeException();
    }

    public static class LogFileLocation {
        public final File logFile;
        public final File stdOutFile;

        private LogFileLocation(File logFile, File stdOutFile) {
            this.logFile = logFile;
            this.stdOutFile = stdOutFile;
        }

        public static LogFileLocation find(Configuration config) {
            String logEnv = "log.file";
            String logFilePath = System.getProperty("log.file");
            if (logFilePath == null) {
                LOG.warn("Log file environment variable '{}' is not set.", (Object)"log.file");
                logFilePath = config.getString("jobmanager.web.log.path", null);
            }
            if (logFilePath == null || logFilePath.length() < 4) {
                LOG.warn("JobManager log files are unavailable in the web dashboard. Log file location not found in environment variable '{}' or configuration key '{}'.", (Object)"log.file", (Object)"jobmanager.web.log.path");
                return new LogFileLocation(null, null);
            }
            String outFilePath = logFilePath.substring(0, logFilePath.length() - 3).concat("out");
            LOG.info("Determined location of JobManager log file: {}", (Object)logFilePath);
            LOG.info("Determined location of JobManager stdout file: {}", (Object)outFilePath);
            return new LogFileLocation(LogFileLocation.resolveFileLocation(logFilePath), LogFileLocation.resolveFileLocation(outFilePath));
        }

        private static File resolveFileLocation(String logFilePath) {
            File logFile = new File(logFilePath);
            return logFile.exists() && logFile.canRead() ? logFile : null;
        }
    }
}

