/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.org.apache.curator.shaded.com.google.common.collect;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.flink.shaded.org.apache.curator.shaded.com.google.common.annotations.GwtCompatible;
import org.apache.flink.shaded.org.apache.curator.shaded.com.google.common.collect.AbstractMapEntry;
import org.apache.flink.shaded.org.apache.curator.shaded.com.google.common.collect.ForwardingMap;
import org.apache.flink.shaded.org.apache.curator.shaded.com.google.common.collect.Maps;
import org.apache.flink.shaded.org.apache.curator.shaded.com.google.common.collect.TransformedIterator;

@GwtCompatible
final class WellBehavedMap<K, V>
extends ForwardingMap<K, V> {
    private final Map<K, V> delegate;
    private Set<Map.Entry<K, V>> entrySet;

    private WellBehavedMap(Map<K, V> delegate) {
        this.delegate = delegate;
    }

    static <K, V> WellBehavedMap<K, V> wrap(Map<K, V> delegate) {
        return new WellBehavedMap<K, V>(delegate);
    }

    @Override
    protected Map<K, V> delegate() {
        return this.delegate;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> es = this.entrySet;
        if (es != null) {
            return es;
        }
        this.entrySet = new EntrySet();
        return this.entrySet;
    }

    private final class EntrySet
    extends Maps.EntrySet<K, V> {
        private EntrySet() {
        }

        @Override
        Map<K, V> map() {
            return WellBehavedMap.this;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new TransformedIterator<K, Map.Entry<K, V>>(WellBehavedMap.this.keySet().iterator()){

                @Override
                Map.Entry<K, V> transform(final K key) {
                    return new AbstractMapEntry<K, V>(){

                        @Override
                        public K getKey() {
                            return key;
                        }

                        @Override
                        public V getValue() {
                            return WellBehavedMap.this.get(key);
                        }

                        @Override
                        public V setValue(V value) {
                            return WellBehavedMap.this.put(key, value);
                        }
                    };
                }
            };
        }
    }
}

