/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.ClusterOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.ResourceManagerOptions;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.util.ConfigurationException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlotManagerConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SlotManagerConfiguration.class);
    private final Time taskManagerRequestTimeout;
    private final Time slotRequestTimeout;
    private final Time taskManagerTimeout;
    private final boolean waitResultConsumedBeforeRelease;
    private final boolean evenlySpreadOutSlots;

    public SlotManagerConfiguration(Time taskManagerRequestTimeout, Time slotRequestTimeout, Time taskManagerTimeout, boolean waitResultConsumedBeforeRelease, boolean evenlySpreadOutSlots) {
        this.taskManagerRequestTimeout = (Time)Preconditions.checkNotNull((Object)taskManagerRequestTimeout);
        this.slotRequestTimeout = (Time)Preconditions.checkNotNull((Object)slotRequestTimeout);
        this.taskManagerTimeout = (Time)Preconditions.checkNotNull((Object)taskManagerTimeout);
        this.waitResultConsumedBeforeRelease = waitResultConsumedBeforeRelease;
        this.evenlySpreadOutSlots = evenlySpreadOutSlots;
    }

    public Time getTaskManagerRequestTimeout() {
        return this.taskManagerRequestTimeout;
    }

    public Time getSlotRequestTimeout() {
        return this.slotRequestTimeout;
    }

    public Time getTaskManagerTimeout() {
        return this.taskManagerTimeout;
    }

    public boolean isWaitResultConsumedBeforeRelease() {
        return this.waitResultConsumedBeforeRelease;
    }

    public boolean evenlySpreadOutSlots() {
        return this.evenlySpreadOutSlots;
    }

    public static SlotManagerConfiguration fromConfiguration(Configuration configuration) throws ConfigurationException {
        Time rpcTimeout;
        try {
            rpcTimeout = AkkaUtils.getTimeoutAsTime(configuration);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException("Could not parse the resource manager's timeout value " + AkkaOptions.ASK_TIMEOUT + '.', (Throwable)e);
        }
        Time slotRequestTimeout = SlotManagerConfiguration.getSlotRequestTimeout(configuration);
        Time taskManagerTimeout = Time.milliseconds((long)configuration.getLong(ResourceManagerOptions.TASK_MANAGER_TIMEOUT));
        boolean waitResultConsumedBeforeRelease = configuration.getBoolean(ResourceManagerOptions.TASK_MANAGER_RELEASE_WHEN_RESULT_CONSUMED);
        boolean evenlySpreadOutSlots = configuration.getBoolean(ClusterOptions.EVENLY_SPREAD_OUT_SLOTS_STRATEGY);
        return new SlotManagerConfiguration(rpcTimeout, slotRequestTimeout, taskManagerTimeout, waitResultConsumedBeforeRelease, evenlySpreadOutSlots);
    }

    private static Time getSlotRequestTimeout(Configuration configuration) {
        long slotRequestTimeoutMs;
        if (configuration.contains(ResourceManagerOptions.SLOT_REQUEST_TIMEOUT)) {
            LOGGER.warn("Config key {} is deprecated; use {} instead.", (Object)ResourceManagerOptions.SLOT_REQUEST_TIMEOUT, (Object)JobManagerOptions.SLOT_REQUEST_TIMEOUT);
            slotRequestTimeoutMs = configuration.getLong(ResourceManagerOptions.SLOT_REQUEST_TIMEOUT);
        } else {
            slotRequestTimeoutMs = configuration.getLong(JobManagerOptions.SLOT_REQUEST_TIMEOUT);
        }
        return Time.milliseconds((long)slotRequestTimeoutMs);
    }
}

