/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessSpec;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessSpecBuilder;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.runtime.util.config.memory.CommonProcessMemorySpec;
import org.apache.flink.runtime.util.config.memory.JvmMetaspaceAndOverhead;
import org.apache.flink.runtime.util.config.memory.JvmMetaspaceAndOverheadOptions;
import org.apache.flink.runtime.util.config.memory.LegacyMemoryOptions;
import org.apache.flink.runtime.util.config.memory.MemoryBackwardsCompatibilityUtils;
import org.apache.flink.runtime.util.config.memory.ProcessMemoryOptions;
import org.apache.flink.runtime.util.config.memory.ProcessMemoryUtils;
import org.apache.flink.runtime.util.config.memory.taskmanager.TaskExecutorFlinkMemory;
import org.apache.flink.runtime.util.config.memory.taskmanager.TaskExecutorFlinkMemoryUtils;

public class TaskExecutorProcessUtils {
    static final ProcessMemoryOptions TM_PROCESS_MEMORY_OPTIONS = new ProcessMemoryOptions(Arrays.asList(TaskManagerOptions.TASK_HEAP_MEMORY, TaskManagerOptions.MANAGED_MEMORY_SIZE), (ConfigOption<MemorySize>)TaskManagerOptions.TOTAL_FLINK_MEMORY, (ConfigOption<MemorySize>)TaskManagerOptions.TOTAL_PROCESS_MEMORY, new JvmMetaspaceAndOverheadOptions((ConfigOption<MemorySize>)TaskManagerOptions.JVM_METASPACE, (ConfigOption<MemorySize>)TaskManagerOptions.JVM_OVERHEAD_MIN, (ConfigOption<MemorySize>)TaskManagerOptions.JVM_OVERHEAD_MAX, (ConfigOption<Float>)TaskManagerOptions.JVM_OVERHEAD_FRACTION));
    static final LegacyMemoryOptions TM_LEGACY_HEAP_OPTIONS = new LegacyMemoryOptions("FLINK_TM_HEAP", (ConfigOption<MemorySize>)TaskManagerOptions.TASK_MANAGER_HEAP_MEMORY, (ConfigOption<Integer>)TaskManagerOptions.TASK_MANAGER_HEAP_MEMORY_MB);
    private static final ProcessMemoryUtils<TaskExecutorFlinkMemory> PROCESS_MEMORY_UTILS = new ProcessMemoryUtils<TaskExecutorFlinkMemory>(TM_PROCESS_MEMORY_OPTIONS, new TaskExecutorFlinkMemoryUtils());
    private static final MemoryBackwardsCompatibilityUtils LEGACY_MEMORY_UTILS = new MemoryBackwardsCompatibilityUtils(TM_LEGACY_HEAP_OPTIONS);

    private TaskExecutorProcessUtils() {
    }

    public static String generateDynamicConfigsStr(TaskExecutorProcessSpec taskExecutorProcessSpec) {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put(TaskManagerOptions.CPU_CORES.key(), String.valueOf(taskExecutorProcessSpec.getCpuCores().getValue().doubleValue()));
        configs.put(TaskManagerOptions.FRAMEWORK_HEAP_MEMORY.key(), taskExecutorProcessSpec.getFrameworkHeapSize().getBytes() + "b");
        configs.put(TaskManagerOptions.FRAMEWORK_OFF_HEAP_MEMORY.key(), taskExecutorProcessSpec.getFrameworkOffHeapMemorySize().getBytes() + "b");
        configs.put(TaskManagerOptions.TASK_HEAP_MEMORY.key(), taskExecutorProcessSpec.getTaskHeapSize().getBytes() + "b");
        configs.put(TaskManagerOptions.TASK_OFF_HEAP_MEMORY.key(), taskExecutorProcessSpec.getTaskOffHeapSize().getBytes() + "b");
        configs.put(TaskManagerOptions.NETWORK_MEMORY_MIN.key(), taskExecutorProcessSpec.getNetworkMemSize().getBytes() + "b");
        configs.put(TaskManagerOptions.NETWORK_MEMORY_MAX.key(), taskExecutorProcessSpec.getNetworkMemSize().getBytes() + "b");
        configs.put(TaskManagerOptions.MANAGED_MEMORY_SIZE.key(), taskExecutorProcessSpec.getManagedMemorySize().getBytes() + "b");
        return TaskExecutorProcessUtils.assembleDynamicConfigsStr(configs);
    }

    private static String assembleDynamicConfigsStr(Map<String, String> configs) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : configs.entrySet()) {
            sb.append("-D ").append(entry.getKey()).append("=").append(entry.getValue()).append(" ");
        }
        return sb.toString();
    }

    public static TaskExecutorProcessSpecBuilder newProcessSpecBuilder(Configuration config) {
        return TaskExecutorProcessSpecBuilder.newBuilder(config);
    }

    public static TaskExecutorProcessSpec processSpecFromConfig(Configuration config) {
        return TaskExecutorProcessUtils.createMemoryProcessSpec(config, PROCESS_MEMORY_UTILS.memoryProcessSpecFromConfig(config));
    }

    public static TaskExecutorProcessSpec processSpecFromWorkerResourceSpec(Configuration config, WorkerResourceSpec workerResourceSpec) {
        MemorySize frameworkHeapMemorySize = TaskExecutorFlinkMemoryUtils.getFrameworkHeapMemorySize(config);
        MemorySize frameworkOffHeapMemorySize = TaskExecutorFlinkMemoryUtils.getFrameworkOffHeapMemorySize(config);
        TaskExecutorFlinkMemory flinkMemory = new TaskExecutorFlinkMemory(frameworkHeapMemorySize, frameworkOffHeapMemorySize, workerResourceSpec.getTaskHeapSize(), workerResourceSpec.getTaskOffHeapSize(), workerResourceSpec.getNetworkMemSize(), workerResourceSpec.getManagedMemSize());
        JvmMetaspaceAndOverhead jvmMetaspaceAndOverhead = PROCESS_MEMORY_UTILS.deriveJvmMetaspaceAndOverheadFromTotalFlinkMemory(config, flinkMemory.getTotalFlinkMemorySize());
        return new TaskExecutorProcessSpec(workerResourceSpec.getCpuCores(), flinkMemory, jvmMetaspaceAndOverhead);
    }

    private static TaskExecutorProcessSpec createMemoryProcessSpec(Configuration config, CommonProcessMemorySpec<TaskExecutorFlinkMemory> processMemory) {
        TaskExecutorFlinkMemory flinkMemory = processMemory.getFlinkMemory();
        JvmMetaspaceAndOverhead jvmMetaspaceAndOverhead = processMemory.getJvmMetaspaceAndOverhead();
        return new TaskExecutorProcessSpec(TaskExecutorProcessUtils.getCpuCores(config), flinkMemory, jvmMetaspaceAndOverhead);
    }

    private static CPUResource getCpuCores(Configuration config) {
        return TaskExecutorProcessUtils.getCpuCoresWithFallback(config, -1.0);
    }

    public static double getCpuCoresWithFallbackConfigOption(Configuration config, ConfigOption<Double> fallbackOption) {
        double fallbackValue = config.getDouble(fallbackOption);
        return TaskExecutorProcessUtils.getCpuCoresWithFallback(config, fallbackValue).getValue().doubleValue();
    }

    public static CPUResource getCpuCoresWithFallback(Configuration config, double fallback) {
        double cpuCores = config.contains(TaskManagerOptions.CPU_CORES) ? config.getDouble(TaskManagerOptions.CPU_CORES) : (fallback > 0.0 ? fallback : (double)config.getInteger(TaskManagerOptions.NUM_TASK_SLOTS));
        if (cpuCores <= 0.0) {
            throw new IllegalConfigurationException(String.format("TaskExecutors need to be started with a positive number of CPU cores. Please configure %s accordingly.", TaskManagerOptions.CPU_CORES.key()));
        }
        return new CPUResource(cpuCores);
    }

    public static Configuration getConfigurationMapLegacyTaskManagerHeapSizeToConfigOption(Configuration configuration, ConfigOption<MemorySize> configOption) {
        return LEGACY_MEMORY_UTILS.getConfWithLegacyHeapSizeMappedToNewConfigOption(configuration, configOption);
    }
}

