/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.writer;

import java.io.IOException;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MeterView;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.AvailabilityProvider;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.api.serialization.RecordSerializer;
import org.apache.flink.runtime.io.network.api.serialization.SpanningRecordSerializer;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.XORShiftRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RecordWriter<T extends IOReadableWritable>
implements AvailabilityProvider {
    @VisibleForTesting
    public static final String DEFAULT_OUTPUT_FLUSH_THREAD_NAME = "OutputFlusher";
    private static final Logger LOG = LoggerFactory.getLogger(RecordWriter.class);
    private final ResultPartitionWriter targetPartition;
    protected final int numberOfChannels;
    protected final RecordSerializer<T> serializer;
    protected final Random rng = new XORShiftRandom();
    private Counter numBytesOut = new SimpleCounter();
    private Counter numBuffersOut = new SimpleCounter();
    protected Meter idleTimeMsPerSecond = new MeterView((Counter)new SimpleCounter());
    private final boolean flushAlways;
    @Nullable
    private final OutputFlusher outputFlusher;
    private Throwable flusherException;

    RecordWriter(ResultPartitionWriter writer, long timeout, String taskName) {
        this.targetPartition = writer;
        this.numberOfChannels = writer.getNumberOfSubpartitions();
        this.serializer = new SpanningRecordSerializer();
        Preconditions.checkArgument((timeout >= -1L ? 1 : 0) != 0);
        boolean bl = this.flushAlways = timeout == 0L;
        if (timeout == -1L || timeout == 0L) {
            this.outputFlusher = null;
        } else {
            String threadName = taskName == null ? DEFAULT_OUTPUT_FLUSH_THREAD_NAME : "OutputFlusher for " + taskName;
            this.outputFlusher = new OutputFlusher(threadName, timeout);
            this.outputFlusher.start();
        }
    }

    protected void emit(T record, int targetChannel) throws IOException, InterruptedException {
        this.checkErroneous();
        this.serializer.serializeRecord(record);
        if (this.copyFromSerializerToTargetChannel(targetChannel)) {
            this.serializer.prune();
        }
    }

    protected boolean copyFromSerializerToTargetChannel(int targetChannel) throws IOException, InterruptedException {
        this.serializer.reset();
        boolean pruneTriggered = false;
        BufferBuilder bufferBuilder = this.getBufferBuilder(targetChannel);
        RecordSerializer.SerializationResult result = this.serializer.copyToBufferBuilder(bufferBuilder);
        while (result.isFullBuffer()) {
            this.finishBufferBuilder(bufferBuilder);
            if (result.isFullRecord()) {
                pruneTriggered = true;
                this.emptyCurrentBufferBuilder(targetChannel);
                break;
            }
            bufferBuilder = this.requestNewBufferBuilder(targetChannel);
            result = this.serializer.copyToBufferBuilder(bufferBuilder);
        }
        Preconditions.checkState((!this.serializer.hasSerializedData() ? 1 : 0) != 0, (Object)"All data should be written at once");
        if (this.flushAlways) {
            this.flushTargetPartition(targetChannel);
        }
        return pruneTriggered;
    }

    public void broadcastEvent(AbstractEvent event) throws IOException {
        this.broadcastEvent(event, false);
    }

    public void broadcastEvent(AbstractEvent event, boolean isPriorityEvent) throws IOException {
        try (BufferConsumer eventBufferConsumer = EventSerializer.toBufferConsumer(event);){
            for (int targetChannel = 0; targetChannel < this.numberOfChannels; ++targetChannel) {
                this.tryFinishCurrentBufferBuilder(targetChannel);
                this.targetPartition.addBufferConsumer(eventBufferConsumer.copy(), targetChannel, isPriorityEvent);
            }
            if (this.flushAlways) {
                this.flushAll();
            }
        }
    }

    public void flushAll() {
        this.targetPartition.flushAll();
    }

    protected void flushTargetPartition(int targetChannel) {
        this.targetPartition.flush(targetChannel);
    }

    public void setMetricGroup(TaskIOMetricGroup metrics) {
        this.numBytesOut = metrics.getNumBytesOutCounter();
        this.numBuffersOut = metrics.getNumBuffersOutCounter();
        this.idleTimeMsPerSecond = metrics.getIdleTimeMsPerSecond();
    }

    protected void finishBufferBuilder(BufferBuilder bufferBuilder) {
        this.numBytesOut.inc((long)bufferBuilder.finish());
        this.numBuffersOut.inc();
    }

    @Override
    public CompletableFuture<?> getAvailableFuture() {
        return this.targetPartition.getAvailableFuture();
    }

    public abstract void emit(T var1) throws IOException, InterruptedException;

    public abstract void randomEmit(T var1) throws IOException, InterruptedException;

    public abstract void broadcastEmit(T var1) throws IOException, InterruptedException;

    abstract BufferBuilder getBufferBuilder(int var1) throws IOException, InterruptedException;

    abstract void tryFinishCurrentBufferBuilder(int var1);

    abstract void emptyCurrentBufferBuilder(int var1);

    abstract void closeBufferBuilder(int var1);

    public abstract void clearBuffers();

    public void close() {
        this.clearBuffers();
        if (this.outputFlusher != null) {
            this.outputFlusher.terminate();
            try {
                this.outputFlusher.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void notifyFlusherException(Throwable t) {
        if (this.flusherException == null) {
            LOG.error("An exception happened while flushing the outputs", t);
            this.flusherException = t;
        }
    }

    protected void checkErroneous() throws IOException {
        if (this.flusherException != null) {
            throw new IOException("An exception happened while flushing the outputs", this.flusherException);
        }
    }

    protected void addBufferConsumer(BufferConsumer consumer, int targetChannel) throws IOException {
        this.targetPartition.addBufferConsumer(consumer, targetChannel);
    }

    public BufferBuilder requestNewBufferBuilder(int targetChannel) throws IOException, InterruptedException {
        BufferBuilder builder = this.targetPartition.tryGetBufferBuilder(targetChannel);
        if (builder == null) {
            long start = System.currentTimeMillis();
            builder = this.targetPartition.getBufferBuilder(targetChannel);
            this.idleTimeMsPerSecond.markEvent(System.currentTimeMillis() - start);
        }
        return builder;
    }

    @VisibleForTesting
    public Meter getIdleTimeMsPerSecond() {
        return this.idleTimeMsPerSecond;
    }

    @VisibleForTesting
    ResultPartitionWriter getTargetPartition() {
        return this.targetPartition;
    }

    private class OutputFlusher
    extends Thread {
        private final long timeout;
        private volatile boolean running;

        OutputFlusher(String name, long timeout) {
            super(name);
            this.running = true;
            this.setDaemon(true);
            this.timeout = timeout;
        }

        public void terminate() {
            this.running = false;
            this.interrupt();
        }

        @Override
        public void run() {
            try {
                while (this.running) {
                    block5: {
                        try {
                            Thread.sleep(this.timeout);
                        }
                        catch (InterruptedException e) {
                            if (!this.running) break block5;
                            throw new Exception(e);
                        }
                    }
                    RecordWriter.this.flushAll();
                }
            }
            catch (Throwable t) {
                RecordWriter.this.notifyFlusherException(t);
            }
        }
    }
}

