/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager;

import java.util.Collections;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.jobmanager.JobManagerProcessSpec;
import org.apache.flink.runtime.util.config.memory.CommonProcessMemorySpec;
import org.apache.flink.runtime.util.config.memory.JvmMetaspaceAndOverheadOptions;
import org.apache.flink.runtime.util.config.memory.LegacyMemoryOptions;
import org.apache.flink.runtime.util.config.memory.MemoryBackwardsCompatibilityUtils;
import org.apache.flink.runtime.util.config.memory.ProcessMemoryOptions;
import org.apache.flink.runtime.util.config.memory.ProcessMemoryUtils;
import org.apache.flink.runtime.util.config.memory.jobmanager.JobManagerFlinkMemory;
import org.apache.flink.runtime.util.config.memory.jobmanager.JobManagerFlinkMemoryUtils;

public class JobManagerProcessUtils {
    static final ProcessMemoryOptions JM_PROCESS_MEMORY_OPTIONS = new ProcessMemoryOptions(Collections.singletonList(JobManagerOptions.JVM_HEAP_MEMORY), (ConfigOption<MemorySize>)JobManagerOptions.TOTAL_FLINK_MEMORY, (ConfigOption<MemorySize>)JobManagerOptions.TOTAL_PROCESS_MEMORY, new JvmMetaspaceAndOverheadOptions((ConfigOption<MemorySize>)JobManagerOptions.JVM_METASPACE, (ConfigOption<MemorySize>)JobManagerOptions.JVM_OVERHEAD_MIN, (ConfigOption<MemorySize>)JobManagerOptions.JVM_OVERHEAD_MAX, (ConfigOption<Float>)JobManagerOptions.JVM_OVERHEAD_FRACTION));
    static final LegacyMemoryOptions JM_LEGACY_HEAP_OPTIONS = new LegacyMemoryOptions("FLINK_JM_HEAP", (ConfigOption<MemorySize>)JobManagerOptions.JOB_MANAGER_HEAP_MEMORY, (ConfigOption<Integer>)JobManagerOptions.JOB_MANAGER_HEAP_MEMORY_MB);
    private static final ProcessMemoryUtils<JobManagerFlinkMemory> PROCESS_MEMORY_UTILS = new ProcessMemoryUtils<JobManagerFlinkMemory>(JM_PROCESS_MEMORY_OPTIONS, new JobManagerFlinkMemoryUtils());
    private static final MemoryBackwardsCompatibilityUtils LEGACY_MEMORY_UTILS = new MemoryBackwardsCompatibilityUtils(JM_LEGACY_HEAP_OPTIONS);

    private JobManagerProcessUtils() {
    }

    public static JobManagerProcessSpec processSpecFromConfigWithNewOptionToInterpretLegacyHeap(Configuration config, ConfigOption<MemorySize> newOptionToInterpretLegacyHeap) {
        return JobManagerProcessUtils.processSpecFromConfig(JobManagerProcessUtils.getConfigurationWithLegacyHeapSizeMappedToNewConfigOption(config, newOptionToInterpretLegacyHeap));
    }

    static JobManagerProcessSpec processSpecFromConfig(Configuration config) {
        return JobManagerProcessUtils.createMemoryProcessSpec(PROCESS_MEMORY_UTILS.memoryProcessSpecFromConfig(config));
    }

    private static JobManagerProcessSpec createMemoryProcessSpec(CommonProcessMemorySpec<JobManagerFlinkMemory> processMemory) {
        return new JobManagerProcessSpec(processMemory.getFlinkMemory(), processMemory.getJvmMetaspaceAndOverhead());
    }

    static Configuration getConfigurationWithLegacyHeapSizeMappedToNewConfigOption(Configuration configuration, ConfigOption<MemorySize> configOption) {
        return LEGACY_MEMORY_UTILS.getConfWithLegacyHeapSizeMappedToNewConfigOption(configuration, configOption);
    }

    @VisibleForTesting
    public static JobManagerProcessSpec createDefaultJobManagerProcessSpec(int totalProcessMemoryMb) {
        Configuration configuration = new Configuration();
        configuration.set(JobManagerOptions.TOTAL_PROCESS_MEMORY, (Object)MemorySize.ofMebiBytes((long)totalProcessMemoryMb));
        return JobManagerProcessUtils.processSpecFromConfig(configuration);
    }

    public static String generateJvmParametersStr(JobManagerProcessSpec processSpec, Configuration configuration) {
        return ProcessMemoryUtils.generateJvmParametersStr(processSpec, configuration.getBoolean(JobManagerOptions.JVM_DIRECT_MEMORY_LIMIT_ENABLED));
    }
}

