/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.memory;

import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnegative;
import org.apache.flink.runtime.memory.MemoryReservationException;
import org.apache.flink.util.JavaGcCleanerWrapper;

class UnsafeMemoryBudget {
    private static final int MAX_SLEEPS = 10;
    private static final int RETRIGGER_GC_AFTER_SLEEPS = 9;
    private final long totalMemorySize;
    private final AtomicLong availableMemorySize;

    UnsafeMemoryBudget(long totalMemorySize) {
        this.totalMemorySize = totalMemorySize;
        this.availableMemorySize = new AtomicLong(totalMemorySize);
    }

    long getTotalMemorySize() {
        return this.totalMemorySize;
    }

    long getAvailableMemorySize() {
        return this.availableMemorySize.get();
    }

    boolean verifyEmpty() {
        try {
            this.reserveMemory(this.totalMemorySize);
        }
        catch (MemoryReservationException e) {
            return false;
        }
        this.releaseMemory(this.totalMemorySize);
        return this.availableMemorySize.get() == this.totalMemorySize;
    }

    void reserveMemory(long size) throws MemoryReservationException {
        long availableOrReserved = this.tryReserveMemory(size);
        if (availableOrReserved >= size) {
            return;
        }
        boolean interrupted = false;
        try {
            boolean refprocActive;
            do {
                try {
                    refprocActive = JavaGcCleanerWrapper.tryRunPendingCleaners();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    refprocActive = true;
                }
                availableOrReserved = this.tryReserveMemory(size);
                if (availableOrReserved < size) continue;
                return;
            } while (refprocActive);
            System.gc();
            long sleepTime = 1L;
            int sleeps = 0;
            while (true) {
                if ((availableOrReserved = this.tryReserveMemory(size)) >= size) {
                    return;
                }
                if (sleeps >= 10) break;
                if (sleeps >= 9) {
                    System.gc();
                }
                try {
                    if (JavaGcCleanerWrapper.tryRunPendingCleaners()) continue;
                    Thread.sleep(sleepTime);
                    sleepTime <<= 1;
                    ++sleeps;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            throw new MemoryReservationException(String.format("Could not allocate %d bytes, only %d bytes are remaining", size, availableOrReserved));
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private long tryReserveMemory(long size) {
        long currentAvailableMemorySize;
        while (size <= (currentAvailableMemorySize = this.availableMemorySize.get())) {
            if (!this.availableMemorySize.compareAndSet(currentAvailableMemorySize, currentAvailableMemorySize - size)) continue;
            return size;
        }
        return currentAvailableMemorySize;
    }

    void releaseMemory(@Nonnegative long size) {
        if (size == 0L) {
            return;
        }
        boolean released = false;
        long currentAvailableMemorySize = 0L;
        while (!released && this.totalMemorySize >= (currentAvailableMemorySize = this.availableMemorySize.get()) + size) {
            released = this.availableMemorySize.compareAndSet(currentAvailableMemorySize, currentAvailableMemorySize + size);
        }
        if (!released) {
            throw new IllegalStateException(String.format("Trying to release more managed memory (%d bytes) than has been allocated (%d bytes), the total size is %d bytes", size, currentAvailableMemorySize, this.totalMemorySize));
        }
    }
}

