/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability.zookeeper;

import java.io.IOException;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.BlobStoreService;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.ZooKeeperCheckpointRecoveryFactory;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.RunningJobsRegistry;
import org.apache.flink.runtime.highavailability.zookeeper.ZooKeeperRunningJobsRegistry;
import org.apache.flink.runtime.jobmanager.JobGraphStore;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.shaded.curator4.org.apache.curator.utils.ZKPaths;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.KeeperException;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperHaServices
implements HighAvailabilityServices {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperHaServices.class);
    private static final String RESOURCE_MANAGER_LEADER_PATH = "/resource_manager_lock";
    private static final String DISPATCHER_LEADER_PATH = "/dispatcher_lock";
    private static final String JOB_MANAGER_LEADER_PATH = "/job_manager_lock";
    private static final String REST_SERVER_LEADER_PATH = "/rest_server_lock";
    private final CuratorFramework client;
    private final Executor executor;
    private final Configuration configuration;
    private final RunningJobsRegistry runningJobsRegistry;
    private final BlobStoreService blobStoreService;

    public ZooKeeperHaServices(CuratorFramework client, Executor executor, Configuration configuration, BlobStoreService blobStoreService) {
        this.client = (CuratorFramework)Preconditions.checkNotNull((Object)client);
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration);
        this.runningJobsRegistry = new ZooKeeperRunningJobsRegistry(client, configuration);
        this.blobStoreService = (BlobStoreService)Preconditions.checkNotNull((Object)blobStoreService);
    }

    @Override
    public LeaderRetrievalService getResourceManagerLeaderRetriever() {
        return ZooKeeperUtils.createLeaderRetrievalService(this.client, this.configuration, RESOURCE_MANAGER_LEADER_PATH);
    }

    @Override
    public LeaderRetrievalService getDispatcherLeaderRetriever() {
        return ZooKeeperUtils.createLeaderRetrievalService(this.client, this.configuration, DISPATCHER_LEADER_PATH);
    }

    @Override
    public LeaderRetrievalService getJobManagerLeaderRetriever(JobID jobID) {
        return ZooKeeperUtils.createLeaderRetrievalService(this.client, this.configuration, ZooKeeperHaServices.getPathForJobManager(jobID));
    }

    @Override
    public LeaderRetrievalService getJobManagerLeaderRetriever(JobID jobID, String defaultJobManagerAddress) {
        return this.getJobManagerLeaderRetriever(jobID);
    }

    @Override
    public LeaderRetrievalService getClusterRestEndpointLeaderRetriever() {
        return ZooKeeperUtils.createLeaderRetrievalService(this.client, this.configuration, REST_SERVER_LEADER_PATH);
    }

    @Override
    public LeaderElectionService getResourceManagerLeaderElectionService() {
        return ZooKeeperUtils.createLeaderElectionService(this.client, this.configuration, RESOURCE_MANAGER_LEADER_PATH);
    }

    @Override
    public LeaderElectionService getDispatcherLeaderElectionService() {
        return ZooKeeperUtils.createLeaderElectionService(this.client, this.configuration, DISPATCHER_LEADER_PATH);
    }

    @Override
    public LeaderElectionService getJobManagerLeaderElectionService(JobID jobID) {
        return ZooKeeperUtils.createLeaderElectionService(this.client, this.configuration, ZooKeeperHaServices.getPathForJobManager(jobID));
    }

    @Override
    public LeaderElectionService getClusterRestEndpointLeaderElectionService() {
        return ZooKeeperUtils.createLeaderElectionService(this.client, this.configuration, REST_SERVER_LEADER_PATH);
    }

    @Override
    public CheckpointRecoveryFactory getCheckpointRecoveryFactory() {
        return new ZooKeeperCheckpointRecoveryFactory(this.client, this.configuration, this.executor);
    }

    @Override
    public JobGraphStore getJobGraphStore() throws Exception {
        return ZooKeeperUtils.createJobGraphs(this.client, this.configuration);
    }

    @Override
    public RunningJobsRegistry getRunningJobsRegistry() {
        return this.runningJobsRegistry;
    }

    @Override
    public BlobStore createBlobStore() throws IOException {
        return this.blobStoreService;
    }

    @Override
    public void close() throws Exception {
        Throwable exception = null;
        try {
            this.blobStoreService.close();
        }
        catch (Throwable t) {
            exception = t;
        }
        this.internalClose();
        if (exception != null) {
            ExceptionUtils.rethrowException((Throwable)exception, (String)"Could not properly close the ZooKeeperHaServices.");
        }
    }

    @Override
    public void closeAndCleanupAllData() throws Exception {
        LOG.info("Close and clean up all data for ZooKeeperHaServices.");
        Throwable exception = null;
        boolean deletedHAData = false;
        try {
            this.cleanupZooKeeperPaths();
            deletedHAData = true;
        }
        catch (Exception e) {
            exception = e;
        }
        this.internalClose();
        try {
            if (deletedHAData) {
                this.blobStoreService.closeAndCleanupAllData();
            } else {
                this.blobStoreService.close();
            }
        }
        catch (Throwable t) {
            exception = ExceptionUtils.firstOrSuppressed((Throwable)t, (Throwable)exception);
        }
        if (exception != null) {
            ExceptionUtils.rethrowException((Throwable)exception, (String)"Could not properly close and clean up all data of ZooKeeperHaServices.");
        }
    }

    private void cleanupZooKeeperPaths() throws Exception {
        this.deleteOwnedZNode();
        this.tryDeleteEmptyParentZNodes();
    }

    private void deleteOwnedZNode() throws Exception {
        boolean zNodeDeleted = false;
        while (!zNodeDeleted) {
            try {
                this.client.delete().deletingChildrenIfNeeded().forPath("/");
                zNodeDeleted = true;
            }
            catch (KeeperException.NoNodeException ignored) {
                LOG.debug("Retrying to delete owned znode because of other concurrent delete operation.");
            }
        }
    }

    private void tryDeleteEmptyParentZNodes() throws Exception {
        String remainingPath = ZooKeeperHaServices.getParentPath(ZooKeeperHaServices.getNormalizedPath(this.client.getNamespace()));
        CuratorFramework nonNamespaceClient = this.client.usingNamespace(null);
        while (!ZooKeeperHaServices.isRootPath(remainingPath)) {
            try {
                nonNamespaceClient.delete().forPath(remainingPath);
            }
            catch (KeeperException.NotEmptyException ignored) {
                break;
            }
            remainingPath = ZooKeeperHaServices.getParentPath(remainingPath);
        }
    }

    private static boolean isRootPath(String remainingPath) {
        return "/".equals(remainingPath);
    }

    @Nonnull
    private static String getNormalizedPath(String path) {
        return ZKPaths.makePath((String)path, (String)"");
    }

    @Nonnull
    private static String getParentPath(String path) {
        return ZKPaths.getPathAndNode((String)path).getPath();
    }

    private void internalClose() {
        this.client.close();
    }

    private static String getPathForJobManager(JobID jobID) {
        return "/" + jobID + JOB_MANAGER_LEADER_PATH;
    }
}

