/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.lang.reflect.Field;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.CompositeByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.PooledByteBufAllocator;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public class NettyBufferPool
extends PooledByteBufAllocator {
    private static final Logger LOG = LoggerFactory.getLogger(NettyBufferPool.class);
    private final Object[] directArenas;
    private final int numberOfArenas;
    private final int chunkSize;
    private static final boolean PREFER_DIRECT = true;
    private static final int PAGE_SIZE = 8192;
    private static final int MAX_ORDER = 9;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NettyBufferPool(int numberOfArenas) {
        super(true, 0, numberOfArenas, 8192, 9);
        Preconditions.checkArgument((numberOfArenas >= 1 ? 1 : 0) != 0, (Object)"Number of arenas");
        this.numberOfArenas = numberOfArenas;
        this.chunkSize = 0x400000;
        Object[] allocDirectArenas = null;
        try {
            Field directArenasField = PooledByteBufAllocator.class.getDeclaredField("directArenas");
            directArenasField.setAccessible(true);
            allocDirectArenas = (Object[])directArenasField.get((Object)this);
        }
        catch (Exception ignored) {
            LOG.warn("Memory statistics not available");
        }
        finally {
            this.directArenas = allocDirectArenas;
        }
    }

    int getNumberOfArenas() {
        return this.numberOfArenas;
    }

    int getChunkSize() {
        return this.chunkSize;
    }

    public Option<Long> getNumberOfAllocatedBytes() throws NoSuchFieldException, IllegalAccessException {
        if (this.directArenas != null) {
            long numChunks = 0L;
            for (Object arena : this.directArenas) {
                numChunks += this.getNumberOfAllocatedChunks(arena, "qInit");
                numChunks += this.getNumberOfAllocatedChunks(arena, "q000");
                numChunks += this.getNumberOfAllocatedChunks(arena, "q025");
                numChunks += this.getNumberOfAllocatedChunks(arena, "q050");
                numChunks += this.getNumberOfAllocatedChunks(arena, "q075");
                numChunks += this.getNumberOfAllocatedChunks(arena, "q100");
            }
            long allocatedBytes = numChunks * (long)this.chunkSize;
            return Option.apply((Object)allocatedBytes);
        }
        return Option.empty();
    }

    private long getNumberOfAllocatedChunks(Object arena, String chunkListFieldName) throws NoSuchFieldException, IllegalAccessException {
        Field chunkListField = arena.getClass().getSuperclass().getDeclaredField(chunkListFieldName);
        chunkListField.setAccessible(true);
        Object chunkList = chunkListField.get(arena);
        Field headChunkField = chunkList.getClass().getDeclaredField("head");
        headChunkField.setAccessible(true);
        Object headChunk = headChunkField.get(chunkList);
        if (headChunk == null) {
            return 0L;
        }
        int numChunks = 0;
        Object current = headChunk;
        while (current != null) {
            Field nextChunkField = headChunk.getClass().getDeclaredField("next");
            nextChunkField.setAccessible(true);
            current = nextChunkField.get(current);
            ++numChunks;
        }
        return numChunks;
    }

    public ByteBuf heapBuffer() {
        throw new UnsupportedOperationException("Heap buffer");
    }

    public ByteBuf heapBuffer(int initialCapacity) {
        throw new UnsupportedOperationException("Heap buffer");
    }

    public ByteBuf heapBuffer(int initialCapacity, int maxCapacity) {
        throw new UnsupportedOperationException("Heap buffer");
    }

    public CompositeByteBuf compositeHeapBuffer() {
        throw new UnsupportedOperationException("Heap buffer");
    }

    public CompositeByteBuf compositeHeapBuffer(int maxNumComponents) {
        throw new UnsupportedOperationException("Heap buffer");
    }
}

