/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.checkpoint.CheckpointType;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.util.Preconditions;

public class CheckpointOptions
implements Serializable {
    public static final long NO_ALIGNMENT_TIME_OUT = Long.MAX_VALUE;
    private static final long serialVersionUID = 5010126558083292915L;
    private final CheckpointType checkpointType;
    private final CheckpointStorageLocationReference targetLocation;
    private final AlignmentType alignmentType;
    private static final CheckpointOptions CHECKPOINT_AT_DEFAULT_LOCATION = new CheckpointOptions(CheckpointType.CHECKPOINT, CheckpointStorageLocationReference.getDefault());

    public static CheckpointOptions notExactlyOnce(CheckpointType type, CheckpointStorageLocationReference location) {
        return new CheckpointOptions(type, location, AlignmentType.AT_LEAST_ONCE);
    }

    public static CheckpointOptions aligned(CheckpointType type, CheckpointStorageLocationReference location) {
        return new CheckpointOptions(type, location, AlignmentType.ALIGNED);
    }

    public static CheckpointOptions unaligned(CheckpointStorageLocationReference location) {
        return new CheckpointOptions(CheckpointType.CHECKPOINT, location, AlignmentType.UNALIGNED);
    }

    private static CheckpointOptions forceAligned(CheckpointStorageLocationReference location) {
        return new CheckpointOptions(CheckpointType.CHECKPOINT, location, AlignmentType.FORCED_ALIGNED);
    }

    public static CheckpointOptions forConfig(CheckpointType checkpointType, CheckpointStorageLocationReference locationReference, boolean isExactlyOnceMode, boolean isUnalignedEnabled) {
        if (!isExactlyOnceMode) {
            return CheckpointOptions.notExactlyOnce(checkpointType, locationReference);
        }
        if (checkpointType.isSavepoint()) {
            return CheckpointOptions.aligned(checkpointType, locationReference);
        }
        if (!isUnalignedEnabled) {
            return CheckpointOptions.aligned(checkpointType, locationReference);
        }
        return CheckpointOptions.unaligned(locationReference);
    }

    @VisibleForTesting
    public CheckpointOptions(CheckpointType checkpointType, CheckpointStorageLocationReference targetLocation) {
        this(checkpointType, targetLocation, AlignmentType.ALIGNED);
    }

    public CheckpointOptions(CheckpointType checkpointType, CheckpointStorageLocationReference targetLocation, AlignmentType alignmentType) {
        Preconditions.checkArgument((alignmentType != AlignmentType.UNALIGNED || !checkpointType.isSavepoint() ? 1 : 0) != 0, (Object)"Savepoint can't be unaligned");
        this.checkpointType = (CheckpointType)((Object)Preconditions.checkNotNull((Object)((Object)checkpointType)));
        this.targetLocation = (CheckpointStorageLocationReference)Preconditions.checkNotNull((Object)targetLocation);
        this.alignmentType = (AlignmentType)((Object)Preconditions.checkNotNull((Object)((Object)alignmentType)));
    }

    public boolean needsAlignment() {
        return this.isExactlyOnceMode() && (this.getCheckpointType().isSavepoint() || !this.isUnalignedCheckpoint());
    }

    public AlignmentType getAlignment() {
        return this.alignmentType;
    }

    public CheckpointType getCheckpointType() {
        return this.checkpointType;
    }

    public CheckpointStorageLocationReference getTargetLocation() {
        return this.targetLocation;
    }

    public boolean isExactlyOnceMode() {
        return this.alignmentType != AlignmentType.AT_LEAST_ONCE;
    }

    public boolean isUnalignedCheckpoint() {
        return this.alignmentType == AlignmentType.UNALIGNED;
    }

    public CheckpointOptions withUnalignedSupported() {
        if (this.alignmentType == AlignmentType.FORCED_ALIGNED) {
            return CheckpointOptions.unaligned(this.targetLocation);
        }
        return this;
    }

    public CheckpointOptions withUnalignedUnsupported() {
        if (this.isUnalignedCheckpoint()) {
            return CheckpointOptions.forceAligned(this.targetLocation);
        }
        return this;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.targetLocation, this.checkpointType, this.alignmentType});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj.getClass() == CheckpointOptions.class) {
            CheckpointOptions that = (CheckpointOptions)obj;
            return this.checkpointType == that.checkpointType && this.targetLocation.equals(that.targetLocation) && this.alignmentType == that.alignmentType;
        }
        return false;
    }

    public String toString() {
        return "CheckpointOptions {checkpointType = " + (Object)((Object)this.checkpointType) + ", targetLocation = " + this.targetLocation + ", alignment = " + (Object)((Object)this.alignmentType) + "}";
    }

    @VisibleForTesting
    public static CheckpointOptions forCheckpointWithDefaultLocation() {
        return CHECKPOINT_AT_DEFAULT_LOCATION;
    }

    public CheckpointOptions toUnaligned() {
        Preconditions.checkState((this.alignmentType == AlignmentType.ALIGNED ? 1 : 0) != 0);
        return CheckpointOptions.unaligned(this.targetLocation);
    }

    public static enum AlignmentType {
        AT_LEAST_ONCE,
        ALIGNED,
        UNALIGNED,
        FORCED_ALIGNED;

    }
}

