/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.instance.SlotSharingGroupId;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationConstraint;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.Preconditions;

public class ExecutionVertexSchedulingRequirements {
    private final ExecutionVertexID executionVertexId;
    @Nullable
    private final AllocationID previousAllocationId;
    private final ResourceProfile taskResourceProfile;
    private final ResourceProfile physicalSlotResourceProfile;
    @Nullable
    private final SlotSharingGroupId slotSharingGroupId;
    @Nullable
    private final CoLocationConstraint coLocationConstraint;
    private final Collection<TaskManagerLocation> preferredLocations;

    private ExecutionVertexSchedulingRequirements(ExecutionVertexID executionVertexId, @Nullable AllocationID previousAllocationId, ResourceProfile taskResourceProfile, ResourceProfile physicalSlotResourceProfile, @Nullable SlotSharingGroupId slotSharingGroupId, @Nullable CoLocationConstraint coLocationConstraint, Collection<TaskManagerLocation> preferredLocations) {
        this.executionVertexId = (ExecutionVertexID)Preconditions.checkNotNull((Object)executionVertexId);
        this.previousAllocationId = previousAllocationId;
        this.taskResourceProfile = (ResourceProfile)Preconditions.checkNotNull((Object)taskResourceProfile);
        this.physicalSlotResourceProfile = (ResourceProfile)Preconditions.checkNotNull((Object)physicalSlotResourceProfile);
        this.slotSharingGroupId = slotSharingGroupId;
        this.coLocationConstraint = coLocationConstraint;
        this.preferredLocations = (Collection)Preconditions.checkNotNull(preferredLocations);
    }

    public ExecutionVertexID getExecutionVertexId() {
        return this.executionVertexId;
    }

    @Nullable
    public AllocationID getPreviousAllocationId() {
        return this.previousAllocationId;
    }

    public ResourceProfile getTaskResourceProfile() {
        return this.taskResourceProfile;
    }

    public ResourceProfile getPhysicalSlotResourceProfile() {
        return this.physicalSlotResourceProfile;
    }

    @Nullable
    public SlotSharingGroupId getSlotSharingGroupId() {
        return this.slotSharingGroupId;
    }

    @Nullable
    public CoLocationConstraint getCoLocationConstraint() {
        return this.coLocationConstraint;
    }

    public Collection<TaskManagerLocation> getPreferredLocations() {
        return this.preferredLocations;
    }

    public static class Builder {
        private ExecutionVertexID executionVertexId;
        private AllocationID previousAllocationId;
        private ResourceProfile taskResourceProfile = ResourceProfile.UNKNOWN;
        private ResourceProfile physicalSlotResourceProfile = ResourceProfile.UNKNOWN;
        private SlotSharingGroupId slotSharingGroupId;
        private CoLocationConstraint coLocationConstraint;
        private Collection<TaskManagerLocation> preferredLocations = Collections.emptyList();

        public Builder withExecutionVertexId(ExecutionVertexID executionVertexId) {
            this.executionVertexId = executionVertexId;
            return this;
        }

        public Builder withPreviousAllocationId(AllocationID previousAllocationId) {
            this.previousAllocationId = previousAllocationId;
            return this;
        }

        public Builder withTaskResourceProfile(ResourceProfile taskResourceProfile) {
            this.taskResourceProfile = taskResourceProfile;
            return this;
        }

        public Builder withPhysicalSlotResourceProfile(ResourceProfile physicalSlotResourceProfile) {
            this.physicalSlotResourceProfile = physicalSlotResourceProfile;
            return this;
        }

        public Builder withSlotSharingGroupId(SlotSharingGroupId slotSharingGroupId) {
            this.slotSharingGroupId = slotSharingGroupId;
            return this;
        }

        public Builder withCoLocationConstraint(CoLocationConstraint coLocationConstraint) {
            this.coLocationConstraint = coLocationConstraint;
            return this;
        }

        public Builder withPreferredLocations(Collection<TaskManagerLocation> preferredLocations) {
            this.preferredLocations = preferredLocations;
            return this;
        }

        public ExecutionVertexSchedulingRequirements build() {
            Preconditions.checkState((boolean)this.physicalSlotResourceProfile.isMatching(this.taskResourceProfile), (Object)"The physical slot resources must fulfill the task slot requirements");
            return new ExecutionVertexSchedulingRequirements(this.executionVertexId, this.previousAllocationId, this.taskResourceProfile, this.physicalSlotResourceProfile, this.slotSharingGroupId, this.coLocationConstraint, this.preferredLocations);
        }
    }
}

