/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.apache.flink.metrics.Counter;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateReader;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.io.network.buffer.BufferReceivedListener;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.IndexedInputGate;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.util.Preconditions;

public class InputGateWithMetrics
extends IndexedInputGate {
    private final IndexedInputGate inputGate;
    private final Counter numBytesIn;

    public InputGateWithMetrics(IndexedInputGate inputGate, Counter numBytesIn) {
        this.inputGate = (IndexedInputGate)Preconditions.checkNotNull((Object)inputGate);
        this.numBytesIn = (Counter)Preconditions.checkNotNull((Object)numBytesIn);
    }

    @Override
    public CompletableFuture<?> getAvailableFuture() {
        return this.inputGate.getAvailableFuture();
    }

    @Override
    public void resumeConsumption(int channelIndex) throws IOException {
        this.inputGate.resumeConsumption(channelIndex);
    }

    @Override
    public int getNumberOfInputChannels() {
        return this.inputGate.getNumberOfInputChannels();
    }

    @Override
    public InputChannel getChannel(int channelIndex) {
        return this.inputGate.getChannel(channelIndex);
    }

    @Override
    public int getGateIndex() {
        return this.inputGate.getGateIndex();
    }

    @Override
    public boolean isFinished() {
        return this.inputGate.isFinished();
    }

    @Override
    public void setup() throws IOException {
        this.inputGate.setup();
    }

    @Override
    public CompletableFuture<?> readRecoveredState(ExecutorService executor, ChannelStateReader reader) throws IOException {
        return this.inputGate.readRecoveredState(executor, reader);
    }

    @Override
    public void requestPartitions() throws IOException {
        this.inputGate.requestPartitions();
    }

    @Override
    public Optional<BufferOrEvent> getNext() throws IOException, InterruptedException {
        return this.inputGate.getNext().map(this::updateMetrics);
    }

    @Override
    public Optional<BufferOrEvent> pollNext() throws IOException, InterruptedException {
        return this.inputGate.pollNext().map(this::updateMetrics);
    }

    @Override
    public void sendTaskEvent(TaskEvent event) throws IOException {
        this.inputGate.sendTaskEvent(event);
    }

    @Override
    public void close() throws Exception {
        this.inputGate.close();
    }

    @Override
    public void registerBufferReceivedListener(BufferReceivedListener listener) {
        this.inputGate.registerBufferReceivedListener(listener);
    }

    private BufferOrEvent updateMetrics(BufferOrEvent bufferOrEvent) {
        this.numBytesIn.inc((long)bufferOrEvent.getSize());
        return bufferOrEvent;
    }
}

