/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover;

import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.executiongraph.failover.FailoverStrategy;
import org.apache.flink.runtime.executiongraph.failover.RestartAllStrategy;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;

public class FailoverStrategyLoader {
    public static final String FULL_RESTART_STRATEGY_NAME = "full";

    public static FailoverStrategy.Factory loadFailoverStrategy(Configuration config, @Nullable Logger logger) {
        String strategyParam = config.getString(JobManagerOptions.EXECUTION_FAILOVER_STRATEGY, FULL_RESTART_STRATEGY_NAME);
        if (StringUtils.isNullOrWhitespaceOnly((String)strategyParam)) {
            if (logger != null) {
                logger.warn("Null config value for {} ; using default failover strategy (full restarts).", (Object)JobManagerOptions.EXECUTION_FAILOVER_STRATEGY.key());
            }
            return new RestartAllStrategy.Factory();
        }
        switch (strategyParam.toLowerCase()) {
            case "full": {
                return new RestartAllStrategy.Factory();
            }
        }
        throw new IllegalConfigurationException("Unknown failover strategy: " + strategyParam);
    }
}

