/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.util.Preconditions;

public interface SortBuffer {
    public boolean append(ByteBuffer var1, int var2, Buffer.DataType var3) throws IOException;

    public BufferWithChannel copyIntoSegment(MemorySegment var1);

    public long numRecords();

    public long numBytes();

    public boolean hasRemaining();

    public void finish();

    public boolean isFinished();

    public void release();

    public boolean isReleased();

    public static class BufferWithChannel {
        private final Buffer buffer;
        private final int channelIndex;

        BufferWithChannel(Buffer buffer, int channelIndex) {
            this.buffer = (Buffer)Preconditions.checkNotNull((Object)buffer);
            this.channelIndex = channelIndex;
        }

        public Buffer getBuffer() {
            return this.buffer;
        }

        public int getChannelIndex() {
            return this.channelIndex;
        }
    }
}

