/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import javax.annotation.Nullable;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroup;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.Preconditions;

public class CoLocationConstraint {
    private final CoLocationGroup group;
    private volatile TaskManagerLocation lockedLocation;
    private volatile SlotRequestId slotRequestId;

    CoLocationConstraint(CoLocationGroup group) {
        Preconditions.checkNotNull((Object)group);
        this.group = group;
        this.slotRequestId = null;
    }

    public AbstractID getGroupId() {
        return this.group.getId();
    }

    public boolean isAssigned() {
        return this.lockedLocation != null;
    }

    public TaskManagerLocation getLocation() {
        if (this.lockedLocation != null) {
            return this.lockedLocation;
        }
        throw new IllegalStateException("Location not yet locked");
    }

    public void lockLocation(TaskManagerLocation taskManagerLocation) {
        Preconditions.checkNotNull((Object)taskManagerLocation);
        Preconditions.checkState((this.lockedLocation == null ? 1 : 0) != 0, (Object)"Location is already locked.");
        this.lockedLocation = taskManagerLocation;
    }

    public void setSlotRequestId(@Nullable SlotRequestId slotRequestId) {
        this.slotRequestId = slotRequestId;
    }

    @Nullable
    public SlotRequestId getSlotRequestId() {
        return this.slotRequestId;
    }

    public String toString() {
        return "CoLocationConstraint{group=" + this.group + ", lockedLocation=" + this.lockedLocation + ", slotRequestId=" + (Object)((Object)this.slotRequestId) + '}';
    }
}

