/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.TaskExecutionStateTransition;
import org.apache.flink.runtime.scheduler.InternalFailuresListener;
import org.apache.flink.runtime.scheduler.SchedulerNG;
import org.apache.flink.runtime.taskmanager.TaskExecutionState;
import org.apache.flink.util.Preconditions;

class UpdateSchedulerNgOnInternalFailuresListener
implements InternalFailuresListener {
    private final SchedulerNG schedulerNg;
    private final JobID jobId;

    public UpdateSchedulerNgOnInternalFailuresListener(SchedulerNG schedulerNg, JobID jobId) {
        this.schedulerNg = (SchedulerNG)Preconditions.checkNotNull((Object)schedulerNg);
        this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId);
    }

    @Override
    public void notifyTaskFailure(ExecutionAttemptID attemptId, Throwable t, boolean cancelTask, boolean releasePartitions) {
        TaskExecutionState state = new TaskExecutionState(this.jobId, attemptId, ExecutionState.FAILED, t);
        this.schedulerNg.updateTaskExecutionState(new TaskExecutionStateTransition(state, cancelTask, releasePartitions));
    }

    @Override
    public void notifyGlobalFailure(Throwable t) {
        this.schedulerNg.handleGlobalFailure(t);
    }
}

