/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.slots;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.util.Preconditions;

public class ResourceCounter {
    public static final ResourceCounter EMPTY = new ResourceCounter(Collections.emptyMap());
    private final Map<ResourceProfile, Integer> resources;

    public ResourceCounter() {
        this(new HashMap<ResourceProfile, Integer>());
    }

    public ResourceCounter(Map<ResourceProfile, Integer> resources) {
        this.resources = resources;
    }

    public void incrementCount(ResourceProfile profile, int increment) {
        Preconditions.checkArgument((increment > 0 ? 1 : 0) != 0);
        this.resources.compute(profile, (ignored, currentCount) -> currentCount == null ? increment : currentCount + increment);
    }

    public void decrementCount(ResourceProfile profile, int decrement) {
        Preconditions.checkArgument((decrement > 0 ? 1 : 0) != 0);
        this.resources.compute(profile, (p, currentCount) -> {
            Preconditions.checkState((currentCount != null ? 1 : 0) != 0, (String)"Attempting to decrement count of profile %s, but no count was present.", (Object[])new Object[]{p});
            return currentCount == decrement ? null : Integer.valueOf(ResourceCounter.guardAgainstNegativeCount(currentCount - decrement));
        });
    }

    private static int guardAgainstNegativeCount(int count) {
        if (count < 0) {
            throw new IllegalStateException("Count is negative.");
        }
        return count;
    }

    public Map<ResourceProfile, Integer> getResourceProfilesWithCount() {
        return Collections.unmodifiableMap(this.resources);
    }

    public Set<ResourceProfile> getResourceProfiles() {
        return this.resources.keySet();
    }

    public int getResourceCount(ResourceProfile profile) {
        return this.resources.getOrDefault(profile, 0);
    }

    public int getResourceCount() {
        return this.resources.isEmpty() ? 0 : this.resources.values().stream().reduce(0, Integer::sum);
    }

    public ResourceCounter copy() {
        return new ResourceCounter(new HashMap<ResourceProfile, Integer>(this.resources));
    }

    public boolean isEmpty() {
        return this.resources.isEmpty();
    }

    public void clear() {
        this.resources.clear();
    }
}

