/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.ArchivedExecutionConfig;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.AccumulatorHelper;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.accumulators.AccumulatorSnapshot;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.runtime.blob.BlobWriter;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinator;
import org.apache.flink.runtime.checkpoint.CheckpointFailureManager;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.CheckpointStatsSnapshot;
import org.apache.flink.runtime.checkpoint.CheckpointStatsTracker;
import org.apache.flink.runtime.checkpoint.CheckpointsCleaner;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.MasterTriggerRestoreHook;
import org.apache.flink.runtime.checkpoint.OperatorCoordinatorCheckpointContext;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.concurrent.ScheduledExecutorServiceAdapter;
import org.apache.flink.runtime.entrypoint.ClusterEntryPointExceptionUtils;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.execution.SuppressRestartsException;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AllVerticesIterator;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionDeploymentListener;
import org.apache.flink.runtime.executiongraph.ExecutionGraphException;
import org.apache.flink.runtime.executiongraph.ExecutionGraphResultPartitionAvailabilityChecker;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionStateUpdateListener;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.executiongraph.JobInformation;
import org.apache.flink.runtime.executiongraph.JobStatusListener;
import org.apache.flink.runtime.executiongraph.SchedulingUtils;
import org.apache.flink.runtime.executiongraph.SlotProviderStrategy;
import org.apache.flink.runtime.executiongraph.TaskExecutionStateTransition;
import org.apache.flink.runtime.executiongraph.failover.FailoverStrategy;
import org.apache.flink.runtime.executiongraph.failover.flip1.ResultPartitionAvailabilityChecker;
import org.apache.flink.runtime.executiongraph.failover.flip1.partitionrelease.PartitionReleaseStrategy;
import org.apache.flink.runtime.executiongraph.restart.ExecutionGraphRestartCallback;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.runtime.io.network.partition.JobMasterPartitionTracker;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.ScheduleMode;
import org.apache.flink.runtime.jobgraph.tasks.CheckpointCoordinatorConfiguration;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroup;
import org.apache.flink.runtime.jobmaster.slotpool.SlotProvider;
import org.apache.flink.runtime.query.KvStateLocationRegistry;
import org.apache.flink.runtime.scheduler.InternalFailuresListener;
import org.apache.flink.runtime.scheduler.adapter.DefaultExecutionTopology;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.SchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.SchedulingResultPartition;
import org.apache.flink.runtime.scheduler.strategy.SchedulingTopology;
import org.apache.flink.runtime.shuffle.ShuffleMaster;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.taskmanager.DispatcherThreadFactory;
import org.apache.flink.runtime.taskmanager.TaskExecutionState;
import org.apache.flink.types.Either;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.OptionalFailure;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedThrowable;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionGraph
implements AccessExecutionGraph {
    static final Logger LOG = LoggerFactory.getLogger(ExecutionGraph.class);
    private final JobInformation jobInformation;
    private final Either<SerializedValue<JobInformation>, PermanentBlobKey> jobInformationOrBlobKey;
    private final ScheduledExecutorService futureExecutor;
    private final Executor ioExecutor;
    @Nonnull
    private ComponentMainThreadExecutor jobMasterMainThreadExecutor;
    private boolean isStoppable = true;
    private final Map<JobVertexID, ExecutionJobVertex> tasks;
    private final List<ExecutionJobVertex> verticesInCreationOrder;
    private final Map<IntermediateDataSetID, IntermediateResult> intermediateResults;
    private final Map<ExecutionAttemptID, Execution> currentExecutions;
    private final List<JobStatusListener> jobStatusListeners;
    private final FailoverStrategy failoverStrategy;
    private final long[] stateTimestamps;
    private final Time rpcTimeout;
    private final Time allocationTimeout;
    private final RestartStrategy restartStrategy;
    private final SlotProviderStrategy slotProviderStrategy;
    private final ClassLoader userClassLoader;
    private final KvStateLocationRegistry kvStateLocationRegistry;
    private final BlobWriter blobWriter;
    private boolean legacyScheduling = true;
    private int numVerticesTotal;
    private final PartitionReleaseStrategy.Factory partitionReleaseStrategyFactory;
    private PartitionReleaseStrategy partitionReleaseStrategy;
    private DefaultExecutionTopology executionTopology;
    @Nullable
    private InternalFailuresListener internalTaskFailuresListener;
    private final Counter numberOfRestartsCounter = new SimpleCounter();
    private final ScheduleMode scheduleMode;
    private final int maxPriorAttemptsHistoryLength;
    private int verticesFinished;
    private volatile JobStatus state = JobStatus.CREATED;
    private final CompletableFuture<JobStatus> terminationFuture = new CompletableFuture();
    private long globalModVersion;
    private Throwable failureCause;
    private ErrorInfo failureInfo;
    private final JobMasterPartitionTracker partitionTracker;
    private final ResultPartitionAvailabilityChecker resultPartitionAvailabilityChecker;
    @Nullable
    private CompletableFuture<Void> schedulingFuture;
    @Nullable
    private CheckpointCoordinator checkpointCoordinator;
    @Nullable
    private ScheduledExecutorService checkpointCoordinatorTimer;
    private CheckpointStatsTracker checkpointStatsTracker;
    @Nullable
    private String stateBackendName;
    private String jsonPlan;
    private final ShuffleMaster<?> shuffleMaster;
    private final ExecutionDeploymentListener executionDeploymentListener;
    private final ExecutionStateUpdateListener executionStateUpdateListener;

    public ExecutionGraph(JobInformation jobInformation, ScheduledExecutorService futureExecutor, Executor ioExecutor, Time rpcTimeout, RestartStrategy restartStrategy, int maxPriorAttemptsHistoryLength, FailoverStrategy.Factory failoverStrategyFactory, SlotProvider slotProvider, ClassLoader userClassLoader, BlobWriter blobWriter, Time allocationTimeout, PartitionReleaseStrategy.Factory partitionReleaseStrategyFactory, ShuffleMaster<?> shuffleMaster, JobMasterPartitionTracker partitionTracker, ScheduleMode scheduleMode, ExecutionDeploymentListener executionDeploymentListener, ExecutionStateUpdateListener executionStateUpdateListener, long initializationTimestamp) throws IOException {
        this.jobInformation = (JobInformation)Preconditions.checkNotNull((Object)jobInformation);
        this.blobWriter = (BlobWriter)Preconditions.checkNotNull((Object)blobWriter);
        this.scheduleMode = (ScheduleMode)((Object)Preconditions.checkNotNull((Object)((Object)scheduleMode)));
        this.jobInformationOrBlobKey = BlobWriter.serializeAndTryOffload(jobInformation, jobInformation.getJobId(), blobWriter);
        this.futureExecutor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)futureExecutor);
        this.ioExecutor = (Executor)Preconditions.checkNotNull((Object)ioExecutor);
        this.slotProviderStrategy = SlotProviderStrategy.from(scheduleMode, slotProvider, allocationTimeout);
        this.userClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)userClassLoader, (String)"userClassLoader");
        this.tasks = new HashMap<JobVertexID, ExecutionJobVertex>(16);
        this.intermediateResults = new HashMap<IntermediateDataSetID, IntermediateResult>(16);
        this.verticesInCreationOrder = new ArrayList<ExecutionJobVertex>(16);
        this.currentExecutions = new HashMap<ExecutionAttemptID, Execution>(16);
        this.jobStatusListeners = new ArrayList<JobStatusListener>();
        this.stateTimestamps = new long[JobStatus.values().length];
        this.stateTimestamps[JobStatus.INITIALIZING.ordinal()] = initializationTimestamp;
        this.stateTimestamps[JobStatus.CREATED.ordinal()] = System.currentTimeMillis();
        this.rpcTimeout = (Time)Preconditions.checkNotNull((Object)rpcTimeout);
        this.allocationTimeout = (Time)Preconditions.checkNotNull((Object)allocationTimeout);
        this.partitionReleaseStrategyFactory = (PartitionReleaseStrategy.Factory)Preconditions.checkNotNull((Object)partitionReleaseStrategyFactory);
        this.restartStrategy = restartStrategy;
        this.kvStateLocationRegistry = new KvStateLocationRegistry(jobInformation.getJobId(), this.getAllVertices());
        this.globalModVersion = 1L;
        this.failoverStrategy = (FailoverStrategy)Preconditions.checkNotNull((Object)failoverStrategyFactory.create(this), (String)"null failover strategy");
        this.maxPriorAttemptsHistoryLength = maxPriorAttemptsHistoryLength;
        this.schedulingFuture = null;
        this.jobMasterMainThreadExecutor = new ComponentMainThreadExecutor.DummyComponentMainThreadExecutor("ExecutionGraph is not initialized with proper main thread executor. Call to ExecutionGraph.start(...) required.");
        this.shuffleMaster = (ShuffleMaster)Preconditions.checkNotNull(shuffleMaster);
        this.partitionTracker = (JobMasterPartitionTracker)Preconditions.checkNotNull((Object)partitionTracker);
        this.resultPartitionAvailabilityChecker = new ExecutionGraphResultPartitionAvailabilityChecker(this::createResultPartitionId, partitionTracker);
        this.executionDeploymentListener = executionDeploymentListener;
        this.executionStateUpdateListener = executionStateUpdateListener;
    }

    public void start(@Nonnull ComponentMainThreadExecutor jobMasterMainThreadExecutor) {
        this.jobMasterMainThreadExecutor = jobMasterMainThreadExecutor;
    }

    public int getNumberOfExecutionJobVertices() {
        return this.verticesInCreationOrder.size();
    }

    public SchedulingTopology getSchedulingTopology() {
        return this.executionTopology;
    }

    public ScheduleMode getScheduleMode() {
        return this.scheduleMode;
    }

    public Time getAllocationTimeout() {
        return this.allocationTimeout;
    }

    @Nonnull
    public ComponentMainThreadExecutor getJobMasterMainThreadExecutor() {
        return this.jobMasterMainThreadExecutor;
    }

    @Override
    public boolean isArchived() {
        return false;
    }

    @Override
    public Optional<String> getStateBackendName() {
        return Optional.ofNullable(this.stateBackendName);
    }

    public void enableCheckpointing(CheckpointCoordinatorConfiguration chkConfig, List<ExecutionJobVertex> verticesToTrigger, List<ExecutionJobVertex> verticesToWaitFor, List<ExecutionJobVertex> verticesToCommitTo, List<MasterTriggerRestoreHook<?>> masterHooks, CheckpointIDCounter checkpointIDCounter, CompletedCheckpointStore checkpointStore, StateBackend checkpointStateBackend, CheckpointStatsTracker statsTracker) {
        Preconditions.checkState((this.state == JobStatus.CREATED ? 1 : 0) != 0, (Object)"Job must be in CREATED state");
        Preconditions.checkState((this.checkpointCoordinator == null ? 1 : 0) != 0, (Object)"checkpointing already enabled");
        ExecutionVertex[] tasksToTrigger = this.collectExecutionVertices(verticesToTrigger);
        ExecutionVertex[] tasksToWaitFor = this.collectExecutionVertices(verticesToWaitFor);
        ExecutionVertex[] tasksToCommitTo = this.collectExecutionVertices(verticesToCommitTo);
        Collection<OperatorCoordinatorCheckpointContext> operatorCoordinators = this.buildOpCoordinatorCheckpointContexts();
        this.checkpointStatsTracker = (CheckpointStatsTracker)Preconditions.checkNotNull((Object)statsTracker, (String)"CheckpointStatsTracker");
        CheckpointFailureManager failureManager = new CheckpointFailureManager(chkConfig.getTolerableCheckpointFailureNumber(), new CheckpointFailureManager.FailJobCallback(){

            @Override
            public void failJob(Throwable cause) {
                ExecutionGraph.this.getJobMasterMainThreadExecutor().execute(() -> ExecutionGraph.this.failGlobal(cause));
            }

            @Override
            public void failJobDueToTaskFailure(Throwable cause, ExecutionAttemptID failingTask) {
                ExecutionGraph.this.getJobMasterMainThreadExecutor().execute(() -> ExecutionGraph.this.failGlobalIfExecutionIsStillRunning(cause, failingTask));
            }
        });
        Preconditions.checkState((this.checkpointCoordinatorTimer == null ? 1 : 0) != 0);
        this.checkpointCoordinatorTimer = Executors.newSingleThreadScheduledExecutor(new DispatcherThreadFactory(Thread.currentThread().getThreadGroup(), "Checkpoint Timer"));
        this.checkpointCoordinator = new CheckpointCoordinator(this.jobInformation.getJobId(), chkConfig, tasksToTrigger, tasksToWaitFor, tasksToCommitTo, operatorCoordinators, checkpointIDCounter, checkpointStore, checkpointStateBackend, this.ioExecutor, new CheckpointsCleaner(), new ScheduledExecutorServiceAdapter(this.checkpointCoordinatorTimer), SharedStateRegistry.DEFAULT_FACTORY, failureManager);
        for (MasterTriggerRestoreHook<?> hook : masterHooks) {
            if (this.checkpointCoordinator.addMasterHook(hook)) continue;
            LOG.warn("Trying to register multiple checkpoint hooks with the name: {}", (Object)hook.getIdentifier());
        }
        this.checkpointCoordinator.setCheckpointStatsTracker(this.checkpointStatsTracker);
        if (chkConfig.getCheckpointInterval() != Long.MAX_VALUE) {
            this.registerJobStatusListener(this.checkpointCoordinator.createActivatorDeactivator());
        }
        this.stateBackendName = checkpointStateBackend.getClass().getSimpleName();
    }

    @Nullable
    public CheckpointCoordinator getCheckpointCoordinator() {
        return this.checkpointCoordinator;
    }

    public KvStateLocationRegistry getKvStateLocationRegistry() {
        return this.kvStateLocationRegistry;
    }

    public RestartStrategy getRestartStrategy() {
        return this.restartStrategy;
    }

    @Override
    public CheckpointCoordinatorConfiguration getCheckpointCoordinatorConfiguration() {
        if (this.checkpointStatsTracker != null) {
            return this.checkpointStatsTracker.getJobCheckpointingConfiguration();
        }
        return null;
    }

    @Override
    public CheckpointStatsSnapshot getCheckpointStatsSnapshot() {
        if (this.checkpointStatsTracker != null) {
            return this.checkpointStatsTracker.createSnapshot();
        }
        return null;
    }

    private ExecutionVertex[] collectExecutionVertices(List<ExecutionJobVertex> jobVertices) {
        if (jobVertices.size() == 1) {
            ExecutionJobVertex jv = jobVertices.get(0);
            if (jv.getGraph() != this) {
                throw new IllegalArgumentException("Can only use ExecutionJobVertices of this ExecutionGraph");
            }
            return jv.getTaskVertices();
        }
        ArrayList<ExecutionVertex> all = new ArrayList<ExecutionVertex>();
        for (ExecutionJobVertex jv : jobVertices) {
            if (jv.getGraph() != this) {
                throw new IllegalArgumentException("Can only use ExecutionJobVertices of this ExecutionGraph");
            }
            all.addAll(Arrays.asList(jv.getTaskVertices()));
        }
        return all.toArray(new ExecutionVertex[all.size()]);
    }

    private Collection<OperatorCoordinatorCheckpointContext> buildOpCoordinatorCheckpointContexts() {
        ArrayList<OperatorCoordinatorCheckpointContext> contexts = new ArrayList<OperatorCoordinatorCheckpointContext>();
        for (ExecutionJobVertex vertex : this.verticesInCreationOrder) {
            contexts.addAll(vertex.getOperatorCoordinators());
        }
        contexts.trimToSize();
        return contexts;
    }

    public void setJsonPlan(String jsonPlan) {
        this.jsonPlan = jsonPlan;
    }

    @Override
    public String getJsonPlan() {
        return this.jsonPlan;
    }

    public SlotProviderStrategy getSlotProviderStrategy() {
        return this.slotProviderStrategy;
    }

    public Either<SerializedValue<JobInformation>, PermanentBlobKey> getJobInformationOrBlobKey() {
        return this.jobInformationOrBlobKey;
    }

    @Override
    public JobID getJobID() {
        return this.jobInformation.getJobId();
    }

    @Override
    public String getJobName() {
        return this.jobInformation.getJobName();
    }

    @Override
    public boolean isStoppable() {
        return this.isStoppable;
    }

    public Configuration getJobConfiguration() {
        return this.jobInformation.getJobConfiguration();
    }

    public ClassLoader getUserClassLoader() {
        return this.userClassLoader;
    }

    @Override
    public JobStatus getState() {
        return this.state;
    }

    public Throwable getFailureCause() {
        return this.failureCause;
    }

    @Override
    public ErrorInfo getFailureInfo() {
        return this.failureInfo;
    }

    public long getNumberOfRestarts() {
        return this.numberOfRestartsCounter.getCount();
    }

    @Override
    public ExecutionJobVertex getJobVertex(JobVertexID id) {
        return this.tasks.get(id);
    }

    public Map<JobVertexID, ExecutionJobVertex> getAllVertices() {
        return Collections.unmodifiableMap(this.tasks);
    }

    public Iterable<ExecutionJobVertex> getVerticesTopologically() {
        final int numElements = this.verticesInCreationOrder.size();
        return new Iterable<ExecutionJobVertex>(){

            @Override
            public Iterator<ExecutionJobVertex> iterator() {
                return new Iterator<ExecutionJobVertex>(){
                    private int pos = 0;

                    @Override
                    public boolean hasNext() {
                        return this.pos < numElements;
                    }

                    @Override
                    public ExecutionJobVertex next() {
                        if (this.hasNext()) {
                            return (ExecutionJobVertex)ExecutionGraph.this.verticesInCreationOrder.get(this.pos++);
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public int getTotalNumberOfVertices() {
        return this.numVerticesTotal;
    }

    public Map<IntermediateDataSetID, IntermediateResult> getAllIntermediateResults() {
        return Collections.unmodifiableMap(this.intermediateResults);
    }

    public Iterable<ExecutionVertex> getAllExecutionVertices() {
        return new Iterable<ExecutionVertex>(){

            @Override
            public Iterator<ExecutionVertex> iterator() {
                return new AllVerticesIterator(ExecutionGraph.this.getVerticesTopologically().iterator());
            }
        };
    }

    @Override
    public long getStatusTimestamp(JobStatus status) {
        return this.stateTimestamps[status.ordinal()];
    }

    public final BlobWriter getBlobWriter() {
        return this.blobWriter;
    }

    public Executor getFutureExecutor() {
        return this.futureExecutor;
    }

    public Map<String, OptionalFailure<Accumulator<?, ?>>> aggregateUserAccumulators() {
        HashMap userAccumulators = new HashMap();
        for (ExecutionVertex vertex : this.getAllExecutionVertices()) {
            Map<String, Accumulator<?, ?>> next = vertex.getCurrentExecutionAttempt().getUserAccumulators();
            if (next == null) continue;
            AccumulatorHelper.mergeInto(userAccumulators, next);
        }
        return userAccumulators;
    }

    @Override
    public Map<String, SerializedValue<OptionalFailure<Object>>> getAccumulatorsSerialized() {
        return this.aggregateUserAccumulators().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ExecutionGraph.serializeAccumulator((String)entry.getKey(), (OptionalFailure)entry.getValue())));
    }

    private static SerializedValue<OptionalFailure<Object>> serializeAccumulator(String name, OptionalFailure<Accumulator<?, ?>> accumulator) {
        try {
            if (accumulator.isFailure()) {
                return new SerializedValue((Object)OptionalFailure.ofFailure((Throwable)accumulator.getFailureCause()));
            }
            return new SerializedValue((Object)OptionalFailure.of((Object)((Accumulator)accumulator.getUnchecked()).getLocalValue()));
        }
        catch (IOException ioe) {
            LOG.error("Could not serialize accumulator " + name + '.', (Throwable)ioe);
            try {
                return new SerializedValue((Object)OptionalFailure.ofFailure((Throwable)ioe));
            }
            catch (IOException e) {
                throw new RuntimeException("It should never happen that we cannot serialize the accumulator serialization exception.", e);
            }
        }
    }

    @Override
    public StringifiedAccumulatorResult[] getAccumulatorResultsStringified() {
        Map<String, OptionalFailure<Accumulator<?, ?>>> accumulatorMap = this.aggregateUserAccumulators();
        return StringifiedAccumulatorResult.stringifyAccumulatorResults(accumulatorMap);
    }

    public void enableNgScheduling(InternalFailuresListener internalTaskFailuresListener) {
        Preconditions.checkNotNull((Object)internalTaskFailuresListener);
        Preconditions.checkState((this.internalTaskFailuresListener == null ? 1 : 0) != 0, (Object)"enableNgScheduling can be only called once");
        this.internalTaskFailuresListener = internalTaskFailuresListener;
        this.legacyScheduling = false;
    }

    public void attachJobGraph(List<JobVertex> topologiallySorted) throws JobException {
        this.assertRunningInJobMasterMainThread();
        LOG.debug("Attaching {} topologically sorted vertices to existing job graph with {} vertices and {} intermediate results.", new Object[]{topologiallySorted.size(), this.tasks.size(), this.intermediateResults.size()});
        ArrayList<ExecutionJobVertex> newExecJobVertices = new ArrayList<ExecutionJobVertex>(topologiallySorted.size());
        long createTimestamp = System.currentTimeMillis();
        for (JobVertex jobVertex : topologiallySorted) {
            if (jobVertex.isInputVertex() && !jobVertex.isStoppable()) {
                this.isStoppable = false;
            }
            ExecutionJobVertex ejv = new ExecutionJobVertex(this, jobVertex, 1, this.maxPriorAttemptsHistoryLength, this.rpcTimeout, this.globalModVersion, createTimestamp);
            ejv.connectToPredecessors(this.intermediateResults);
            ExecutionJobVertex previousTask = this.tasks.putIfAbsent(jobVertex.getID(), ejv);
            if (previousTask != null) {
                throw new JobException(String.format("Encountered two job vertices with ID %s : previous=[%s] / new=[%s]", jobVertex.getID(), ejv, previousTask));
            }
            for (IntermediateResult res : ejv.getProducedDataSets()) {
                IntermediateResult previousDataSet = this.intermediateResults.putIfAbsent(res.getId(), res);
                if (previousDataSet == null) continue;
                throw new JobException(String.format("Encountered two intermediate data set with ID %s : previous=[%s] / new=[%s]", res.getId(), res, previousDataSet));
            }
            this.verticesInCreationOrder.add(ejv);
            this.numVerticesTotal += ejv.getParallelism();
            newExecJobVertices.add(ejv);
        }
        this.executionTopology = DefaultExecutionTopology.fromExecutionGraph(this);
        this.failoverStrategy.notifyNewVertices(newExecJobVertices);
        this.partitionReleaseStrategy = this.partitionReleaseStrategyFactory.createInstance(this.getSchedulingTopology());
    }

    public boolean isLegacyScheduling() {
        return this.legacyScheduling;
    }

    public void transitionToRunning() {
        if (!this.transitionState(JobStatus.CREATED, JobStatus.RUNNING)) {
            throw new IllegalStateException("Job may only be scheduled from state " + JobStatus.CREATED);
        }
    }

    public void scheduleForExecution() throws JobException {
        this.assertRunningInJobMasterMainThread();
        if (this.isLegacyScheduling()) {
            LOG.info("Job recovers via failover strategy: {}", (Object)this.failoverStrategy.getStrategyName());
        }
        long currentGlobalModVersion = this.globalModVersion;
        if (this.transitionState(JobStatus.CREATED, JobStatus.RUNNING)) {
            CompletableFuture<Void> newSchedulingFuture = SchedulingUtils.schedule(this.scheduleMode, this.getAllExecutionVertices(), this);
            if (this.state == JobStatus.RUNNING && currentGlobalModVersion == this.globalModVersion) {
                this.schedulingFuture = newSchedulingFuture;
                newSchedulingFuture.whenComplete((ignored, throwable) -> {
                    Throwable strippedThrowable;
                    if (throwable != null && !((strippedThrowable = ExceptionUtils.stripCompletionException((Throwable)throwable)) instanceof CancellationException)) {
                        this.failGlobal(strippedThrowable);
                    }
                });
            } else {
                newSchedulingFuture.cancel(false);
            }
        } else {
            throw new IllegalStateException("Job may only be scheduled from state " + JobStatus.CREATED);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void cancel() {
        block2: {
            this.assertRunningInJobMasterMainThread();
            do lbl-1000:
            // 3 sources

            {
                block3: {
                    if ((current = this.state) != JobStatus.RUNNING && current != JobStatus.CREATED && current != JobStatus.RESTARTING) break block3;
                    if (!this.transitionState(current, JobStatus.CANCELLING)) ** GOTO lbl-1000
                    globalVersionForRestart = this.incrementGlobalModVersion();
                    ongoingSchedulingFuture = this.schedulingFuture;
                    if (ongoingSchedulingFuture != null) {
                        ongoingSchedulingFuture.cancel(false);
                    }
                    allTerminal = this.cancelVerticesAsync();
                    allTerminal.whenComplete((BiConsumer)(BiConsumer<Void, Throwable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$cancel$2(long java.lang.Void java.lang.Throwable ), (Ljava/lang/Void;Ljava/lang/Throwable;)V)((ExecutionGraph)this, (long)globalVersionForRestart));
                    return;
                }
                if (current != JobStatus.FAILING) break block2;
            } while (!this.transitionState(current, JobStatus.CANCELLING));
            return;
        }
    }

    private FutureUtils.ConjunctFuture<Void> cancelVerticesAsync() {
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>(this.verticesInCreationOrder.size());
        for (ExecutionJobVertex ejv : this.verticesInCreationOrder) {
            futures.add(ejv.cancelWithFuture());
        }
        return FutureUtils.waitForAll(futures);
    }

    public void suspend(Throwable suspensionCause) {
        ArrayList<CompletableFuture<Void>> executionJobVertexTerminationFutures;
        this.assertRunningInJobMasterMainThread();
        if (this.state.isTerminalState()) {
            return;
        }
        if (this.transitionState(this.state, JobStatus.SUSPENDED, suspensionCause)) {
            this.initFailureCause(suspensionCause);
            this.incrementGlobalModVersion();
            if (this.schedulingFuture != null) {
                this.schedulingFuture.cancel(false);
            }
            executionJobVertexTerminationFutures = new ArrayList<CompletableFuture<Void>>(this.verticesInCreationOrder.size());
            for (ExecutionJobVertex ejv : this.verticesInCreationOrder) {
                executionJobVertexTerminationFutures.add(ejv.suspend());
            }
        } else {
            throw new IllegalStateException(String.format("Could not suspend because transition from %s to %s failed.", this.state, JobStatus.SUSPENDED));
        }
        FutureUtils.ConjunctFuture<Void> jobVerticesTerminationFuture = FutureUtils.waitForAll(executionJobVertexTerminationFutures);
        Preconditions.checkState((boolean)jobVerticesTerminationFuture.isDone(), (Object)"Suspend needs to happen atomically");
        jobVerticesTerminationFuture.whenComplete((ignored, throwable) -> {
            if (throwable != null) {
                LOG.debug("Could not properly suspend the execution graph.", throwable);
            }
            this.onTerminalState(this.state);
            LOG.info("Job {} has been suspended.", (Object)this.getJobID());
        });
    }

    void failGlobalIfExecutionIsStillRunning(Throwable cause, ExecutionAttemptID failingAttempt) {
        Execution failedExecution = this.currentExecutions.get(failingAttempt);
        if (failedExecution != null && failedExecution.getState() == ExecutionState.RUNNING) {
            this.failGlobal(cause);
        } else {
            LOG.debug("The failing attempt {} belongs to an already not running task thus won't fail the job", (Object)failingAttempt);
        }
    }

    public void failGlobal(Throwable t) {
        JobStatus current;
        if (!this.isLegacyScheduling()) {
            this.internalTaskFailuresListener.notifyGlobalFailure(t);
            return;
        }
        this.assertRunningInJobMasterMainThread();
        do {
            if ((current = this.state) != JobStatus.FAILING && current != JobStatus.SUSPENDED && !current.isGloballyTerminalState()) continue;
            return;
        } while (!this.transitionState(current, JobStatus.FAILING, t));
        this.initFailureCause(t);
        long globalVersionForRestart = this.incrementGlobalModVersion();
        CompletableFuture<Void> ongoingSchedulingFuture = this.schedulingFuture;
        if (ongoingSchedulingFuture != null) {
            ongoingSchedulingFuture.cancel(false);
        }
        FutureUtils.ConjunctFuture<Void> allTerminal = this.cancelVerticesAsync();
        FutureUtils.assertNoException(allTerminal.handle((ignored, throwable) -> {
            if (throwable != null) {
                this.transitionState(JobStatus.FAILING, JobStatus.FAILED, new FlinkException("Could not cancel all execution job vertices properly.", throwable));
            } else {
                this.allVerticesInTerminalState(globalVersionForRestart);
            }
            return null;
        }));
    }

    public void restart(long expectedGlobalVersion) {
        this.assertRunningInJobMasterMainThread();
        try {
            if (this.globalModVersion != expectedGlobalVersion) {
                LOG.info("Concurrent full restart subsumed this restart.");
                return;
            }
            JobStatus current = this.state;
            if (current == JobStatus.CANCELED) {
                LOG.info("Canceled job during restart. Aborting restart.");
                return;
            }
            if (current == JobStatus.FAILED) {
                LOG.info("Failed job during restart. Aborting restart.");
                return;
            }
            if (current == JobStatus.SUSPENDED) {
                LOG.info("Suspended job during restart. Aborting restart.");
                return;
            }
            if (current != JobStatus.RESTARTING) {
                throw new IllegalStateException("Can only restart job from state restarting.");
            }
            this.currentExecutions.clear();
            HashSet<CoLocationGroup> colGroups = new HashSet<CoLocationGroup>();
            long resetTimestamp = System.currentTimeMillis();
            for (ExecutionJobVertex jv : this.verticesInCreationOrder) {
                CoLocationGroup cgroup = jv.getCoLocationGroup();
                if (cgroup != null && !colGroups.contains(cgroup)) {
                    cgroup.resetConstraints();
                    colGroups.add(cgroup);
                }
                jv.resetForNewExecution(resetTimestamp, expectedGlobalVersion);
            }
            for (int i = 0; i < this.stateTimestamps.length; ++i) {
                if (i == JobStatus.RESTARTING.ordinal()) continue;
                this.stateTimestamps[i] = 0L;
            }
            this.transitionState(JobStatus.RESTARTING, JobStatus.CREATED);
            if (this.checkpointCoordinator != null) {
                this.checkpointCoordinator.restoreLatestCheckpointedState(this.getAllVertices(), false, false);
            }
            this.scheduleForExecution();
        }
        catch (Throwable t) {
            LOG.warn("Failed to restart the job.", t);
            this.failGlobal(t);
        }
    }

    @Override
    public ArchivedExecutionConfig getArchivedExecutionConfig() {
        try {
            ExecutionConfig executionConfig = (ExecutionConfig)this.jobInformation.getSerializedExecutionConfig().deserializeValue(this.userClassLoader);
            if (executionConfig != null) {
                return executionConfig.archive();
            }
        }
        catch (IOException | ClassNotFoundException e) {
            LOG.error("Couldn't create ArchivedExecutionConfig for job {} ", (Object)this.getJobID(), (Object)e);
        }
        return null;
    }

    public CompletableFuture<JobStatus> getTerminationFuture() {
        return this.terminationFuture;
    }

    @VisibleForTesting
    public JobStatus waitUntilTerminal() throws InterruptedException {
        try {
            return this.terminationFuture.get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public FailoverStrategy getFailoverStrategy() {
        return this.failoverStrategy;
    }

    public long getGlobalModVersion() {
        return this.globalModVersion;
    }

    public boolean transitionState(JobStatus current, JobStatus newState) {
        return this.transitionState(current, newState, null);
    }

    private void transitionState(JobStatus newState, Throwable error) {
        this.transitionState(this.state, newState, error);
    }

    private boolean transitionState(JobStatus current, JobStatus newState, Throwable error) {
        this.assertRunningInJobMasterMainThread();
        if (current.isTerminalState()) {
            String message = "Job is trying to leave terminal state " + current;
            LOG.error(message);
            throw new IllegalStateException(message);
        }
        if (this.state == current) {
            this.state = newState;
            LOG.info("Job {} ({}) switched from state {} to {}.", new Object[]{this.getJobName(), this.getJobID(), current, newState, error});
            this.stateTimestamps[newState.ordinal()] = System.currentTimeMillis();
            this.notifyJobStatusChange(newState, error);
            return true;
        }
        return false;
    }

    private long incrementGlobalModVersion() {
        this.incrementRestarts();
        return ++this.globalModVersion;
    }

    public void incrementRestarts() {
        this.numberOfRestartsCounter.inc();
    }

    public void initFailureCause(Throwable t) {
        this.failureCause = t;
        this.failureInfo = new ErrorInfo(t, System.currentTimeMillis());
    }

    void vertexFinished() {
        this.assertRunningInJobMasterMainThread();
        int numFinished = ++this.verticesFinished;
        if (numFinished == this.numVerticesTotal && this.state == JobStatus.RUNNING) {
            try {
                for (ExecutionJobVertex ejv : this.verticesInCreationOrder) {
                    ejv.getJobVertex().finalizeOnMaster(this.getUserClassLoader());
                }
            }
            catch (Throwable t) {
                ExceptionUtils.rethrowIfFatalError((Throwable)t);
                ClusterEntryPointExceptionUtils.tryEnrichClusterEntryPointError(t);
                this.failGlobal(new Exception("Failed to finalize execution on master", t));
                return;
            }
            if (this.transitionState(JobStatus.RUNNING, JobStatus.FINISHED)) {
                this.onTerminalState(JobStatus.FINISHED);
            }
        }
    }

    void vertexUnFinished() {
        this.assertRunningInJobMasterMainThread();
        --this.verticesFinished;
    }

    private void allVerticesInTerminalState(long expectedGlobalVersionForRestart) {
        block5: {
            JobStatus current;
            block6: {
                this.assertRunningInJobMasterMainThread();
                while (true) {
                    if ((current = this.state) == JobStatus.RUNNING) {
                        this.failGlobal(new Exception("ExecutionGraph went into allVerticesInTerminalState() from RUNNING"));
                        continue;
                    }
                    if (current == JobStatus.CANCELLING) {
                        if (!this.transitionState(current, JobStatus.CANCELED)) continue;
                        this.onTerminalState(JobStatus.CANCELED);
                        break block5;
                    }
                    if (current != JobStatus.FAILING) break block6;
                    if (this.tryRestartOrFail(expectedGlobalVersionForRestart)) break;
                }
                break block5;
            }
            if (current.isGloballyTerminalState()) {
                LOG.warn("Job has entered globally terminal state without waiting for all job vertices to reach final state.");
            } else {
                this.failGlobal(new Exception("ExecutionGraph went into final state from state " + current));
            }
        }
    }

    @Deprecated
    private boolean tryRestartOrFail(long globalModVersionForRestart) {
        if (!this.isLegacyScheduling()) {
            return true;
        }
        JobStatus currentState = this.state;
        if (currentState == JobStatus.FAILING || currentState == JobStatus.RESTARTING) {
            boolean isRestartable;
            Throwable failureCause = this.failureCause;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Try to restart or fail the job {} ({}) if no longer possible.", new Object[]{this.getJobName(), this.getJobID(), failureCause});
            } else {
                LOG.info("Try to restart or fail the job {} ({}) if no longer possible.", (Object)this.getJobName(), (Object)this.getJobID());
            }
            boolean isFailureCauseAllowingRestart = !(failureCause instanceof SuppressRestartsException);
            boolean isRestartStrategyAllowingRestart = this.restartStrategy.canRestart();
            boolean bl = isRestartable = isFailureCauseAllowingRestart && isRestartStrategyAllowingRestart;
            if (isRestartable && this.transitionState(currentState, JobStatus.RESTARTING)) {
                LOG.info("Restarting the job {} ({}).", (Object)this.getJobName(), (Object)this.getJobID());
                ExecutionGraphRestartCallback restarter = new ExecutionGraphRestartCallback(this, globalModVersionForRestart);
                FutureUtils.assertNoException(this.restartStrategy.restart(restarter, this.getJobMasterMainThreadExecutor()).exceptionally(throwable -> {
                    this.failGlobal((Throwable)throwable);
                    return null;
                }));
                return true;
            }
            if (!isRestartable && this.transitionState(currentState, JobStatus.FAILED, failureCause)) {
                String cause1 = isFailureCauseAllowingRestart ? null : "a type of SuppressRestartsException was thrown";
                String cause2 = isRestartStrategyAllowingRestart ? null : "the restart strategy prevented it";
                LOG.info("Could not restart the job {} ({}) because {}.", new Object[]{this.getJobName(), this.getJobID(), StringUtils.concatenateWithAnd((String)cause1, (String)cause2), failureCause});
                this.onTerminalState(JobStatus.FAILED);
                return true;
            }
            return false;
        }
        return false;
    }

    public void failJob(Throwable cause) {
        if (this.state == JobStatus.FAILING || this.state.isTerminalState()) {
            return;
        }
        this.transitionState(JobStatus.FAILING, cause);
        this.initFailureCause(cause);
        FutureUtils.assertNoException(this.cancelVerticesAsync().whenComplete((aVoid, throwable) -> {
            if (this.transitionState(JobStatus.FAILING, JobStatus.FAILED, cause)) {
                this.onTerminalState(JobStatus.FAILED);
            } else if (this.state == JobStatus.CANCELLING) {
                this.transitionState(JobStatus.CANCELLING, JobStatus.CANCELED);
                this.onTerminalState(JobStatus.CANCELED);
            } else if (!this.state.isTerminalState()) {
                throw new IllegalStateException("Cannot complete job failing from an unexpected state: " + this.state);
            }
        }));
    }

    private void onTerminalState(JobStatus status) {
        try {
            CheckpointCoordinator coord = this.checkpointCoordinator;
            this.checkpointCoordinator = null;
            if (coord != null) {
                coord.shutdown(status);
            }
            if (this.checkpointCoordinatorTimer != null) {
                this.checkpointCoordinatorTimer.shutdownNow();
                this.checkpointCoordinatorTimer = null;
            }
        }
        catch (Exception e) {
            LOG.error("Error while cleaning up after execution", (Throwable)e);
        }
        finally {
            this.terminationFuture.complete(status);
        }
    }

    @Deprecated
    @VisibleForTesting
    public boolean updateState(TaskExecutionState state) {
        return this.updateState(new TaskExecutionStateTransition(state));
    }

    public boolean updateState(TaskExecutionStateTransition state) {
        this.assertRunningInJobMasterMainThread();
        Execution attempt = this.currentExecutions.get(state.getID());
        if (attempt != null) {
            try {
                boolean stateUpdated = this.updateStateInternal(state, attempt);
                this.maybeReleasePartitions(attempt);
                return stateUpdated;
            }
            catch (Throwable t) {
                ExceptionUtils.rethrowIfFatalErrorOrOOM((Throwable)t);
                this.failGlobal(t);
                return false;
            }
        }
        return false;
    }

    private boolean updateStateInternal(TaskExecutionStateTransition state, Execution attempt) {
        switch (state.getExecutionState()) {
            case RUNNING: {
                return attempt.switchToRunning();
            }
            case FINISHED: {
                Map<String, Accumulator<?, ?>> accumulators = this.deserializeAccumulators(state);
                attempt.markFinished(accumulators, state.getIOMetrics());
                return true;
            }
            case CANCELED: {
                Map<String, Accumulator<?, ?>> accumulators = this.deserializeAccumulators(state);
                attempt.completeCancelling(accumulators, state.getIOMetrics(), false);
                return true;
            }
            case FAILED: {
                Map<String, Accumulator<?, ?>> accumulators = this.deserializeAccumulators(state);
                attempt.markFailed(state.getError(this.userClassLoader), state.getCancelTask(), accumulators, state.getIOMetrics(), state.getReleasePartitions(), !this.isLegacyScheduling());
                return true;
            }
        }
        attempt.fail(new Exception("TaskManager sent illegal state update: " + (Object)((Object)state.getExecutionState())));
        return false;
    }

    private void maybeReleasePartitions(Execution attempt) {
        ExecutionVertexID finishedExecutionVertex = attempt.getVertex().getID();
        if (attempt.getState() == ExecutionState.FINISHED) {
            List<IntermediateResultPartitionID> releasablePartitions = this.partitionReleaseStrategy.vertexFinished(finishedExecutionVertex);
            this.releasePartitions(releasablePartitions);
        } else {
            this.partitionReleaseStrategy.vertexUnfinished(finishedExecutionVertex);
        }
    }

    private void releasePartitions(List<IntermediateResultPartitionID> releasablePartitions) {
        if (releasablePartitions.size() > 0) {
            List<ResultPartitionID> partitionIds = releasablePartitions.stream().map(this::createResultPartitionId).collect(Collectors.toList());
            this.partitionTracker.stopTrackingAndReleasePartitions(partitionIds);
        }
    }

    ResultPartitionID createResultPartitionId(IntermediateResultPartitionID resultPartitionId) {
        SchedulingResultPartition schedulingResultPartition = this.getSchedulingTopology().getResultPartition(resultPartitionId);
        SchedulingExecutionVertex producer = (SchedulingExecutionVertex)schedulingResultPartition.getProducer();
        ExecutionVertexID producerId = (ExecutionVertexID)producer.getId();
        JobVertexID jobVertexId = producerId.getJobVertexId();
        ExecutionJobVertex jobVertex = this.getJobVertex(jobVertexId);
        Preconditions.checkNotNull((Object)jobVertex, (String)"Unknown job vertex %s", (Object[])new Object[]{jobVertexId});
        ExecutionVertex[] taskVertices = jobVertex.getTaskVertices();
        int subtaskIndex = producerId.getSubtaskIndex();
        Preconditions.checkState((subtaskIndex < taskVertices.length ? 1 : 0) != 0, (String)"Invalid subtask index %d for job vertex %s", (Object[])new Object[]{subtaskIndex, jobVertexId});
        ExecutionVertex taskVertex = taskVertices[subtaskIndex];
        Execution execution = taskVertex.getCurrentExecutionAttempt();
        return new ResultPartitionID(resultPartitionId, execution.getAttemptId());
    }

    private Map<String, Accumulator<?, ?>> deserializeAccumulators(TaskExecutionStateTransition state) {
        AccumulatorSnapshot serializedAccumulators = state.getAccumulators();
        if (serializedAccumulators != null) {
            try {
                return serializedAccumulators.deserializeUserAccumulators(this.userClassLoader);
            }
            catch (Throwable t) {
                LOG.error("Failed to deserialize final accumulator results.", t);
            }
        }
        return null;
    }

    public void scheduleOrUpdateConsumers(ResultPartitionID partitionId) throws ExecutionGraphException {
        this.assertRunningInJobMasterMainThread();
        Execution execution = this.currentExecutions.get(partitionId.getProducerId());
        if (execution == null) {
            throw new ExecutionGraphException("Cannot find execution for execution Id " + partitionId.getPartitionId() + '.');
        }
        if (execution.getVertex() == null) {
            throw new ExecutionGraphException("Execution with execution Id " + partitionId.getPartitionId() + " has no vertex assigned.");
        }
        execution.getVertex().scheduleOrUpdateConsumers(partitionId);
    }

    public Map<ExecutionAttemptID, Execution> getRegisteredExecutions() {
        return Collections.unmodifiableMap(this.currentExecutions);
    }

    void registerExecution(Execution exec) {
        this.assertRunningInJobMasterMainThread();
        Execution previous = this.currentExecutions.putIfAbsent(exec.getAttemptId(), exec);
        if (previous != null) {
            this.failGlobal(new Exception("Trying to register execution " + exec + " for already used ID " + exec.getAttemptId()));
        }
    }

    void deregisterExecution(Execution exec) {
        this.assertRunningInJobMasterMainThread();
        Execution contained = this.currentExecutions.remove(exec.getAttemptId());
        if (contained != null && contained != exec) {
            this.failGlobal(new Exception("De-registering execution " + exec + " failed. Found for same ID execution " + contained));
        }
    }

    public void updateAccumulators(AccumulatorSnapshot accumulatorSnapshot) {
        try {
            Map<String, Accumulator<?, ?>> userAccumulators = accumulatorSnapshot.deserializeUserAccumulators(this.userClassLoader);
            ExecutionAttemptID execID = accumulatorSnapshot.getExecutionAttemptID();
            Execution execution = this.currentExecutions.get(execID);
            if (execution != null) {
                execution.setAccumulators(userAccumulators);
            } else {
                LOG.debug("Received accumulator result for unknown execution {}.", (Object)execID);
            }
        }
        catch (Exception e) {
            LOG.error("Cannot update accumulators for job {}.", (Object)this.getJobID(), (Object)e);
        }
    }

    public void registerJobStatusListener(JobStatusListener listener) {
        if (listener != null) {
            this.jobStatusListeners.add(listener);
        }
    }

    private void notifyJobStatusChange(JobStatus newState, Throwable error) {
        if (this.jobStatusListeners.size() > 0) {
            long timestamp = System.currentTimeMillis();
            SerializedThrowable serializedError = error == null ? null : new SerializedThrowable(error);
            for (JobStatusListener listener : this.jobStatusListeners) {
                try {
                    listener.jobStatusChanges(this.getJobID(), newState, timestamp, (Throwable)serializedError);
                }
                catch (Throwable t) {
                    LOG.warn("Error while notifying JobStatusListener", t);
                }
            }
        }
    }

    void notifyExecutionChange(Execution execution, ExecutionState newExecutionState, Throwable error) {
        this.executionStateUpdateListener.onStateUpdate(execution.getAttemptId(), newExecutionState);
        if (!this.isLegacyScheduling()) {
            return;
        }
        if (newExecutionState == ExecutionState.FAILED) {
            Throwable ex;
            Throwable throwable = ex = error != null ? error : new FlinkException("Unknown Error (missing cause)");
            if (execution.getGlobalModVersion() == this.globalModVersion) {
                try {
                    if (this.checkpointCoordinator != null) {
                        this.checkpointCoordinator.failUnacknowledgedPendingCheckpointsFor(execution.getAttemptId(), ex);
                    }
                    this.failoverStrategy.onTaskFailure(execution, ex);
                }
                catch (Throwable t) {
                    LOG.warn("Error in failover strategy - falling back to global restart", t);
                    this.failGlobal(ex);
                }
            }
        }
    }

    void assertRunningInJobMasterMainThread() {
        if (!(this.jobMasterMainThreadExecutor instanceof ComponentMainThreadExecutor.DummyComponentMainThreadExecutor)) {
            this.jobMasterMainThreadExecutor.assertRunningInMainThread();
        }
    }

    void notifySchedulerNgAboutInternalTaskFailure(ExecutionAttemptID attemptId, Throwable t, boolean cancelTask, boolean releasePartitions) {
        if (this.internalTaskFailuresListener != null) {
            this.internalTaskFailuresListener.notifyTaskFailure(attemptId, t, cancelTask, releasePartitions);
        }
    }

    ShuffleMaster<?> getShuffleMaster() {
        return this.shuffleMaster;
    }

    public JobMasterPartitionTracker getPartitionTracker() {
        return this.partitionTracker;
    }

    public ResultPartitionAvailabilityChecker getResultPartitionAvailabilityChecker() {
        return this.resultPartitionAvailabilityChecker;
    }

    PartitionReleaseStrategy getPartitionReleaseStrategy() {
        return this.partitionReleaseStrategy;
    }

    ExecutionDeploymentListener getExecutionDeploymentListener() {
        return this.executionDeploymentListener;
    }

    private /* synthetic */ void lambda$cancel$2(long globalVersionForRestart, Void value, Throwable throwable) {
        if (throwable != null) {
            this.transitionState(JobStatus.CANCELLING, JobStatus.FAILED, new FlinkException("Could not cancel job " + this.getJobName() + " because not all execution job vertices could be cancelled.", throwable));
        } else {
            this.allVerticesInTerminalState(globalVersionForRestart);
        }
    }
}

