/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.Preconditions;

@NotThreadSafe
final class ChannelStatePersister {
    private final InputChannelInfo channelInfo;
    private CheckpointStatus checkpointStatus = CheckpointStatus.COMPLETED;
    private long lastSeenBarrier = -1L;
    private final ChannelStateWriter channelStateWriter;

    ChannelStatePersister(ChannelStateWriter channelStateWriter, InputChannelInfo channelInfo) {
        this.channelStateWriter = (ChannelStateWriter)Preconditions.checkNotNull((Object)channelStateWriter);
        this.channelInfo = (InputChannelInfo)Preconditions.checkNotNull((Object)channelInfo);
    }

    protected void startPersisting(long barrierId, List<Buffer> knownBuffers) {
        if (this.checkpointStatus != CheckpointStatus.BARRIER_RECEIVED && this.lastSeenBarrier < barrierId) {
            this.checkpointStatus = CheckpointStatus.BARRIER_PENDING;
            this.lastSeenBarrier = barrierId;
        }
        if (knownBuffers.size() > 0) {
            this.channelStateWriter.addInputData(barrierId, this.channelInfo, -2, (CloseableIterator<Buffer>)CloseableIterator.fromList(knownBuffers, Buffer::recycleBuffer));
        }
    }

    protected void stopPersisting(long id) {
        if (id >= this.lastSeenBarrier) {
            this.checkpointStatus = CheckpointStatus.COMPLETED;
            this.lastSeenBarrier = id;
        }
    }

    protected void maybePersist(Buffer buffer) {
        if (this.checkpointStatus == CheckpointStatus.BARRIER_PENDING && buffer.isBuffer()) {
            this.channelStateWriter.addInputData(this.lastSeenBarrier, this.channelInfo, -2, (CloseableIterator<Buffer>)CloseableIterator.ofElement((Object)buffer.retainBuffer(), Buffer::recycleBuffer));
        }
    }

    protected Optional<Long> checkForBarrier(Buffer buffer) throws IOException {
        AbstractEvent priorityEvent = this.parsePriorityEvent(buffer);
        if (priorityEvent instanceof CheckpointBarrier && ((CheckpointBarrier)priorityEvent).getId() >= this.lastSeenBarrier) {
            this.checkpointStatus = CheckpointStatus.BARRIER_RECEIVED;
            this.lastSeenBarrier = ((CheckpointBarrier)priorityEvent).getId();
            return Optional.of(this.lastSeenBarrier);
        }
        return Optional.empty();
    }

    @Nullable
    protected AbstractEvent parsePriorityEvent(Buffer buffer) throws IOException {
        if (buffer.isBuffer() || !buffer.getDataType().hasPriority()) {
            return null;
        }
        AbstractEvent event = EventSerializer.fromBuffer(buffer, this.getClass().getClassLoader());
        buffer.setReaderIndex(0);
        return event;
    }

    protected boolean hasBarrierReceived() {
        return this.checkpointStatus == CheckpointStatus.BARRIER_RECEIVED;
    }

    private static enum CheckpointStatus {
        COMPLETED,
        BARRIER_PENDING,
        BARRIER_RECEIVED;

    }
}

