/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.RunningJobsRegistry;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmanager.OnCompletionActions;
import org.apache.flink.runtime.jobmaster.JobManagerRunner;
import org.apache.flink.runtime.jobmaster.JobMasterGateway;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.jobmaster.JobMasterService;
import org.apache.flink.runtime.jobmaster.JobNotFinishedException;
import org.apache.flink.runtime.jobmaster.factories.JobMasterServiceFactory;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobManagerRunnerImpl
implements LeaderContender,
OnCompletionActions,
JobManagerRunner {
    private static final Logger log = LoggerFactory.getLogger(JobManagerRunnerImpl.class);
    private final Object lock = new Object();
    private final JobGraph jobGraph;
    private final RunningJobsRegistry runningJobsRegistry;
    private final LeaderElectionService leaderElectionService;
    private final LibraryCacheManager.ClassLoaderLease classLoaderLease;
    private final Executor executor;
    private final JobMasterService jobMasterService;
    private final FatalErrorHandler fatalErrorHandler;
    private final CompletableFuture<ArchivedExecutionGraph> resultFuture = new CompletableFuture();
    private final CompletableFuture<Void> terminationFuture = new CompletableFuture();
    private final CompletableFuture<Void> jobMasterCreationFuture;
    private CompletableFuture<Void> leadershipOperation = CompletableFuture.completedFuture(null);
    private volatile boolean shutdown;
    private volatile CompletableFuture<JobMasterGateway> leaderGatewayFuture;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobManagerRunnerImpl(JobGraph jobGraph, JobMasterServiceFactory jobMasterFactory, HighAvailabilityServices haServices, LibraryCacheManager.ClassLoaderLease classLoaderLease, Executor executor, FatalErrorHandler fatalErrorHandler, long initializationTimestamp) throws Exception {
        ClassLoader userCodeLoader;
        this.jobGraph = (JobGraph)Preconditions.checkNotNull((Object)jobGraph);
        this.classLoaderLease = (LibraryCacheManager.ClassLoaderLease)Preconditions.checkNotNull((Object)classLoaderLease);
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.fatalErrorHandler = (FatalErrorHandler)Preconditions.checkNotNull((Object)fatalErrorHandler);
        Preconditions.checkArgument((jobGraph.getNumberOfVertices() > 0 ? 1 : 0) != 0, (Object)"The given job is empty");
        try {
            userCodeLoader = classLoaderLease.getOrResolveClassLoader(jobGraph.getUserJarBlobKeys(), jobGraph.getClasspaths()).asClassLoader();
        }
        catch (IOException e) {
            throw new Exception("Cannot set up the user code libraries: " + e.getMessage(), e);
        }
        this.runningJobsRegistry = haServices.getRunningJobsRegistry();
        this.leaderElectionService = haServices.getJobManagerLeaderElectionService(jobGraph.getJobID());
        this.leaderGatewayFuture = new CompletableFuture();
        this.jobMasterCreationFuture = new CompletableFuture();
        Object object = this.lock;
        synchronized (object) {
            try {
                this.leaderElectionService.start(this);
            }
            catch (Exception e) {
                log.error("Could not start the JobManager because the leader election service did not start.", (Throwable)e);
                throw new Exception("Could not start the leader election service.", e);
            }
            this.jobMasterService = jobMasterFactory.createJobMasterService(jobGraph, this, userCodeLoader, initializationTimestamp);
            this.jobMasterCreationFuture.complete(null);
        }
    }

    @Override
    public CompletableFuture<JobMasterGateway> getJobMasterGateway() {
        return this.leaderGatewayFuture;
    }

    @Override
    public CompletableFuture<ArchivedExecutionGraph> getResultFuture() {
        return this.resultFuture;
    }

    @Override
    public JobID getJobID() {
        return this.jobGraph.getJobID();
    }

    @Override
    public void start() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> closeAsync() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.shutdown) {
                this.shutdown = true;
                this.setNewLeaderGatewayFuture();
                this.leaderGatewayFuture.completeExceptionally((Throwable)new FlinkException("JobMaster has been shut down."));
                CompletableFuture jobManagerTerminationFuture = this.jobMasterService.closeAsync();
                jobManagerTerminationFuture.whenComplete((ignored, throwable) -> {
                    try {
                        this.leaderElectionService.stop();
                    }
                    catch (Throwable t) {
                        throwable = ExceptionUtils.firstOrSuppressed((Throwable)t, (Throwable)ExceptionUtils.stripCompletionException((Throwable)throwable));
                    }
                    this.classLoaderLease.release();
                    this.resultFuture.completeExceptionally((Throwable)((Object)new JobNotFinishedException(this.jobGraph.getJobID())));
                    if (throwable != null) {
                        this.terminationFuture.completeExceptionally((Throwable)new FlinkException("Could not properly shut down the JobManagerRunner", throwable));
                    } else {
                        this.terminationFuture.complete(null);
                    }
                });
            }
            return this.terminationFuture;
        }
    }

    @Override
    public void jobReachedGloballyTerminalState(ArchivedExecutionGraph executionGraph) {
        this.unregisterJobFromHighAvailability();
        this.resultFuture.complete(executionGraph);
    }

    @Override
    public void jobFinishedByOther() {
        this.resultFuture.completeExceptionally((Throwable)((Object)new JobNotFinishedException(this.jobGraph.getJobID())));
    }

    @Override
    public void jobMasterFailed(Throwable cause) {
        this.handleJobManagerRunnerError(cause);
    }

    private void handleJobManagerRunnerError(Throwable cause) {
        if (ExceptionUtils.isJvmFatalError((Throwable)cause)) {
            this.fatalErrorHandler.onFatalError(cause);
        } else {
            this.resultFuture.completeExceptionally(cause);
        }
    }

    private void unregisterJobFromHighAvailability() {
        try {
            this.runningJobsRegistry.setJobFinished(this.jobGraph.getJobID());
        }
        catch (Throwable t) {
            log.error("Could not un-register from high-availability services job {} ({}).Other JobManager's may attempt to recover it and re-execute it.", new Object[]{this.jobGraph.getName(), this.jobGraph.getJobID(), t});
        }
    }

    @Override
    public void grantLeadership(UUID leaderSessionID) {
        this.jobMasterCreationFuture.whenComplete((ignore, throwable) -> {
            if (throwable != null) {
                this.handleJobManagerRunnerError((Throwable)new FlinkException(throwable));
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.shutdown) {
                    log.debug("JobManagerRunner cannot be granted leadership because it is already shut down.");
                    return;
                }
                this.leadershipOperation = this.leadershipOperation.thenCompose(ignored -> {
                    Object object = this.lock;
                    synchronized (object) {
                        return this.verifyJobSchedulingStatusAndStartJobManager(leaderSessionID);
                    }
                });
                this.handleException(this.leadershipOperation, "Could not start the job manager.");
            }
        });
    }

    private CompletableFuture<Void> verifyJobSchedulingStatusAndStartJobManager(UUID leaderSessionId) {
        CompletableFuture<RunningJobsRegistry.JobSchedulingStatus> jobSchedulingStatusFuture = this.getJobSchedulingStatus();
        return jobSchedulingStatusFuture.thenCompose(jobSchedulingStatus -> {
            if (jobSchedulingStatus == RunningJobsRegistry.JobSchedulingStatus.DONE) {
                return this.jobAlreadyDone();
            }
            return this.startJobMaster(leaderSessionId);
        });
    }

    private CompletionStage<Void> startJobMaster(UUID leaderSessionId) {
        CompletableFuture<Acknowledge> startFuture;
        log.info("JobManager runner for job {} ({}) was granted leadership with session id {} at {}.", new Object[]{this.jobGraph.getName(), this.jobGraph.getJobID(), leaderSessionId, this.jobMasterService.getAddress()});
        try {
            this.runningJobsRegistry.setJobRunning(this.jobGraph.getJobID());
        }
        catch (IOException e) {
            return FutureUtils.completedExceptionally((Throwable)new FlinkException(String.format("Failed to set the job %s to running in the running jobs registry.", this.jobGraph.getJobID()), (Throwable)e));
        }
        try {
            startFuture = this.jobMasterService.start(new JobMasterId(leaderSessionId));
        }
        catch (Exception e) {
            return FutureUtils.completedExceptionally((Throwable)new FlinkException("Failed to start the JobMaster.", (Throwable)e));
        }
        CompletableFuture<JobMasterGateway> currentLeaderGatewayFuture = this.leaderGatewayFuture;
        return startFuture.thenAcceptAsync(ack -> this.confirmLeaderSessionIdIfStillLeader(leaderSessionId, this.jobMasterService.getAddress(), currentLeaderGatewayFuture), this.executor);
    }

    @Nonnull
    private CompletionStage<Void> jobAlreadyDone() {
        log.info("Granted leader ship but job {} has been finished. ", (Object)this.jobGraph.getJobID());
        this.jobFinishedByOther();
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<RunningJobsRegistry.JobSchedulingStatus> getJobSchedulingStatus() {
        try {
            RunningJobsRegistry.JobSchedulingStatus jobSchedulingStatus = this.runningJobsRegistry.getJobSchedulingStatus(this.jobGraph.getJobID());
            return CompletableFuture.completedFuture(jobSchedulingStatus);
        }
        catch (IOException e) {
            return FutureUtils.completedExceptionally((Throwable)new FlinkException(String.format("Could not retrieve the job scheduling status for job %s.", this.jobGraph.getJobID()), (Throwable)e));
        }
    }

    private void confirmLeaderSessionIdIfStillLeader(UUID leaderSessionId, String leaderAddress, CompletableFuture<JobMasterGateway> currentLeaderGatewayFuture) {
        if (this.leaderElectionService.hasLeadership(leaderSessionId)) {
            currentLeaderGatewayFuture.complete(this.jobMasterService.getGateway());
            this.leaderElectionService.confirmLeadership(leaderSessionId, leaderAddress);
        } else {
            log.debug("Ignoring confirmation of leader session id because {} is no longer the leader.", (Object)this.getDescription());
        }
    }

    @Override
    public void revokeLeadership() {
        this.jobMasterCreationFuture.whenComplete((ignore, throwable) -> {
            if (throwable != null) {
                this.handleJobManagerRunnerError((Throwable)new FlinkException(throwable));
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.shutdown) {
                    log.debug("Ignoring revoking leadership because JobManagerRunner is already shut down.");
                    return;
                }
                this.leadershipOperation = this.leadershipOperation.thenCompose(ignored -> {
                    Object object = this.lock;
                    synchronized (object) {
                        return this.revokeJobMasterLeadership();
                    }
                });
                this.handleException(this.leadershipOperation, "Could not suspend the job manager.");
            }
        });
    }

    private CompletableFuture<Void> revokeJobMasterLeadership() {
        log.info("JobManager for job {} ({}) at {} was revoked leadership.", new Object[]{this.jobGraph.getName(), this.jobGraph.getJobID(), this.jobMasterService.getAddress()});
        this.setNewLeaderGatewayFuture();
        return this.jobMasterService.suspend((Exception)new FlinkException("JobManager is no longer the leader.")).thenApply(FunctionUtils.nullFn());
    }

    private void handleException(CompletableFuture<Void> leadershipOperation, String message) {
        leadershipOperation.whenComplete((ignored, throwable) -> {
            if (throwable != null) {
                this.handleJobManagerRunnerError((Throwable)new FlinkException(message, throwable));
            }
        });
    }

    private void setNewLeaderGatewayFuture() {
        CompletableFuture<JobMasterGateway> oldLeaderGatewayFuture = this.leaderGatewayFuture;
        this.leaderGatewayFuture = new CompletableFuture();
        if (!oldLeaderGatewayFuture.isDone()) {
            this.leaderGatewayFuture.whenComplete((jobMasterGateway, throwable) -> {
                if (throwable != null) {
                    oldLeaderGatewayFuture.completeExceptionally((Throwable)throwable);
                } else {
                    oldLeaderGatewayFuture.complete((JobMasterGateway)jobMasterGateway);
                }
            });
        }
    }

    @Override
    public String getDescription() {
        return this.jobMasterService == null ? LeaderContender.super.getDescription() : this.jobMasterService.getAddress();
    }

    @Override
    public void handleError(Exception exception) {
        log.error("Leader Election Service encountered a fatal error.", (Throwable)exception);
        this.handleJobManagerRunnerError(exception);
    }

    @VisibleForTesting
    boolean isShutdown() {
        return this.shutdown;
    }
}

