/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.executiongraph.SlotProviderStrategy;
import org.apache.flink.runtime.instance.SlotSharingGroupId;
import org.apache.flink.runtime.jobmanager.scheduler.ScheduledUnit;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.scheduler.AbstractExecutionSlotAllocator;
import org.apache.flink.runtime.scheduler.ExecutionVertexSchedulingRequirements;
import org.apache.flink.runtime.scheduler.PreferredLocationsRetriever;
import org.apache.flink.runtime.scheduler.SlotExecutionVertexAssignment;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultExecutionSlotAllocator
extends AbstractExecutionSlotAllocator {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultExecutionSlotAllocator.class);
    private final SlotProviderStrategy slotProviderStrategy;

    DefaultExecutionSlotAllocator(SlotProviderStrategy slotProviderStrategy, PreferredLocationsRetriever preferredLocationsRetriever) {
        super(preferredLocationsRetriever);
        this.slotProviderStrategy = (SlotProviderStrategy)Preconditions.checkNotNull((Object)slotProviderStrategy);
    }

    @Override
    public List<SlotExecutionVertexAssignment> allocateSlotsFor(List<ExecutionVertexSchedulingRequirements> executionVertexSchedulingRequirements) {
        this.validateSchedulingRequirements(executionVertexSchedulingRequirements);
        ArrayList<SlotExecutionVertexAssignment> slotExecutionVertexAssignments = new ArrayList<SlotExecutionVertexAssignment>(executionVertexSchedulingRequirements.size());
        Set<AllocationID> allPreviousAllocationIds = DefaultExecutionSlotAllocator.computeAllPriorAllocationIds(executionVertexSchedulingRequirements);
        for (ExecutionVertexSchedulingRequirements schedulingRequirements : executionVertexSchedulingRequirements) {
            ExecutionVertexID executionVertexId = schedulingRequirements.getExecutionVertexId();
            SlotSharingGroupId slotSharingGroupId = schedulingRequirements.getSlotSharingGroupId();
            SlotRequestId slotRequestId = new SlotRequestId();
            CompletableFuture<LogicalSlot> slotFuture = this.allocateSlot(schedulingRequirements, slotRequestId, allPreviousAllocationIds);
            SlotExecutionVertexAssignment slotExecutionVertexAssignment = this.createAndRegisterSlotExecutionVertexAssignment(executionVertexId, slotFuture, throwable -> this.slotProviderStrategy.cancelSlotRequest(slotRequestId, slotSharingGroupId, (Throwable)throwable));
            slotExecutionVertexAssignments.add(slotExecutionVertexAssignment);
        }
        return slotExecutionVertexAssignments;
    }

    private CompletableFuture<LogicalSlot> allocateSlot(ExecutionVertexSchedulingRequirements schedulingRequirements, SlotRequestId slotRequestId, Set<AllocationID> allPreviousAllocationIds) {
        ExecutionVertexID executionVertexId = schedulingRequirements.getExecutionVertexId();
        LOG.debug("Allocate slot with id {} for execution {}", (Object)slotRequestId, (Object)executionVertexId);
        CompletableFuture<SlotProfile> slotProfileFuture = this.getSlotProfileFuture(schedulingRequirements, schedulingRequirements.getPhysicalSlotResourceProfile(), Collections.emptySet(), allPreviousAllocationIds);
        return slotProfileFuture.thenCompose(slotProfile -> this.slotProviderStrategy.allocateSlot(slotRequestId, new ScheduledUnit(executionVertexId, schedulingRequirements.getSlotSharingGroupId(), schedulingRequirements.getCoLocationConstraint()), (SlotProfile)slotProfile));
    }
}

